import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { CreateSecurityGroupRequest, CreateSecurityGroupResult } from "../models/models_1";
import { deserializeAws_ec2CreateSecurityGroupCommand, serializeAws_ec2CreateSecurityGroupCommand, } from "../protocols/Aws_ec2";
var CreateSecurityGroupCommand = (function (_super) {
    __extends(CreateSecurityGroupCommand, _super);
    function CreateSecurityGroupCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    CreateSecurityGroupCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "CreateSecurityGroupCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: CreateSecurityGroupRequest.filterSensitiveLog,
            outputFilterSensitiveLog: CreateSecurityGroupResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    CreateSecurityGroupCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2CreateSecurityGroupCommand(input, context);
    };
    CreateSecurityGroupCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2CreateSecurityGroupCommand(output, context);
    };
    return CreateSecurityGroupCommand;
}($Command));
export { CreateSecurityGroupCommand };
