import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { CreateReservedInstancesListingRequest, CreateReservedInstancesListingResult } from "../models/models_1";
import { deserializeAws_ec2CreateReservedInstancesListingCommand, serializeAws_ec2CreateReservedInstancesListingCommand, } from "../protocols/Aws_ec2";
var CreateReservedInstancesListingCommand = (function (_super) {
    __extends(CreateReservedInstancesListingCommand, _super);
    function CreateReservedInstancesListingCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    CreateReservedInstancesListingCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "CreateReservedInstancesListingCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: CreateReservedInstancesListingRequest.filterSensitiveLog,
            outputFilterSensitiveLog: CreateReservedInstancesListingResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    CreateReservedInstancesListingCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2CreateReservedInstancesListingCommand(input, context);
    };
    CreateReservedInstancesListingCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2CreateReservedInstancesListingCommand(output, context);
    };
    return CreateReservedInstancesListingCommand;
}($Command));
export { CreateReservedInstancesListingCommand };
