import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { CreatePublicIpv4PoolRequest, CreatePublicIpv4PoolResult } from "../models/models_1";
import { deserializeAws_ec2CreatePublicIpv4PoolCommand, serializeAws_ec2CreatePublicIpv4PoolCommand, } from "../protocols/Aws_ec2";
var CreatePublicIpv4PoolCommand = (function (_super) {
    __extends(CreatePublicIpv4PoolCommand, _super);
    function CreatePublicIpv4PoolCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    CreatePublicIpv4PoolCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "CreatePublicIpv4PoolCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: CreatePublicIpv4PoolRequest.filterSensitiveLog,
            outputFilterSensitiveLog: CreatePublicIpv4PoolResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    CreatePublicIpv4PoolCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2CreatePublicIpv4PoolCommand(input, context);
    };
    CreatePublicIpv4PoolCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2CreatePublicIpv4PoolCommand(output, context);
    };
    return CreatePublicIpv4PoolCommand;
}($Command));
export { CreatePublicIpv4PoolCommand };
