import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { CreateNetworkInterfaceRequest, CreateNetworkInterfaceResult } from "../models/models_1";
import { deserializeAws_ec2CreateNetworkInterfaceCommand, serializeAws_ec2CreateNetworkInterfaceCommand, } from "../protocols/Aws_ec2";
var CreateNetworkInterfaceCommand = (function (_super) {
    __extends(CreateNetworkInterfaceCommand, _super);
    function CreateNetworkInterfaceCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    CreateNetworkInterfaceCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "CreateNetworkInterfaceCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: CreateNetworkInterfaceRequest.filterSensitiveLog,
            outputFilterSensitiveLog: CreateNetworkInterfaceResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    CreateNetworkInterfaceCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2CreateNetworkInterfaceCommand(input, context);
    };
    CreateNetworkInterfaceCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2CreateNetworkInterfaceCommand(output, context);
    };
    return CreateNetworkInterfaceCommand;
}($Command));
export { CreateNetworkInterfaceCommand };
