import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { CreateNetworkAclEntryRequest } from "../models/models_1";
import { deserializeAws_ec2CreateNetworkAclEntryCommand, serializeAws_ec2CreateNetworkAclEntryCommand, } from "../protocols/Aws_ec2";
var CreateNetworkAclEntryCommand = (function (_super) {
    __extends(CreateNetworkAclEntryCommand, _super);
    function CreateNetworkAclEntryCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    CreateNetworkAclEntryCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "CreateNetworkAclEntryCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: CreateNetworkAclEntryRequest.filterSensitiveLog,
            outputFilterSensitiveLog: function (output) { return output; },
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    CreateNetworkAclEntryCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2CreateNetworkAclEntryCommand(input, context);
    };
    CreateNetworkAclEntryCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2CreateNetworkAclEntryCommand(output, context);
    };
    return CreateNetworkAclEntryCommand;
}($Command));
export { CreateNetworkAclEntryCommand };
