import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { CreateNatGatewayRequest, CreateNatGatewayResult } from "../models/models_1";
import { deserializeAws_ec2CreateNatGatewayCommand, serializeAws_ec2CreateNatGatewayCommand, } from "../protocols/Aws_ec2";
var CreateNatGatewayCommand = (function (_super) {
    __extends(CreateNatGatewayCommand, _super);
    function CreateNatGatewayCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    CreateNatGatewayCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "CreateNatGatewayCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: CreateNatGatewayRequest.filterSensitiveLog,
            outputFilterSensitiveLog: CreateNatGatewayResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    CreateNatGatewayCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2CreateNatGatewayCommand(input, context);
    };
    CreateNatGatewayCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2CreateNatGatewayCommand(output, context);
    };
    return CreateNatGatewayCommand;
}($Command));
export { CreateNatGatewayCommand };
