import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { CreateKeyPairRequest, KeyPair } from "../models/models_1";
import { deserializeAws_ec2CreateKeyPairCommand, serializeAws_ec2CreateKeyPairCommand } from "../protocols/Aws_ec2";
var CreateKeyPairCommand = (function (_super) {
    __extends(CreateKeyPairCommand, _super);
    function CreateKeyPairCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    CreateKeyPairCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "CreateKeyPairCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: CreateKeyPairRequest.filterSensitiveLog,
            outputFilterSensitiveLog: KeyPair.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    CreateKeyPairCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2CreateKeyPairCommand(input, context);
    };
    CreateKeyPairCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2CreateKeyPairCommand(output, context);
    };
    return CreateKeyPairCommand;
}($Command));
export { CreateKeyPairCommand };
