import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { CreateIpamRequest, CreateIpamResult } from "../models/models_1";
import { deserializeAws_ec2CreateIpamCommand, serializeAws_ec2CreateIpamCommand } from "../protocols/Aws_ec2";
var CreateIpamCommand = (function (_super) {
    __extends(CreateIpamCommand, _super);
    function CreateIpamCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    CreateIpamCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "CreateIpamCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: CreateIpamRequest.filterSensitiveLog,
            outputFilterSensitiveLog: CreateIpamResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    CreateIpamCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2CreateIpamCommand(input, context);
    };
    CreateIpamCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2CreateIpamCommand(output, context);
    };
    return CreateIpamCommand;
}($Command));
export { CreateIpamCommand };
