import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { CreateInternetGatewayRequest, CreateInternetGatewayResult } from "../models/models_1";
import { deserializeAws_ec2CreateInternetGatewayCommand, serializeAws_ec2CreateInternetGatewayCommand, } from "../protocols/Aws_ec2";
var CreateInternetGatewayCommand = (function (_super) {
    __extends(CreateInternetGatewayCommand, _super);
    function CreateInternetGatewayCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    CreateInternetGatewayCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "CreateInternetGatewayCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: CreateInternetGatewayRequest.filterSensitiveLog,
            outputFilterSensitiveLog: CreateInternetGatewayResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    CreateInternetGatewayCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2CreateInternetGatewayCommand(input, context);
    };
    CreateInternetGatewayCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2CreateInternetGatewayCommand(output, context);
    };
    return CreateInternetGatewayCommand;
}($Command));
export { CreateInternetGatewayCommand };
