import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { CreateInstanceExportTaskRequest, CreateInstanceExportTaskResult } from "../models/models_1";
import { deserializeAws_ec2CreateInstanceExportTaskCommand, serializeAws_ec2CreateInstanceExportTaskCommand, } from "../protocols/Aws_ec2";
var CreateInstanceExportTaskCommand = (function (_super) {
    __extends(CreateInstanceExportTaskCommand, _super);
    function CreateInstanceExportTaskCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    CreateInstanceExportTaskCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "CreateInstanceExportTaskCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: CreateInstanceExportTaskRequest.filterSensitiveLog,
            outputFilterSensitiveLog: CreateInstanceExportTaskResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    CreateInstanceExportTaskCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2CreateInstanceExportTaskCommand(input, context);
    };
    CreateInstanceExportTaskCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2CreateInstanceExportTaskCommand(output, context);
    };
    return CreateInstanceExportTaskCommand;
}($Command));
export { CreateInstanceExportTaskCommand };
