import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { CreateFlowLogsRequest, CreateFlowLogsResult } from "../models/models_1";
import { deserializeAws_ec2CreateFlowLogsCommand, serializeAws_ec2CreateFlowLogsCommand } from "../protocols/Aws_ec2";
var CreateFlowLogsCommand = (function (_super) {
    __extends(CreateFlowLogsCommand, _super);
    function CreateFlowLogsCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    CreateFlowLogsCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "CreateFlowLogsCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: CreateFlowLogsRequest.filterSensitiveLog,
            outputFilterSensitiveLog: CreateFlowLogsResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    CreateFlowLogsCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2CreateFlowLogsCommand(input, context);
    };
    CreateFlowLogsCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2CreateFlowLogsCommand(output, context);
    };
    return CreateFlowLogsCommand;
}($Command));
export { CreateFlowLogsCommand };
