import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { CreateFleetRequest, CreateFleetResult } from "../models/models_1";
import { deserializeAws_ec2CreateFleetCommand, serializeAws_ec2CreateFleetCommand } from "../protocols/Aws_ec2";
var CreateFleetCommand = (function (_super) {
    __extends(CreateFleetCommand, _super);
    function CreateFleetCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    CreateFleetCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "CreateFleetCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: CreateFleetRequest.filterSensitiveLog,
            outputFilterSensitiveLog: CreateFleetResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    CreateFleetCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2CreateFleetCommand(input, context);
    };
    CreateFleetCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2CreateFleetCommand(output, context);
    };
    return CreateFleetCommand;
}($Command));
export { CreateFleetCommand };
