import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { CreateEgressOnlyInternetGatewayRequest, CreateEgressOnlyInternetGatewayResult } from "../models/models_0";
import { deserializeAws_ec2CreateEgressOnlyInternetGatewayCommand, serializeAws_ec2CreateEgressOnlyInternetGatewayCommand, } from "../protocols/Aws_ec2";
var CreateEgressOnlyInternetGatewayCommand = (function (_super) {
    __extends(CreateEgressOnlyInternetGatewayCommand, _super);
    function CreateEgressOnlyInternetGatewayCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    CreateEgressOnlyInternetGatewayCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "CreateEgressOnlyInternetGatewayCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: CreateEgressOnlyInternetGatewayRequest.filterSensitiveLog,
            outputFilterSensitiveLog: CreateEgressOnlyInternetGatewayResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    CreateEgressOnlyInternetGatewayCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2CreateEgressOnlyInternetGatewayCommand(input, context);
    };
    CreateEgressOnlyInternetGatewayCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2CreateEgressOnlyInternetGatewayCommand(output, context);
    };
    return CreateEgressOnlyInternetGatewayCommand;
}($Command));
export { CreateEgressOnlyInternetGatewayCommand };
