import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { CreateDhcpOptionsRequest, CreateDhcpOptionsResult } from "../models/models_0";
import { deserializeAws_ec2CreateDhcpOptionsCommand, serializeAws_ec2CreateDhcpOptionsCommand, } from "../protocols/Aws_ec2";
var CreateDhcpOptionsCommand = (function (_super) {
    __extends(CreateDhcpOptionsCommand, _super);
    function CreateDhcpOptionsCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    CreateDhcpOptionsCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "CreateDhcpOptionsCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: CreateDhcpOptionsRequest.filterSensitiveLog,
            outputFilterSensitiveLog: CreateDhcpOptionsResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    CreateDhcpOptionsCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2CreateDhcpOptionsCommand(input, context);
    };
    CreateDhcpOptionsCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2CreateDhcpOptionsCommand(output, context);
    };
    return CreateDhcpOptionsCommand;
}($Command));
export { CreateDhcpOptionsCommand };
