import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { CreateDefaultVpcRequest, CreateDefaultVpcResult } from "../models/models_0";
import { deserializeAws_ec2CreateDefaultVpcCommand, serializeAws_ec2CreateDefaultVpcCommand, } from "../protocols/Aws_ec2";
var CreateDefaultVpcCommand = (function (_super) {
    __extends(CreateDefaultVpcCommand, _super);
    function CreateDefaultVpcCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    CreateDefaultVpcCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "CreateDefaultVpcCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: CreateDefaultVpcRequest.filterSensitiveLog,
            outputFilterSensitiveLog: CreateDefaultVpcResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    CreateDefaultVpcCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2CreateDefaultVpcCommand(input, context);
    };
    CreateDefaultVpcCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2CreateDefaultVpcCommand(output, context);
    };
    return CreateDefaultVpcCommand;
}($Command));
export { CreateDefaultVpcCommand };
