import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { CreateClientVpnRouteRequest, CreateClientVpnRouteResult } from "../models/models_0";
import { deserializeAws_ec2CreateClientVpnRouteCommand, serializeAws_ec2CreateClientVpnRouteCommand, } from "../protocols/Aws_ec2";
var CreateClientVpnRouteCommand = (function (_super) {
    __extends(CreateClientVpnRouteCommand, _super);
    function CreateClientVpnRouteCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    CreateClientVpnRouteCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "CreateClientVpnRouteCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: CreateClientVpnRouteRequest.filterSensitiveLog,
            outputFilterSensitiveLog: CreateClientVpnRouteResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    CreateClientVpnRouteCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2CreateClientVpnRouteCommand(input, context);
    };
    CreateClientVpnRouteCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2CreateClientVpnRouteCommand(output, context);
    };
    return CreateClientVpnRouteCommand;
}($Command));
export { CreateClientVpnRouteCommand };
