import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { CreateClientVpnEndpointRequest, CreateClientVpnEndpointResult } from "../models/models_0";
import { deserializeAws_ec2CreateClientVpnEndpointCommand, serializeAws_ec2CreateClientVpnEndpointCommand, } from "../protocols/Aws_ec2";
var CreateClientVpnEndpointCommand = (function (_super) {
    __extends(CreateClientVpnEndpointCommand, _super);
    function CreateClientVpnEndpointCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    CreateClientVpnEndpointCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "CreateClientVpnEndpointCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: CreateClientVpnEndpointRequest.filterSensitiveLog,
            outputFilterSensitiveLog: CreateClientVpnEndpointResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    CreateClientVpnEndpointCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2CreateClientVpnEndpointCommand(input, context);
    };
    CreateClientVpnEndpointCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2CreateClientVpnEndpointCommand(output, context);
    };
    return CreateClientVpnEndpointCommand;
}($Command));
export { CreateClientVpnEndpointCommand };
