import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { CreateCapacityReservationFleetRequest, CreateCapacityReservationFleetResult } from "../models/models_0";
import { deserializeAws_ec2CreateCapacityReservationFleetCommand, serializeAws_ec2CreateCapacityReservationFleetCommand, } from "../protocols/Aws_ec2";
var CreateCapacityReservationFleetCommand = (function (_super) {
    __extends(CreateCapacityReservationFleetCommand, _super);
    function CreateCapacityReservationFleetCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    CreateCapacityReservationFleetCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "CreateCapacityReservationFleetCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: CreateCapacityReservationFleetRequest.filterSensitiveLog,
            outputFilterSensitiveLog: CreateCapacityReservationFleetResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    CreateCapacityReservationFleetCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2CreateCapacityReservationFleetCommand(input, context);
    };
    CreateCapacityReservationFleetCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2CreateCapacityReservationFleetCommand(output, context);
    };
    return CreateCapacityReservationFleetCommand;
}($Command));
export { CreateCapacityReservationFleetCommand };
