import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { CreateCapacityReservationRequest, CreateCapacityReservationResult } from "../models/models_0";
import { deserializeAws_ec2CreateCapacityReservationCommand, serializeAws_ec2CreateCapacityReservationCommand, } from "../protocols/Aws_ec2";
var CreateCapacityReservationCommand = (function (_super) {
    __extends(CreateCapacityReservationCommand, _super);
    function CreateCapacityReservationCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    CreateCapacityReservationCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "CreateCapacityReservationCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: CreateCapacityReservationRequest.filterSensitiveLog,
            outputFilterSensitiveLog: CreateCapacityReservationResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    CreateCapacityReservationCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2CreateCapacityReservationCommand(input, context);
    };
    CreateCapacityReservationCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2CreateCapacityReservationCommand(output, context);
    };
    return CreateCapacityReservationCommand;
}($Command));
export { CreateCapacityReservationCommand };
