import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { CancelSpotInstanceRequestsRequest, CancelSpotInstanceRequestsResult } from "../models/models_0";
import { deserializeAws_ec2CancelSpotInstanceRequestsCommand, serializeAws_ec2CancelSpotInstanceRequestsCommand, } from "../protocols/Aws_ec2";
var CancelSpotInstanceRequestsCommand = (function (_super) {
    __extends(CancelSpotInstanceRequestsCommand, _super);
    function CancelSpotInstanceRequestsCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    CancelSpotInstanceRequestsCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "CancelSpotInstanceRequestsCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: CancelSpotInstanceRequestsRequest.filterSensitiveLog,
            outputFilterSensitiveLog: CancelSpotInstanceRequestsResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    CancelSpotInstanceRequestsCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2CancelSpotInstanceRequestsCommand(input, context);
    };
    CancelSpotInstanceRequestsCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2CancelSpotInstanceRequestsCommand(output, context);
    };
    return CancelSpotInstanceRequestsCommand;
}($Command));
export { CancelSpotInstanceRequestsCommand };
