import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { CancelCapacityReservationFleetsRequest, CancelCapacityReservationFleetsResult } from "../models/models_0";
import { deserializeAws_ec2CancelCapacityReservationFleetsCommand, serializeAws_ec2CancelCapacityReservationFleetsCommand, } from "../protocols/Aws_ec2";
var CancelCapacityReservationFleetsCommand = (function (_super) {
    __extends(CancelCapacityReservationFleetsCommand, _super);
    function CancelCapacityReservationFleetsCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    CancelCapacityReservationFleetsCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "CancelCapacityReservationFleetsCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: CancelCapacityReservationFleetsRequest.filterSensitiveLog,
            outputFilterSensitiveLog: CancelCapacityReservationFleetsResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    CancelCapacityReservationFleetsCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2CancelCapacityReservationFleetsCommand(input, context);
    };
    CancelCapacityReservationFleetsCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2CancelCapacityReservationFleetsCommand(output, context);
    };
    return CancelCapacityReservationFleetsCommand;
}($Command));
export { CancelCapacityReservationFleetsCommand };
