import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { BundleInstanceRequest, BundleInstanceResult } from "../models/models_0";
import { deserializeAws_ec2BundleInstanceCommand, serializeAws_ec2BundleInstanceCommand } from "../protocols/Aws_ec2";
var BundleInstanceCommand = (function (_super) {
    __extends(BundleInstanceCommand, _super);
    function BundleInstanceCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    BundleInstanceCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "BundleInstanceCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: BundleInstanceRequest.filterSensitiveLog,
            outputFilterSensitiveLog: BundleInstanceResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    BundleInstanceCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2BundleInstanceCommand(input, context);
    };
    BundleInstanceCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2BundleInstanceCommand(output, context);
    };
    return BundleInstanceCommand;
}($Command));
export { BundleInstanceCommand };
