import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { AssociateTrunkInterfaceRequest, AssociateTrunkInterfaceResult } from "../models/models_0";
import { deserializeAws_ec2AssociateTrunkInterfaceCommand, serializeAws_ec2AssociateTrunkInterfaceCommand, } from "../protocols/Aws_ec2";
var AssociateTrunkInterfaceCommand = (function (_super) {
    __extends(AssociateTrunkInterfaceCommand, _super);
    function AssociateTrunkInterfaceCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    AssociateTrunkInterfaceCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "AssociateTrunkInterfaceCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: AssociateTrunkInterfaceRequest.filterSensitiveLog,
            outputFilterSensitiveLog: AssociateTrunkInterfaceResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    AssociateTrunkInterfaceCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2AssociateTrunkInterfaceCommand(input, context);
    };
    AssociateTrunkInterfaceCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2AssociateTrunkInterfaceCommand(output, context);
    };
    return AssociateTrunkInterfaceCommand;
}($Command));
export { AssociateTrunkInterfaceCommand };
