import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { AssociateInstanceEventWindowRequest, AssociateInstanceEventWindowResult } from "../models/models_0";
import { deserializeAws_ec2AssociateInstanceEventWindowCommand, serializeAws_ec2AssociateInstanceEventWindowCommand, } from "../protocols/Aws_ec2";
var AssociateInstanceEventWindowCommand = (function (_super) {
    __extends(AssociateInstanceEventWindowCommand, _super);
    function AssociateInstanceEventWindowCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    AssociateInstanceEventWindowCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "AssociateInstanceEventWindowCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: AssociateInstanceEventWindowRequest.filterSensitiveLog,
            outputFilterSensitiveLog: AssociateInstanceEventWindowResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    AssociateInstanceEventWindowCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2AssociateInstanceEventWindowCommand(input, context);
    };
    AssociateInstanceEventWindowCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2AssociateInstanceEventWindowCommand(output, context);
    };
    return AssociateInstanceEventWindowCommand;
}($Command));
export { AssociateInstanceEventWindowCommand };
