import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { AssociateEnclaveCertificateIamRoleRequest, AssociateEnclaveCertificateIamRoleResult, } from "../models/models_0";
import { deserializeAws_ec2AssociateEnclaveCertificateIamRoleCommand, serializeAws_ec2AssociateEnclaveCertificateIamRoleCommand, } from "../protocols/Aws_ec2";
var AssociateEnclaveCertificateIamRoleCommand = (function (_super) {
    __extends(AssociateEnclaveCertificateIamRoleCommand, _super);
    function AssociateEnclaveCertificateIamRoleCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    AssociateEnclaveCertificateIamRoleCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "AssociateEnclaveCertificateIamRoleCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: AssociateEnclaveCertificateIamRoleRequest.filterSensitiveLog,
            outputFilterSensitiveLog: AssociateEnclaveCertificateIamRoleResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    AssociateEnclaveCertificateIamRoleCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2AssociateEnclaveCertificateIamRoleCommand(input, context);
    };
    AssociateEnclaveCertificateIamRoleCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2AssociateEnclaveCertificateIamRoleCommand(output, context);
    };
    return AssociateEnclaveCertificateIamRoleCommand;
}($Command));
export { AssociateEnclaveCertificateIamRoleCommand };
