import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { AssociateDhcpOptionsRequest } from "../models/models_0";
import { deserializeAws_ec2AssociateDhcpOptionsCommand, serializeAws_ec2AssociateDhcpOptionsCommand, } from "../protocols/Aws_ec2";
var AssociateDhcpOptionsCommand = (function (_super) {
    __extends(AssociateDhcpOptionsCommand, _super);
    function AssociateDhcpOptionsCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    AssociateDhcpOptionsCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "AssociateDhcpOptionsCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: AssociateDhcpOptionsRequest.filterSensitiveLog,
            outputFilterSensitiveLog: function (output) { return output; },
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    AssociateDhcpOptionsCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2AssociateDhcpOptionsCommand(input, context);
    };
    AssociateDhcpOptionsCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2AssociateDhcpOptionsCommand(output, context);
    };
    return AssociateDhcpOptionsCommand;
}($Command));
export { AssociateDhcpOptionsCommand };
