import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { AllocateHostsRequest, AllocateHostsResult } from "../models/models_0";
import { deserializeAws_ec2AllocateHostsCommand, serializeAws_ec2AllocateHostsCommand } from "../protocols/Aws_ec2";
var AllocateHostsCommand = (function (_super) {
    __extends(AllocateHostsCommand, _super);
    function AllocateHostsCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    AllocateHostsCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "AllocateHostsCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: AllocateHostsRequest.filterSensitiveLog,
            outputFilterSensitiveLog: AllocateHostsResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    AllocateHostsCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2AllocateHostsCommand(input, context);
    };
    AllocateHostsCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2AllocateHostsCommand(output, context);
    };
    return AllocateHostsCommand;
}($Command));
export { AllocateHostsCommand };
