import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { AcceptVpcPeeringConnectionRequest, AcceptVpcPeeringConnectionResult } from "../models/models_0";
import { deserializeAws_ec2AcceptVpcPeeringConnectionCommand, serializeAws_ec2AcceptVpcPeeringConnectionCommand, } from "../protocols/Aws_ec2";
var AcceptVpcPeeringConnectionCommand = (function (_super) {
    __extends(AcceptVpcPeeringConnectionCommand, _super);
    function AcceptVpcPeeringConnectionCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    AcceptVpcPeeringConnectionCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "AcceptVpcPeeringConnectionCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: AcceptVpcPeeringConnectionRequest.filterSensitiveLog,
            outputFilterSensitiveLog: AcceptVpcPeeringConnectionResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    AcceptVpcPeeringConnectionCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2AcceptVpcPeeringConnectionCommand(input, context);
    };
    AcceptVpcPeeringConnectionCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2AcceptVpcPeeringConnectionCommand(output, context);
    };
    return AcceptVpcPeeringConnectionCommand;
}($Command));
export { AcceptVpcPeeringConnectionCommand };
