import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { AcceptVpcEndpointConnectionsRequest, AcceptVpcEndpointConnectionsResult } from "../models/models_0";
import { deserializeAws_ec2AcceptVpcEndpointConnectionsCommand, serializeAws_ec2AcceptVpcEndpointConnectionsCommand, } from "../protocols/Aws_ec2";
var AcceptVpcEndpointConnectionsCommand = (function (_super) {
    __extends(AcceptVpcEndpointConnectionsCommand, _super);
    function AcceptVpcEndpointConnectionsCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    AcceptVpcEndpointConnectionsCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "AcceptVpcEndpointConnectionsCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: AcceptVpcEndpointConnectionsRequest.filterSensitiveLog,
            outputFilterSensitiveLog: AcceptVpcEndpointConnectionsResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    AcceptVpcEndpointConnectionsCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2AcceptVpcEndpointConnectionsCommand(input, context);
    };
    AcceptVpcEndpointConnectionsCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2AcceptVpcEndpointConnectionsCommand(output, context);
    };
    return AcceptVpcEndpointConnectionsCommand;
}($Command));
export { AcceptVpcEndpointConnectionsCommand };
