import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { AcceptTransitGatewayVpcAttachmentRequest, AcceptTransitGatewayVpcAttachmentResult } from "../models/models_0";
import { deserializeAws_ec2AcceptTransitGatewayVpcAttachmentCommand, serializeAws_ec2AcceptTransitGatewayVpcAttachmentCommand, } from "../protocols/Aws_ec2";
var AcceptTransitGatewayVpcAttachmentCommand = (function (_super) {
    __extends(AcceptTransitGatewayVpcAttachmentCommand, _super);
    function AcceptTransitGatewayVpcAttachmentCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    AcceptTransitGatewayVpcAttachmentCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "AcceptTransitGatewayVpcAttachmentCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: AcceptTransitGatewayVpcAttachmentRequest.filterSensitiveLog,
            outputFilterSensitiveLog: AcceptTransitGatewayVpcAttachmentResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    AcceptTransitGatewayVpcAttachmentCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2AcceptTransitGatewayVpcAttachmentCommand(input, context);
    };
    AcceptTransitGatewayVpcAttachmentCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2AcceptTransitGatewayVpcAttachmentCommand(output, context);
    };
    return AcceptTransitGatewayVpcAttachmentCommand;
}($Command));
export { AcceptTransitGatewayVpcAttachmentCommand };
