"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.waitUntilVolumeDeleted = exports.waitForVolumeDeleted = void 0;
const util_waiter_1 = require("@aws-sdk/util-waiter");
const DescribeVolumesCommand_1 = require("../commands/DescribeVolumesCommand");
const checkState = async (client, input) => {
    let reason;
    try {
        const result = await client.send(new DescribeVolumesCommand_1.DescribeVolumesCommand(input));
        reason = result;
        try {
            const returnComparator = () => {
                const flat_1 = [].concat(...result.Volumes);
                const projection_3 = flat_1.map((element_2) => {
                    return element_2.State;
                });
                return projection_3;
            };
            let allStringEq_5 = returnComparator().length > 0;
            for (const element_4 of returnComparator()) {
                allStringEq_5 = allStringEq_5 && element_4 == "deleted";
            }
            if (allStringEq_5) {
                return { state: util_waiter_1.WaiterState.SUCCESS, reason };
            }
        }
        catch (e) { }
    }
    catch (exception) {
        reason = exception;
        if (exception.name && exception.name == "InvalidVolume.NotFound") {
            return { state: util_waiter_1.WaiterState.SUCCESS, reason };
        }
    }
    return { state: util_waiter_1.WaiterState.RETRY, reason };
};
const waitForVolumeDeleted = async (params, input) => {
    const serviceDefaults = { minDelay: 15, maxDelay: 120 };
    return util_waiter_1.createWaiter({ ...serviceDefaults, ...params }, input, checkState);
};
exports.waitForVolumeDeleted = waitForVolumeDeleted;
const waitUntilVolumeDeleted = async (params, input) => {
    const serviceDefaults = { minDelay: 15, maxDelay: 120 };
    const result = await util_waiter_1.createWaiter({ ...serviceDefaults, ...params }, input, checkState);
    return util_waiter_1.checkExceptions(result);
};
exports.waitUntilVolumeDeleted = waitUntilVolumeDeleted;
