"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.waitUntilBundleTaskComplete = exports.waitForBundleTaskComplete = void 0;
const util_waiter_1 = require("@aws-sdk/util-waiter");
const DescribeBundleTasksCommand_1 = require("../commands/DescribeBundleTasksCommand");
const checkState = async (client, input) => {
    let reason;
    try {
        const result = await client.send(new DescribeBundleTasksCommand_1.DescribeBundleTasksCommand(input));
        reason = result;
        try {
            const returnComparator = () => {
                const flat_1 = [].concat(...result.BundleTasks);
                const projection_3 = flat_1.map((element_2) => {
                    return element_2.State;
                });
                return projection_3;
            };
            let allStringEq_5 = returnComparator().length > 0;
            for (const element_4 of returnComparator()) {
                allStringEq_5 = allStringEq_5 && element_4 == "complete";
            }
            if (allStringEq_5) {
                return { state: util_waiter_1.WaiterState.SUCCESS, reason };
            }
        }
        catch (e) { }
        try {
            const returnComparator = () => {
                const flat_1 = [].concat(...result.BundleTasks);
                const projection_3 = flat_1.map((element_2) => {
                    return element_2.State;
                });
                return projection_3;
            };
            for (const anyStringEq_4 of returnComparator()) {
                if (anyStringEq_4 == "failed") {
                    return { state: util_waiter_1.WaiterState.FAILURE, reason };
                }
            }
        }
        catch (e) { }
    }
    catch (exception) {
        reason = exception;
    }
    return { state: util_waiter_1.WaiterState.RETRY, reason };
};
const waitForBundleTaskComplete = async (params, input) => {
    const serviceDefaults = { minDelay: 15, maxDelay: 120 };
    return util_waiter_1.createWaiter({ ...serviceDefaults, ...params }, input, checkState);
};
exports.waitForBundleTaskComplete = waitForBundleTaskComplete;
const waitUntilBundleTaskComplete = async (params, input) => {
    const serviceDefaults = { minDelay: 15, maxDelay: 120 };
    const result = await util_waiter_1.createWaiter({ ...serviceDefaults, ...params }, input, checkState);
    return util_waiter_1.checkExceptions(result);
};
exports.waitUntilBundleTaskComplete = waitUntilBundleTaskComplete;
