"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.UpdateSecurityGroupRuleDescriptionsIngressCommand = void 0;
const middleware_serde_1 = require("@aws-sdk/middleware-serde");
const smithy_client_1 = require("@aws-sdk/smithy-client");
const models_6_1 = require("../models/models_6");
const Aws_ec2_1 = require("../protocols/Aws_ec2");
class UpdateSecurityGroupRuleDescriptionsIngressCommand extends smithy_client_1.Command {
    constructor(input) {
        super();
        this.input = input;
    }
    resolveMiddleware(clientStack, configuration, options) {
        this.middlewareStack.use(middleware_serde_1.getSerdePlugin(configuration, this.serialize, this.deserialize));
        const stack = clientStack.concat(this.middlewareStack);
        const { logger } = configuration;
        const clientName = "EC2Client";
        const commandName = "UpdateSecurityGroupRuleDescriptionsIngressCommand";
        const handlerExecutionContext = {
            logger,
            clientName,
            commandName,
            inputFilterSensitiveLog: models_6_1.UpdateSecurityGroupRuleDescriptionsIngressRequest.filterSensitiveLog,
            outputFilterSensitiveLog: models_6_1.UpdateSecurityGroupRuleDescriptionsIngressResult.filterSensitiveLog,
        };
        const { requestHandler } = configuration;
        return stack.resolve((request) => requestHandler.handle(request.request, options || {}), handlerExecutionContext);
    }
    serialize(input, context) {
        return Aws_ec2_1.serializeAws_ec2UpdateSecurityGroupRuleDescriptionsIngressCommand(input, context);
    }
    deserialize(output, context) {
        return Aws_ec2_1.deserializeAws_ec2UpdateSecurityGroupRuleDescriptionsIngressCommand(output, context);
    }
}
exports.UpdateSecurityGroupRuleDescriptionsIngressCommand = UpdateSecurityGroupRuleDescriptionsIngressCommand;
