"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DeregisterTransitGatewayMulticastGroupMembersCommand = void 0;
const middleware_serde_1 = require("@aws-sdk/middleware-serde");
const smithy_client_1 = require("@aws-sdk/smithy-client");
const models_2_1 = require("../models/models_2");
const Aws_ec2_1 = require("../protocols/Aws_ec2");
class DeregisterTransitGatewayMulticastGroupMembersCommand extends smithy_client_1.Command {
    constructor(input) {
        super();
        this.input = input;
    }
    resolveMiddleware(clientStack, configuration, options) {
        this.middlewareStack.use(middleware_serde_1.getSerdePlugin(configuration, this.serialize, this.deserialize));
        const stack = clientStack.concat(this.middlewareStack);
        const { logger } = configuration;
        const clientName = "EC2Client";
        const commandName = "DeregisterTransitGatewayMulticastGroupMembersCommand";
        const handlerExecutionContext = {
            logger,
            clientName,
            commandName,
            inputFilterSensitiveLog: models_2_1.DeregisterTransitGatewayMulticastGroupMembersRequest.filterSensitiveLog,
            outputFilterSensitiveLog: models_2_1.DeregisterTransitGatewayMulticastGroupMembersResult.filterSensitiveLog,
        };
        const { requestHandler } = configuration;
        return stack.resolve((request) => requestHandler.handle(request.request, options || {}), handlerExecutionContext);
    }
    serialize(input, context) {
        return Aws_ec2_1.serializeAws_ec2DeregisterTransitGatewayMulticastGroupMembersCommand(input, context);
    }
    deserialize(output, context) {
        return Aws_ec2_1.deserializeAws_ec2DeregisterTransitGatewayMulticastGroupMembersCommand(output, context);
    }
}
exports.DeregisterTransitGatewayMulticastGroupMembersCommand = DeregisterTransitGatewayMulticastGroupMembersCommand;
