"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Sha256 = void 0;
var util_1 = require("@aws-crypto/util");
var constants_1 = require("./constants");
var util_locate_window_1 = require("@aws-sdk/util-locate-window");
var Sha256 = /** @class */ (function () {
    function Sha256(secret) {
        this.toHash = new Uint8Array(0);
        if (secret !== void 0) {
            this.key = new Promise(function (resolve, reject) {
                (0, util_locate_window_1.locateWindow)()
                    .crypto.subtle.importKey("raw", (0, util_1.convertToBuffer)(secret), constants_1.SHA_256_HMAC_ALGO, false, ["sign"])
                    .then(resolve, reject);
            });
            this.key.catch(function () { });
        }
    }
    Sha256.prototype.update = function (data) {
        if ((0, util_1.isEmptyData)(data)) {
            return;
        }
        var update = (0, util_1.convertToBuffer)(data);
        var typedArray = new Uint8Array(this.toHash.byteLength + update.byteLength);
        typedArray.set(this.toHash, 0);
        typedArray.set(update, this.toHash.byteLength);
        this.toHash = typedArray;
    };
    Sha256.prototype.digest = function () {
        var _this = this;
        if (this.key) {
            return this.key.then(function (key) {
                return (0, util_locate_window_1.locateWindow)()
                    .crypto.subtle.sign(constants_1.SHA_256_HMAC_ALGO, key, _this.toHash)
                    .then(function (data) { return new Uint8Array(data); });
            });
        }
        if ((0, util_1.isEmptyData)(this.toHash)) {
            return Promise.resolve(constants_1.EMPTY_DATA_SHA_256);
        }
        return Promise.resolve()
            .then(function () {
            return (0, util_locate_window_1.locateWindow)().crypto.subtle.digest(constants_1.SHA_256_HASH, _this.toHash);
        })
            .then(function (data) { return Promise.resolve(new Uint8Array(data)); });
    };
    return Sha256;
}());
exports.Sha256 = Sha256;
//# sourceMappingURL=data:application/json;base64,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