"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ServerInstance = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const fs = require("fs");
const path = require("path");
const ec2 = require("@aws-cdk/aws-ec2");
const ecr = require("@aws-cdk/aws-ecr");
const aws_ecr_assets_1 = require("@aws-cdk/aws-ecr-assets");
const iam = require("@aws-cdk/aws-iam");
const core_1 = require("@aws-cdk/core");
/**
 * @stability stable
 */
class ServerInstance extends core_1.Construct {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        var _b, _c, _d, _e;
        super(scope, id);
        this.gameServerName = props.gameServerName;
        this.serverZipPath = props.serverZipPath;
        this.vpc = props.vpc;
        this.ec2InstanceName = (_b = props.ec2InstanceName) !== null && _b !== void 0 ? _b : props.gameServerName;
        this.ec2InstanceClass = (_c = props.ec2InstanceClass) !== null && _c !== void 0 ? _c : ec2.InstanceClass.C5A;
        this.ec2InstanceSize = (_d = props.ec2InstanceSize) !== null && _d !== void 0 ? _d : ec2.InstanceSize.LARGE;
        this.fullInstanceType = new ec2.InstanceType(`${this.ec2InstanceClass}.${this.ec2InstanceSize}`);
        this.ec2Ami = ec2.MachineImage.latestAmazonLinux();
        this.instanceRole = new iam.Role(this, 'ec2-pull-ecr', {
            assumedBy: new iam.ServicePrincipal('ec2.amazonaws.com'),
        });
        this.instanceRole.addManagedPolicy(iam.ManagedPolicy.fromAwsManagedPolicyName('AmazonSSMManagedInstanceCore'));
        this.instanceRole.addManagedPolicy(iam.ManagedPolicy.fromAwsManagedPolicyName('AdministratorAccess')); // TODO: NEED TO GIVE ACCESS TO ONLY ECR ASSETS
        // Docker
        const repoName = 'image-hub';
        const serverZipDirectory = path.parse(this.serverZipPath).dir;
        const serverZipFile = path.parse(this.serverZipPath).base;
        const serverAsset = new core_1.AssetStaging(this, 'docker-file-asset', {
            sourcePath: serverZipDirectory,
            bundling: {
                image: core_1.DockerImage.fromRegistry('openjdk:8'),
                command: [
                    'sh', '-c', 'cp * /asset-output',
                ],
                outputType: core_1.BundlingOutput.NOT_ARCHIVED,
            },
        });
        fs.writeFileSync(`${serverAsset.absoluteStagedPath}/Dockerfile`, `
FROM openjdk:8
RUN ls -ltra
COPY ${serverZipFile} /app/modpack.zip
WORKDIR /app
RUN unzip modpack.zip && chmod +x ServerStart.sh && echo eula=true > eula.txt
RUN cat eula.txt
CMD  ./ServerStart.sh
    `);
        this.dockerFile = new aws_ecr_assets_1.DockerImageAsset(this, 'docker-image', {
            directory: serverAsset.absoluteStagedPath,
        });
        // EC2
        this.customUserDataScript = (_e = props.customUserDataScript) !== null && _e !== void 0 ? _e : generateUserDataScript(this.dockerFile.imageUri);
        this.defaultSecurityGroup = new ec2.SecurityGroup(this, 'default-security-group', {
            securityGroupName: 'sec-group',
            vpc: this.vpc,
            allowAllOutbound: true,
        });
        this.defaultSecurityGroup.addIngressRule(ec2.Peer.anyIpv4(), ec2.Port.tcp(25565));
        this.defaultSecurityGroup.addIngressRule(ec2.Peer.anyIpv4(), ec2.Port.udp(25565));
        this.ec2Instance = new ec2.Instance(this, 'server', {
            instanceName: this.ec2InstanceName,
            vpc: this.vpc,
            instanceType: this.fullInstanceType,
            machineImage: this.ec2Ami,
            userData: this.customUserDataScript,
            role: this.instanceRole,
            securityGroup: this.defaultSecurityGroup,
        });
        new ec2.CfnEIP(this, 'elastic-ip', {
            instanceId: this.ec2Instance.instanceId,
        });
        // ECR
        this.ecrRepo = new ecr.Repository(this, 'ecr-repo', {
            repositoryName: repoName,
            removalPolicy: core_1.RemovalPolicy.DESTROY,
        });
        this.ecrRepo.grantPull(this.instanceRole);
        // TODO: Fucking fix
        // new ecrdeploy.ECRDeployment(this, 'whycome', {
        //   src: new ecrdeploy.DockerImageName(this.dockerFile.imageUri),
        //   dest: new ecrdeploy.DockerImageName(`${Aws.ACCOUNT_ID}.dkr.ecr.${Aws.REGION}.com/${repoName}:latest`),
        // });
    }
}
exports.ServerInstance = ServerInstance;
_a = JSII_RTTI_SYMBOL_1;
ServerInstance[_a] = { fqn: "cdk-minecraft-server.ServerInstance", version: "0.0.2" };
function generateUserDataScript(serverDockerImage) {
    let userData = ec2.UserData.forLinux({});
    userData.addCommands('sudo yum update -y', 'sudo yum install -y docker', 'sudo service docker start', 'sudo usermod -a -G docker ec2-user', `aws ecr get-login-password --region ${core_1.Aws.REGION} | docker login --username AWS --password-stdin ${core_1.Aws.ACCOUNT_ID}.dkr.ecr.${core_1.Aws.REGION}.amazonaws.com`, `sudo docker pull ${serverDockerImage}`, `sudo docker run -d --restart always -p 25565:25565 --name mc-server ${serverDockerImage}`);
    return userData;
}
//# sourceMappingURL=data:application/json;base64,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