import * as ec2 from '@aws-cdk/aws-ec2';
import * as ecr from '@aws-cdk/aws-ecr';
import { DockerImageAsset } from '@aws-cdk/aws-ecr-assets';
import * as iam from '@aws-cdk/aws-iam';
import { Construct } from '@aws-cdk/core';
/**
 * @stability stable
 */
export interface ServerInstanceProps {
    /**
     * @stability stable
     */
    readonly gameServerName: string;
    /**
     * @stability stable
     */
    readonly serverZipPath: string;
    /**
     * @stability stable
     */
    readonly vpc: ec2.IVpc;
    /**
     * @stability stable
     */
    readonly ec2InstanceClass?: ec2.InstanceClass;
    /**
     * @stability stable
     */
    readonly ec2InstanceName: string;
    /**
     * @stability stable
     */
    readonly ec2InstanceSize?: ec2.InstanceSize;
    /**
     * @stability stable
     */
    readonly customUserDataScript?: ec2.UserData;
    /**
     * @stability stable
     */
    readonly additionalSecurityGroups?: ec2.ISecurityGroup[];
}
/**
 * @stability stable
 */
export declare class ServerInstance extends Construct {
    /**
     * @stability stable
     */
    readonly gameServerName: string;
    /**
     * @stability stable
     */
    readonly vpc: ec2.IVpc;
    /**
     * @stability stable
     */
    readonly ec2InstanceClass: ec2.InstanceClass;
    /**
     * @stability stable
     */
    readonly ec2InstanceSize: ec2.InstanceSize;
    /**
     * @stability stable
     */
    readonly ec2InstanceName: string;
    /**
     * @stability stable
     */
    readonly ec2Instance: ec2.Instance;
    /**
     * @stability stable
     */
    readonly fullInstanceType: ec2.InstanceType;
    /**
     * @stability stable
     */
    readonly customUserDataScript: ec2.UserData;
    /**
     * @stability stable
     */
    readonly ec2Ami: ec2.IMachineImage;
    /**
     * @stability stable
     */
    readonly instanceRole: iam.Role;
    /**
     * @stability stable
     */
    readonly defaultSecurityGroup: ec2.ISecurityGroup;
    /**
     * @stability stable
     */
    readonly ecrRepo: ecr.Repository;
    /**
     * @stability stable
     */
    readonly dockerFile: DockerImageAsset;
    /**
     * @stability stable
     */
    readonly serverZipPath: string;
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props: ServerInstanceProps);
}
