"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MinecraftServer = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
const management_api_construct_1 = require("./management-api-construct");
const server_instance_constuct_1 = require("./server-instance-constuct");
/**
 * @stability stable
 */
class MinecraftServer extends core_1.Construct {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        var _b;
        super(scope, id);
        props.vpc;
        this.serverInstance = new server_instance_constuct_1.ServerInstance(this, 'mc-server-instance', {
            vpc: props.vpc,
            ec2InstanceName: (_b = props.ec2InstanceName) !== null && _b !== void 0 ? _b : props.gameServerName,
            gameServerName: props.gameServerName,
            serverZipPath: props.serverZipPath,
            additionalSecurityGroups: props.additionalSecurityGroups,
            customUserDataScript: props.customUserDataScript,
            ec2InstanceSize: props.ec2InstanceSize,
            ec2InstanceClass: props.ec2InstanceClass,
        });
        if (props.serverManagementAPI) {
            this.managementAPI = new management_api_construct_1.ManagementAPI(this, 'mc-server-management-api', {
                apiName: `${props.gameServerName}-management-api`,
                serverInstance: this.serverInstance,
            });
        }
    }
}
exports.MinecraftServer = MinecraftServer;
_a = JSII_RTTI_SYMBOL_1;
MinecraftServer[_a] = { fqn: "cdk-minecraft-server.MinecraftServer", version: "0.0.2" };
//# sourceMappingURL=data:application/json;base64,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