import { IVpc, ISecurityGroup, InstanceSize, UserData, InstanceClass } from '@aws-cdk/aws-ec2';
import { Construct } from '@aws-cdk/core';
import { ManagementAPI } from './management-api-construct';
import { ServerInstance } from './server-instance-constuct';
/**
 * Properties for creating Minecraft server.
 *
 * @stability stable
 */
export interface MinecraftServerProps {
    /**
     * Name for Minecraft server.
     *
     * @stability stable
     */
    readonly gameServerName: string;
    /**
     * Path to zip folder for Minecraft server can be in s3 or local.
     *
     * @stability stable
     * @example
     *
     *  /some/directory/location/minecraft.zip
     *  s3://somebucket/minecraft.zip
     */
    readonly serverZipPath: string;
    /**
     * The VPC to use for creating the Minecraft server's.
     *
     * @stability stable
     * @attribute true
     */
    readonly vpc: IVpc;
    /**
     * Name to be given to EC2 instance where minecraft server will run.
     *
     * @default - the Minecraft server name will be used
     * @stability stable
     */
    readonly ec2InstanceName?: string;
    /**
     * The ec2 instance type for hosting the minecraft server.
     *
     * @default - c5a
     * @stability stable
     */
    readonly ec2InstanceClass?: InstanceClass;
    /**
     * The ec2 instance size for hosting the minecraft server.
     *
     * @default - large
     * @stability stable
     */
    readonly ec2InstanceSize?: InstanceSize;
    /**
     * Whether or not the server management API should be created as part of the deployment.
     *
     * The server api will allow you to do things such as start
     * and stop your ec2 instance
     *
     * @default true
     * @stability stable
     */
    readonly serverManagementAPI?: boolean;
    /**
     * Custom user data script.
     *
     * @stability stable
     */
    readonly customUserDataScript?: UserData;
    /**
     * Additional security groups.
     *
     * @stability stable
     */
    readonly additionalSecurityGroups?: ISecurityGroup[];
}
/**
 * @stability stable
 */
export declare class MinecraftServer extends Construct {
    /**
     * @stability stable
     */
    readonly serverInstance: ServerInstance;
    /**
     * @stability stable
     */
    readonly managementAPI?: ManagementAPI;
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props: MinecraftServerProps);
}
