"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ManagementAPI = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const apigatewayV2 = require("@aws-cdk/aws-apigatewayv2");
const integrations = require("@aws-cdk/aws-apigatewayv2-integrations");
const iam = require("@aws-cdk/aws-iam");
const lambdaNode = require("@aws-cdk/aws-lambda-nodejs");
const core_1 = require("@aws-cdk/core");
/**
 * @stability stable
 */
class ManagementAPI extends core_1.Construct {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        var _b, _c, _d;
        super(scope, id);
        this.managementAPIGateway = new apigatewayV2.HttpApi(this, 'management-api', {
            apiName: props.apiName,
        });
        const commonEnvironmentVariables = {
            INSTANCE_ID: props.serverInstance.ec2Instance.instanceId,
            REGION: core_1.Stack.of(this).region,
        };
        this.statusLambda = new lambdaNode.NodejsFunction(this, 'get-server-status', {
            entry: path.join(__dirname, './handlers/get_server_status.ts'),
            environment: { ...commonEnvironmentVariables },
        });
        this.shutdownServerLambda = new lambdaNode.NodejsFunction(this, 'stop-server-lambda', {
            entry: path.join(__dirname, './handlers/stop_server.ts'),
            environment: { ...commonEnvironmentVariables },
        });
        this.startServerLambda = new lambdaNode.NodejsFunction(this, 'start-server-lambda', {
            entry: path.join(__dirname, './handlers/start_server.ts'),
            environment: { ...commonEnvironmentVariables },
        });
        this.managementAPIGateway.addRoutes({
            path: '/start',
            methods: [apigatewayV2.HttpMethod.GET],
            integration: new integrations.LambdaProxyIntegration({
                handler: this.startServerLambda,
            }),
        });
        this.managementAPIGateway.addRoutes({
            path: '/stop',
            methods: [apigatewayV2.HttpMethod.GET],
            integration: new integrations.LambdaProxyIntegration({
                handler: this.shutdownServerLambda,
            }),
        });
        this.managementAPIGateway.addRoutes({
            path: '/status',
            methods: [apigatewayV2.HttpMethod.GET],
            integration: new integrations.LambdaProxyIntegration({
                handler: this.statusLambda,
            }),
        });
        (_b = this.statusLambda.role) === null || _b === void 0 ? void 0 : _b.addManagedPolicy(iam.ManagedPolicy.fromAwsManagedPolicyName('AmazonEC2FullAccess'));
        (_c = this.startServerLambda.role) === null || _c === void 0 ? void 0 : _c.addManagedPolicy(iam.ManagedPolicy.fromAwsManagedPolicyName('AmazonEC2FullAccess'));
        (_d = this.shutdownServerLambda.role) === null || _d === void 0 ? void 0 : _d.addManagedPolicy(iam.ManagedPolicy.fromAwsManagedPolicyName('AmazonEC2FullAccess'));
    }
}
exports.ManagementAPI = ManagementAPI;
_a = JSII_RTTI_SYMBOL_1;
ManagementAPI[_a] = { fqn: "cdk-minecraft-server.ManagementAPI", version: "0.0.2" };
//# sourceMappingURL=data:application/json;base64,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