"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.handler = void 0;
const ec2Client = require("@aws-sdk/client-ec2");
async function handler(event, _context) {
    var _a;
    const instanceId = process.env.INSTANCE_ID;
    const region = process.env.REGION;
    console.log('Event Recieved', { event });
    if (undefined == instanceId || undefined == region) {
        console.log('Missing ID or Region:', instanceId, region);
        return {
            statusCode: 500,
            body: `Please provide both instance id and region: instanceID: ${instanceId}, region: ${region}`,
        };
    }
    let password = '';
    if (event.queryStringParameters) {
        password = (_a = event.queryStringParameters.password) !== null && _a !== void 0 ? _a : 'NO PASSWORD PROVIDED';
    }
    if ('weaseldorf' !== password) {
        return {
            statusCode: 403,
            body: 'Unathorized!',
        };
    }
    try {
        const client = new ec2Client.EC2Client({ region: region });
        const startInstanceCommandInput = {
            InstanceIds: [
                instanceId,
            ],
        };
        const startInstanceCommand = new ec2Client.DescribeInstancesCommand(startInstanceCommandInput);
        const results = await client.send(startInstanceCommand);
        console.log('Results: ', { results });
        return {
            statusCode: 200,
            body: results,
        };
    }
    catch (e) {
        console.log('ERROR!', e);
        return {
            statusCode: 500,
            body: e,
        };
    }
}
exports.handler = handler;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic3RhcnRfc2VydmVyLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vc3JjL21pbmVjcmFmdC1zZXJ2ZXIvaGFuZGxlcnMvc3RhcnRfc2VydmVyLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUFBLGlEQUFpRDtBQUUxQyxLQUFLLFVBQVUsT0FBTyxDQUFDLEtBQWdDLEVBQUUsUUFBYTs7SUFDM0UsTUFBTSxVQUFVLEdBQUcsT0FBTyxDQUFDLEdBQUcsQ0FBQyxXQUFXLENBQUM7SUFDM0MsTUFBTSxNQUFNLEdBQUcsT0FBTyxDQUFDLEdBQUcsQ0FBQyxNQUFNLENBQUM7SUFDbEMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxnQkFBZ0IsRUFBRSxFQUFFLEtBQUssRUFBRSxDQUFDLENBQUM7SUFFekMsSUFBSSxTQUFTLElBQUksVUFBVSxJQUFJLFNBQVMsSUFBSSxNQUFNLEVBQUU7UUFDbEQsT0FBTyxDQUFDLEdBQUcsQ0FBQyx1QkFBdUIsRUFBRSxVQUFVLEVBQUUsTUFBTSxDQUFDLENBQUM7UUFDekQsT0FBTztZQUNMLFVBQVUsRUFBRSxHQUFHO1lBQ2YsSUFBSSxFQUFFLDJEQUEyRCxVQUFVLGFBQWEsTUFBTSxFQUFFO1NBQ2pHLENBQUM7S0FDSDtJQUVELElBQUksUUFBUSxHQUFHLEVBQUUsQ0FBQztJQUVsQixJQUFJLEtBQUssQ0FBQyxxQkFBcUIsRUFBRTtRQUMvQixRQUFRLFNBQUcsS0FBSyxDQUFDLHFCQUFxQixDQUFDLFFBQVEsbUNBQUksc0JBQXNCLENBQUM7S0FDM0U7SUFFRCxJQUFJLFlBQVksS0FBSyxRQUFRLEVBQUU7UUFDN0IsT0FBTztZQUNMLFVBQVUsRUFBRSxHQUFHO1lBQ2YsSUFBSSxFQUFFLGNBQWM7U0FDckIsQ0FBQztLQUNIO0lBRUQsSUFBSTtRQUNGLE1BQU0sTUFBTSxHQUFHLElBQUksU0FBUyxDQUFDLFNBQVMsQ0FBQyxFQUFFLE1BQU0sRUFBRSxNQUFNLEVBQUUsQ0FBQyxDQUFDO1FBQzNELE1BQU0seUJBQXlCLEdBQXlDO1lBQ3RFLFdBQVcsRUFBRTtnQkFDWCxVQUFVO2FBQ1g7U0FDRixDQUFDO1FBQ0YsTUFBTSxvQkFBb0IsR0FBRyxJQUFJLFNBQVMsQ0FBQyx3QkFBd0IsQ0FBQyx5QkFBeUIsQ0FBQyxDQUFDO1FBQy9GLE1BQU0sT0FBTyxHQUFHLE1BQU0sTUFBTSxDQUFDLElBQUksQ0FBQyxvQkFBb0IsQ0FBQyxDQUFDO1FBRXhELE9BQU8sQ0FBQyxHQUFHLENBQUMsV0FBVyxFQUFFLEVBQUUsT0FBTyxFQUFFLENBQUMsQ0FBQztRQUV0QyxPQUFPO1lBQ0wsVUFBVSxFQUFFLEdBQUc7WUFDZixJQUFJLEVBQUUsT0FBTztTQUNkLENBQUM7S0FFSDtJQUFDLE9BQU8sQ0FBQyxFQUFFO1FBQ1YsT0FBTyxDQUFDLEdBQUcsQ0FBQyxRQUFRLEVBQUUsQ0FBQyxDQUFDLENBQUM7UUFDekIsT0FBTztZQUNMLFVBQVUsRUFBRSxHQUFHO1lBQ2YsSUFBSSxFQUFFLENBQUM7U0FDUixDQUFDO0tBQ0g7QUFFSCxDQUFDO0FBbkRELDBCQW1EQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIGVjMkNsaWVudCBmcm9tICdAYXdzLXNkay9jbGllbnQtZWMyJztcblxuZXhwb3J0IGFzeW5jIGZ1bmN0aW9uIGhhbmRsZXIoZXZlbnQ6IEFXU0xhbWJkYS5BUElHYXRld2F5RXZlbnQsIF9jb250ZXh0OiBhbnkpIHtcbiAgY29uc3QgaW5zdGFuY2VJZCA9IHByb2Nlc3MuZW52LklOU1RBTkNFX0lEO1xuICBjb25zdCByZWdpb24gPSBwcm9jZXNzLmVudi5SRUdJT047XG4gIGNvbnNvbGUubG9nKCdFdmVudCBSZWNpZXZlZCcsIHsgZXZlbnQgfSk7XG5cbiAgaWYgKHVuZGVmaW5lZCA9PSBpbnN0YW5jZUlkIHx8IHVuZGVmaW5lZCA9PSByZWdpb24pIHtcbiAgICBjb25zb2xlLmxvZygnTWlzc2luZyBJRCBvciBSZWdpb246JywgaW5zdGFuY2VJZCwgcmVnaW9uKTtcbiAgICByZXR1cm4ge1xuICAgICAgc3RhdHVzQ29kZTogNTAwLFxuICAgICAgYm9keTogYFBsZWFzZSBwcm92aWRlIGJvdGggaW5zdGFuY2UgaWQgYW5kIHJlZ2lvbjogaW5zdGFuY2VJRDogJHtpbnN0YW5jZUlkfSwgcmVnaW9uOiAke3JlZ2lvbn1gLFxuICAgIH07XG4gIH1cblxuICBsZXQgcGFzc3dvcmQgPSAnJztcblxuICBpZiAoZXZlbnQucXVlcnlTdHJpbmdQYXJhbWV0ZXJzKSB7XG4gICAgcGFzc3dvcmQgPSBldmVudC5xdWVyeVN0cmluZ1BhcmFtZXRlcnMucGFzc3dvcmQgPz8gJ05PIFBBU1NXT1JEIFBST1ZJREVEJztcbiAgfVxuXG4gIGlmICgnd2Vhc2VsZG9yZicgIT09IHBhc3N3b3JkKSB7XG4gICAgcmV0dXJuIHtcbiAgICAgIHN0YXR1c0NvZGU6IDQwMyxcbiAgICAgIGJvZHk6ICdVbmF0aG9yaXplZCEnLFxuICAgIH07XG4gIH1cblxuICB0cnkge1xuICAgIGNvbnN0IGNsaWVudCA9IG5ldyBlYzJDbGllbnQuRUMyQ2xpZW50KHsgcmVnaW9uOiByZWdpb24gfSk7XG4gICAgY29uc3Qgc3RhcnRJbnN0YW5jZUNvbW1hbmRJbnB1dDogZWMyQ2xpZW50LlN0YXJ0SW5zdGFuY2VzQ29tbWFuZElucHV0ID0ge1xuICAgICAgSW5zdGFuY2VJZHM6IFtcbiAgICAgICAgaW5zdGFuY2VJZCxcbiAgICAgIF0sXG4gICAgfTtcbiAgICBjb25zdCBzdGFydEluc3RhbmNlQ29tbWFuZCA9IG5ldyBlYzJDbGllbnQuRGVzY3JpYmVJbnN0YW5jZXNDb21tYW5kKHN0YXJ0SW5zdGFuY2VDb21tYW5kSW5wdXQpO1xuICAgIGNvbnN0IHJlc3VsdHMgPSBhd2FpdCBjbGllbnQuc2VuZChzdGFydEluc3RhbmNlQ29tbWFuZCk7XG5cbiAgICBjb25zb2xlLmxvZygnUmVzdWx0czogJywgeyByZXN1bHRzIH0pO1xuXG4gICAgcmV0dXJuIHtcbiAgICAgIHN0YXR1c0NvZGU6IDIwMCxcbiAgICAgIGJvZHk6IHJlc3VsdHMsXG4gICAgfTtcblxuICB9IGNhdGNoIChlKSB7XG4gICAgY29uc29sZS5sb2coJ0VSUk9SIScsIGUpO1xuICAgIHJldHVybiB7XG4gICAgICBzdGF0dXNDb2RlOiA1MDAsXG4gICAgICBib2R5OiBlLFxuICAgIH07XG4gIH1cblxufSJdfQ==