# pysptk

[![PyPI](https://img.shields.io/pypi/v/pysptk.svg)](https://pypi.python.org/pypi/pysptk)
[![Build Status](https://travis-ci.org/r9y9/pysptk.svg?branch=master)](https://travis-ci.org/r9y9/pysptk)
[![Build status](https://ci.appveyor.com/api/projects/status/h77aqo1ff0a2e2r9/branch/master?svg=true)](https://ci.appveyor.com/project/r9y9/pysptk/branch/master)
[![Coverage Status](https://coveralls.io/repos/r9y9/pysptk/badge.svg?branch=master&service=github)](https://coveralls.io/github/r9y9/pysptk?branch=master)
[![Documentation Status](https://readthedocs.org/projects/pysptk/badge/?version=latest)](https://readthedocs.org/projects/pysptk/?badge=latest)
[![License](http://img.shields.io/badge/license-MIT-brightgreen.svg?style=flat)](LICENSE.md)
[![][docs-stable-img]][docs-stable-url]
[![][docs-latest-img]][docs-latest-url]

A python wrapper for [Speech Signal Processing Toolkit (SPTK)](http://sp-tk.sourceforge.net/).

**NOTE**: pysptk is based on a modified version of SPTK ([r9y9/SPTK](https://github.com/r9y9/SPTK)).

## Documentation

- [**STABLE**][docs-stable-url] &mdash; **most recently tagged version of the documentation.**
- [**LATEST**][docs-latest-url] &mdash; *in-development version of the documentation.*

## Demonstration notebook

- [Introduction notebook](http://nbviewer.ipython.org/github/r9y9/pysptk/blob/master/examples/pysptk%20introduction.ipynb): a brief introduction to pysptk
- [Speech analysis and re-synthesis](http://nbviewer.ipython.org/github/r9y9/pysptk/blob/master/examples/Speech%20analysis%20and%20re-synthesis.ipynb): a demonstration notebook for speech analysis and re-synthesis. Synthesized audio examples (English) are available on the notebook.

## Installation

The latest release is availabe on pypi and you can install it by:

```bash
pip install pysptk
```

If yout want the latest master, run

```bash
pip install git+https://github.com/r9y9/pysptk
```

or clone the repository and then build it yourself.

[docs-latest-img]: https://img.shields.io/badge/docs-latest-blue.svg
[docs-latest-url]: https://pysptk.readthedocs.io/en/latest/

[docs-stable-img]: https://img.shields.io/badge/docs-stable-blue.svg
[docs-stable-url]: https://pysptk.readthedocs.io/en/stable/
