"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.WhiteListReceiptFilter = exports.ReceiptFilter = exports.ReceiptFilterPolicy = void 0;
const core_1 = require("@aws-cdk/core");
const ses_generated_1 = require("./ses.generated");
/**
 * The policy for the receipt filter.
 */
var ReceiptFilterPolicy;
(function (ReceiptFilterPolicy) {
    /**
     * Allow the ip address or range.
     */
    ReceiptFilterPolicy["ALLOW"] = "Allow";
    /**
     * Block the ip address or range.
     */
    ReceiptFilterPolicy["BLOCK"] = "Block";
})(ReceiptFilterPolicy = exports.ReceiptFilterPolicy || (exports.ReceiptFilterPolicy = {}));
/**
 * A receipt filter. When instantiated without props, it creates a
 * block all receipt filter.
 */
class ReceiptFilter extends core_1.Resource {
    constructor(scope, id, props = {}) {
        super(scope, id, {
            physicalName: props.receiptFilterName,
        });
        new ses_generated_1.CfnReceiptFilter(this, 'Resource', {
            filter: {
                ipFilter: {
                    cidr: props.ip || '0.0.0.0/0',
                    policy: props.policy || ReceiptFilterPolicy.BLOCK,
                },
                name: this.physicalName,
            },
        });
    }
}
exports.ReceiptFilter = ReceiptFilter;
/**
 * A white list receipt filter.
 */
class WhiteListReceiptFilter extends core_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        new ReceiptFilter(this, 'BlockAll');
        props.ips.forEach(ip => {
            new ReceiptFilter(this, `Allow${ip.replace(/[^\d]/g, '')}`, {
                ip,
                policy: ReceiptFilterPolicy.ALLOW,
            });
        });
    }
}
exports.WhiteListReceiptFilter = WhiteListReceiptFilter;
//# sourceMappingURL=data:application/json;base64,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