## dploy-kickstart

[![maintained](https://img.shields.io/badge/maintained%20by-dploy.ai-brightgreen.svg)](https://dploy.ai/) 
[![PyPI version](https://badge.fury.io/py/dploy-kickstart.svg)](https://badge.fury.io/py/dploy-kickstart)
![PyPI - Python Version](https://img.shields.io/pypi/pyversions/dploy-kickstart)
![workflow](https://github.com/dploy-ai/dploy-kickstart/workflows/tests/badge.svg)
[![codecov](https://codecov.io/gh/dploy-ai/dploy-kickstart/branch/master/graph/badge.svg?token=KypiVRoPJz)](https://codecov.io/gh/dploy-ai/dploy-kickstart)

Expose your Python functions via an HTTP API. `dploy-kickstart` is designed with a focus of making deployment of machine learning models as easy as possible with as clean of a contract as possible. This means that you will find configurations options that are less relevant outside of this domain.

### Installation

`pip install dploy_kickstart`

When installed it provides a `kickstart` executable. Have a look at the help functionality: `kickstart --help`.


### Usage

`dploy_kickstart` is a helper utility that can expose your Python functions as HTTP endpoints. Based on comment annotations it wraps your chosen functions to be served as API endpoints. It is meant to be used via the `kickstart` CLI, hence, it would generally not be used programmatically.

Let's say you have a `script.py` with `@dploy` comment annotations:

```python
# @dploy endpoint echo
def echo_func(payload):
    return payload
```

Serve this function with:

```sh
kickstart serve -e script.py
```

Let's try to call the endpoint via `curl`.

```
$ curl -d '{"foo":"bar"}' -H "Content-Type: application/json" -X POST http://localhost:8080/echo/

{"foo":"bar"}
```

### Annotations

Following annotation options are currently available.

- `# @dploy endpoint {endpoint_path}`  
  Will expose the annotated function on path {endpoint_path} with trailing slash (and redirect without trailing slash).
- `# @dploy response_mime_type {mimetype}`  
  Specify response mime type, will wrap function response accordingly.
  default: `application/json`  
  available: `application/json`
- `# @dploy request_content_type {content_type}`  
  Specify allowed request content type.  
  default: `application/json`
  available: `application/json`
- `# @dploy request_method {method}`  
  Specify allowed request method.  
  default: `post`  
  available: any method supported by Flask
- `# @dploy json_to_kwargs`  
  Will map json payload's keys to function kwargs if supplied.

### Endpoint utilities

Following paths are generated automatically:

- `GET /healthz`: that always returns a 200
- `GET /openapi.yaml`: autogenerated OpenAPI Spec (WIP)

### Current dependency tree

Aim is to keep this as small as possible to not clutter the user space.

```
$ poetry show --no-dev --tree

apispec 3.3.0 A pluggable API specification generator. Currently supports the OpenAPI Specification (f.k.a. the Swagger specification).
click 7.1.2 Composable command line interface toolkit
flask 1.1.2 A simple framework for building complex web applications.
├── click >=5.1
├── itsdangerous >=0.24
├── jinja2 >=2.10.1
│   └── markupsafe >=0.23 
└── werkzeug >=0.15
paste 3.4.0 Tools for using a Web Server Gateway Interface stack
└── six >=1.4.0
waitress 1.4.3 Waitress WSGI server
```

### Package naming

Isn't using underscores in package names discouraged? The reasoning behind the `dploy_kickstart` naming is that this utility is not meant to be used programmatically. Its meant to be used as a sidecar to user code that should be unaware of its existence, therefore, a longer name has a lower chance of clashing with user code. Yes, this is quite subjective.

### Contributing

Questions, ideas, suggestions? Feel free to create issue or PR.