# -*- coding:utf-8 -*-

import os
from base import DynamicCore
from validator import ValidatorKeywords
from requester import RequesterKeywords
from util import UtilKeywords
from db import DBKeywords
from loglistener import LogListener
from robot.libraries.BuiltIn import BuiltIn
from base import hook_zh

__version__ = '0.0.3'


class SCLibrary(DynamicCore):

    ROBOT_LIBRARY_SCOPE = 'GLOBAL'
    ROBOT_LIBRARY_VERSION = __version__
 
    def __init__(self):
        libraries = [ValidatorKeywords(), RequesterKeywords(), DBKeywords(), UtilKeywords()]
        DynamicCore.__init__(self, libraries)
        built_in = BuiltIn()
        built_in.set_global_variable("${EMPTY}", {})
        if built_in.get_variable_value("${RF_DEBUG}") == True:
            self.ROBOT_LIBRARY_LISTENER = LogListener()
        # 复写robot的unic.py，支持Log打印中文
        hook_zh()