# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class CdsOrgInfo(Model):
    """The information for CDS Organization in BAP.

    :param friendly_name: Gets the Cds Organization Friendly Name
    :type friendly_name: str
    :param url: Gets the Cds Organization Url
    :type url: str
    :param state: Gets the Cds Organization State
    :type state: str
    :param location: Gets region location of Cds Organization
    :type location: str
    :param environment_sku: Gets SKU of Cds Organization
    :type environment_sku: str
    :param expiration_time: Gets the expiration time of CDS Organization if
     the SKU is Trial
    :type expiration_time: datetime
    :param max_allowed_expiration_time: Gets the max allowed expiration time
     of CDS Organization if the SKU is Trial
    :type max_allowed_expiration_time: datetime
    """

    _attribute_map = {
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'url': {'key': 'url', 'type': 'str'},
        'state': {'key': 'state', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'environment_sku': {'key': 'environmentSku', 'type': 'str'},
        'expiration_time': {'key': 'expirationTime', 'type': 'iso-8601'},
        'max_allowed_expiration_time': {'key': 'maxAllowedExpirationTime', 'type': 'iso-8601'},
    }

    def __init__(self, **kwargs):
        super(CdsOrgInfo, self).__init__(**kwargs)
        self.friendly_name = kwargs.get('friendly_name', None)
        self.url = kwargs.get('url', None)
        self.state = kwargs.get('state', None)
        self.location = kwargs.get('location', None)
        self.environment_sku = kwargs.get('environment_sku', None)
        self.expiration_time = kwargs.get('expiration_time', None)
        self.max_allowed_expiration_time = kwargs.get('max_allowed_expiration_time', None)
