import subprocess

from coalib.results.Diff import Diff
from coalib.results.result_actions.ApplyPatchAction import ApplyPatchAction
from coalib.results.Result import Result


EDITOR_ARGS = {
    "subl": "--wait",
    "gedit": "-s",
    "atom": "--wait"
}


GUI_EDITORS = ["kate", "gedit", "subl", "atom"]


class OpenEditorAction(ApplyPatchAction):
    @staticmethod
    def is_applicable(result):
        return isinstance(result, Result) and len(result.affected_code) > 0

    def apply(self, result, original_file_dict, file_diff_dict, editor: str):
        '''
        Open the affected file(s) in an editor.

        :param editor: The editor to open the file with.
        '''
        # Use set to remove duplicates
        filenames = set(src.file for src in result.affected_code)

        editor_args = [editor] + list(filenames)
        arg = EDITOR_ARGS.get(editor.strip(), None)
        if arg:
            editor_args.append(arg)

        # Dear user, you wanted an editor, so you get it. But do you really
        # think you can do better than we?
        if editor in GUI_EDITORS:
            subprocess.call(editor_args, stdout=subprocess.PIPE)
        else:
            subprocess.call(editor_args)

        for filename in filenames:
            with open(filename) as filehandle:
                new_file = filehandle.readlines()

            original_file = original_file_dict[filename]
            diff = file_diff_dict.get(filename, Diff())
            current_file = diff.apply(original_file)

            intermediate_diff = Diff.from_string_arrays(current_file, new_file)
            file_diff_dict[filename] = diff + intermediate_diff

        return file_diff_dict
