// Copyright (c) 2021 Marcus Valtonen Örnhag
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in all
// copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.

#include <Eigen/Dense>
#include <cmath>

namespace DronePoseLib {
namespace ValtonenOrnhagArxiv2021 {
Eigen::VectorXd coeffs_frEfr(const Eigen::VectorXd &data) {
    // Compute coefficients
    const double* x = data.data();
    Eigen::VectorXd coeffs(60);

    double t2240 = x[19];
    double t2251 = x[8];
    double t2144 = t2251*t2240;
    double t2252 = x[7];
    double t2235 = x[24];
    double t3181 = t2235*t2252;
    double t1847 = t2252*(t2144-t3181);
    double t2253 = x[6];
    double t2228 = std::pow(t2253, 2);
    double t2140 = t2235*t2228;
    double t1452 = t1847-t2140;
    double t2243 = x[16];
    double t2150 = t2253*t2243;
    double t2109 = t2251*t2150;
    double t1183 = t2109+t1452;
    double t2239 = x[20];
    double t2146 = t2252*t2239;
    double t2242 = x[17];
    double t2149 = t2253*t2242;
    double t1906 = t2146+t2149;
    double t2244 = x[15];
    double t2245 = x[14];
    double t3104 = t2245*t2251;
    double t3977 = -t1183*t2244+t1906*t3104;
    double t2259 = x[0];
    double t2157 = t2259*t2242;
    double t2254 = x[5];
    double t2229 = std::pow(t2254, 2);
    double t2255 = x[4];
    double t2230 = std::pow(t2255, 2);
    double t3727 = t2229+t2230;
    double t3763 = t3727*t2157;
    double t2258 = x[1];
    double t3131 = t2242*t2255;
    double t3147 = t2239*t2254;
    double t1922 = t3131+t3147;
    double t2234 = std::pow(t2259, 2);
    double t3372 = t1922*t2234;
    double t2563 = t3727*t2239;
    double t3364 = t1922*t2258;
    double t3820 = -t2563+t3364;
    double t3800 = t2258*t3820+t3372;
    double t772 = -t3763+t3800;
    double t2147 = t2252*t2240;
    double t1908 = t2147+t2150;
    double t1554 = t3727*t1908;
    double t2256 = x[3];
    double t2231 = std::pow(t2256, 2);
    double t2257 = x[2];
    double t2232 = std::pow(t2257, 2);
    double t3398 = t1908*t2232;
    double t3009 = t1908*t2231+t3398;
    double t2227 = std::pow(t2252, 2);
    double t2127 = t2227+t2228;
    double t1869 = t3727+t2127;
    double t2156 = t2256*t2240;
    double t3123 = t2243*t2257;
    double t3732 = t2156+t3123;
    double t3025 = t3732*t1869;
    double t2402 = -t1554+t3025-t3009;
    double t2219 = std::pow(t2244, 2);
    double t2220 = std::pow(t2245, 2);
    double t3730 = t2219+t2220;
    double t1882 = t2127*t3123;
    double t3290 = t2127*t2240;
    double t3390 = t1908*t2256;
    double t767 = t3398-t1882+t2256*(-t3290+t3390);
    double t173 = t2402*t3730-t3727*t767;
    double t2247 = x[12];
    double t3622 = t173*t2247;
    double t2246 = x[13];
    double t2221 = std::pow(t2246, 2);
    double t2222 = std::pow(t2247, 2);
    double t3729 = t2221+t2222;
    double t2152 = t2254*t2240;
    double t2154 = t2255*t2243;
    double t3733 = t2152+t2154;
    double t1549 = t2127*t3733;
    double t3361 = t3733*t2232;
    double t2998 = t2231*t3733+t3361;
    double t550 = t1549+t2998-t3025;
    double t1883 = t3727*t3123;
    double t3354 = t3733*t2256;
    double t3835 = t3727*t2240;
    double t3862 = t3361+(-t3835+t3354)*t2256;
    double t773 = -t1883+t3862;
    double t696 = t773*t2127;
    double t3976 = -t3622-(t3729*t550+t696)*t2245;
    double t2249 = x[10];
    double t3121 = t2243*t2259;
    double t3140 = t2240*t2258;
    double t1947 = t3121+t3140;
    double t1412 = t1947-t3733;
    double t3900 = t1412*t3729;
    double t2020 = t3727+t2231;
    double t1871 = t2232+t2020;
    double t2320 = t1947*t1871;
    double t2233 = std::pow(t2258, 2);
    double t3359 = t3733*t2234;
    double t2997 = t2233*t3733+t3359;
    double t3726 = t2231+t2232;
    double t552 = t3726*t3733-t2320+t2997;
    double t3956 = t552-t3900;
    double t3975 = t2249*t3956;
    double t2224 = std::pow(t2249, 2);
    double t2248 = x[11];
    double t2126 = std::pow(t2248, 2)+t2224;
    double t2241 = x[18];
    double t2153 = t2255*t2241;
    double t1877 = t2127*t2153;
    double t2238 = x[21];
    double t3292 = t2127*t2238;
    double t2145 = t2252*t2238;
    double t2148 = t2253*t2241;
    double t1905 = t2145+t2148;
    double t3421 = t1905*t2254;
    double t3424 = t1905*t2230;
    double t760 = t3424+(-t3292+t3421)*t2254-t1877;
    double t3547 = t760*t3726;
    double t2151 = t2254*t2238;
    double t2965 = t2153-t2148;
    double t1710 = t2151+t2965;
    double t1398 = -t2145+t1710;
    double t3904 = -t1398*t3726+t760;
    double t3973 = t2126*t3904+t3547;
    double t1778 = t1905*t2258;
    double t1779 = t1905*t2234;
    double t3137 = t2241*t2259;
    double t762 = t1779-t2127*t3137+(t1778-t3292)*t2258;
    double t3545 = t762*t3726;
    double t3014 = t1905*t2233+t1779;
    double t2019 = t2127+t2231;
    double t1870 = t2232+t2019;
    double t3155 = t2238*t2258;
    double t2383 = t3137+t3155;
    double t3031 = t2383*t1870;
    double t530 = t1905*t3726+t3014-t3031;
    double t3923 = t2126*t530+t3545;
    double t2142 = t2241*t2257;
    double t2155 = t2256*t2238;
    double t1938 = t2142+t2155;
    double t3351 = t1938*t2234;
    double t2995 = t1938*t2233+t3351;
    double t2398 = -t1938*t2127-t2995+t3031;
    double t1832 = t1938*t2258;
    double t775 = t3351-t3726*t3137+(-t2238*t3726+t1832)*t2258;
    double t3938 = -t2127*t775+t2398*t3730;
    double t3972 = t2245*t3923+t2249*t3938;
    double t1921 = t2151+t2153;
    double t1809 = t1921*t2258;
    double t3280 = t3727*t2238;
    double t3384 = t1921*t2234;
    double t770 = t3384-t3727*t3137+(t1809-t3280)*t2258;
    double t3544 = t770*t3726;
    double t3004 = t1921*t2233+t3384;
    double t3030 = t2383*t1871;
    double t543 = t1921*t3726+t3004-t3030;
    double t3924 = t2126*t543+t3544;
    double t2397 = -t1938*t3727-t2995+t3030;
    double t699 = t775*t3727;
    double t3939 = t2397*t3729-t699;
    double t3971 = t2247*t3924+t2249*t3939;
    double t1399 = t1922-t1906;
    double t1878 = t2127*t3131;
    double t3291 = t2127*t2239;
    double t3406 = t1906*t2254;
    double t3414 = t1906*t2230;
    double t763 = t3414-t1878+(-t3291+t3406)*t2254;
    double t427 = -t1399*t3726+t763;
    double t2942 = t3726*t763+t3730*t427;
    double t3298 = t3730*t3726;
    double t3970 = t2942*t3729+t3298*t763;
    double t3365 = t1922*t2256;
    double t3374 = t1922*t2232;
    double t3969 = t3374+t2256*(-t2563+t3365);
    double t1553 = t3727*t1906;
    double t3412 = t1906*t2232;
    double t3013 = t1906*t2231+t3412;
    double t3129 = t2242*t2257;
    double t3145 = t2239*t2256;
    double t1939 = t3129+t3145;
    double t3029 = t1939*t1869;
    double t2404 = -t1553+t3029-t3013;
    double t1879 = t2127*t3129;
    double t3405 = t1906*t2256;
    double t764 = t3412-t1879+(-t3291+t3405)*t2256;
    double t169 = t2404*t3730-t3727*t764;
    double t1880 = t3727*t3129;
    double t771 = -t1880+t3969;
    double t374 = t2244*t773+t2245*t771;
    double t1548 = t2127*t1922;
    double t3002 = t1922*t2231+t3374;
    double t3892 = -t1548+t3029-t3002;
    double t3940 = -t2244*t550+t2245*t3892;
    double t3968 = t169*t2247+t173*t2246+t2127*t374-t3729*t3940;
    double t2143 = t2251*t2235;
    double t2090 = t2242*t2143;
    double t3136 = t2242*t2240;
    double t3152 = t2239*t2243;
    double t1895 = -t3136+t3152;
    double t3071 = t2252*t1895;
    double t1389 = t3071+t2090;
    double t1757 = t2251*t1895;
    double t3133 = t2242*t2252;
    double t2091 = t2235*t3133;
    double t3188 = t2235*t2242;
    double t2092 = t2228*t3188;
    double t1046 = (t1757+t2091)*t2252+t2092;
    double t946 = t2251*t1046;
    double t3967 = -t1389*t3727-t946;
    double t3966 = -t1389*t3726-t946;
    double t3090 = t2247*t2248;
    double t3094 = t2246*t2249;
    double t3964 = -t3094-t3090;
    double t2226 = std::pow(t2251, 2);
    double t2017 = t2226+t2127;
    double t2088 = t2239*t2152;
    double t1620 = t2017*t2088;
    double t2101 = t2242*t2154;
    double t1623 = t2017*t2101;
    double t2696 = t2240*t3131;
    double t3125 = t2243*t2254;
    double t2709 = t2239*t3125;
    double t3069 = t2253*t1895;
    double t1693 = t2251*t3069;
    double t3189 = t2235*t2239;
    double t1093 = t2127*t3189-t1693;
    double t1021 = t2251*t1093;
    double t2087 = t2239*t2143;
    double t1390 = t3069-t2087;
    double t3945 = t1390*t3727-t1021;
    double t3963 = -(t2017*t2709+t1623-t3967)*t2259-(t2017*t2696+t1620-t3945)*t2258;
    double t2089 = t2239*t2156;
    double t1621 = t2017*t2089;
    double t2099 = t2242*t3123;
    double t1624 = t2017*t2099;
    double t2695 = t2240*t3129;
    double t3124 = t2243*t2256;
    double t2708 = t2239*t3124;
    double t3946 = t1390*t3726-t1021;
    double t3962 = -(t2017*t2708+t1624-t3966)*t2259-(t2017*t2695+t1621-t3946)*t2258;
    double t2577 = t3730*t1947;
    double t1881 = t2127*t2154;
    double t3392 = t1908*t2254;
    double t3400 = t1908*t2230;
    double t766 = t3400-t1881+t2254*(-t3290+t3392);
    double t3961 = t2577*t766;
    double t3960 = t2577*t767;
    double t1403 = t3732-t1908;
    double t3754 = t3730*t1403;
    double t320 = t2402+t3754;
    double t3959 = t320*t2247;
    double t2165 = t2256-t2254;
    double t2169 = t2257-t2255;
    double t3705 = t2165*t2239+t2169*t2242;
    double t2567 = t3729*t3705;
    double t3725 = t2233+t2234;
    double t3691 = t3725*t3705;
    double t440 = t771-t3691;
    double t3785 = -t2567+t440;
    double t3681 = t1399*t3730;
    double t3958 = t427-t3681;
    double t3683 = t3725*t1399;
    double t428 = t763-t3683;
    double t3957 = t428-t3681;
    double t1402 = t1939-t1906;
    double t3898 = t3730*t1402;
    double t3687 = t3725*t1402;
    double t435 = t764-t3687;
    double t3933 = t435-t3898;
    double t1547 = t2127*t1921;
    double t3032 = t2383*t1869;
    double t542 = t1547-t3032+t3004;
    double t2596 = t2127*t770+t3730*t542;
    double t3955 = t2247*t2596;
    double t2018 = t2226+t3727;
    double t1622 = t2018*t2089;
    double t3065 = t2255*t1895;
    double t1694 = t2251*t3065;
    double t1094 = t2235*t2563-t1694;
    double t3947 = -t2251*t1094+(t3065-t2087)*t3726;
    double t3952 = (t2018*t2695+t1622-t3947)*t2258;
    double t1413 = t2383-t1938;
    double t2277 = t1413*t3729+t2397;
    double t2278 = t1413*t3730+t2398;
    double t1932 = -t2153+t2155;
    double t2601 = t2151-t1932;
    double t1404 = t2142-t2601;
    double t3386 = t1921*t2232;
    double t3005 = t1921*t2231+t3386;
    double t3033 = t1938*t1869;
    double t2400 = -t1547+t3033-t3005;
    double t321 = t1404*t3730+t2400;
    double t319 = t2404+t3898;
    double t1406 = t3732-t3733;
    double t3693 = t3725*t1406;
    double t2407 = t773-t3693;
    double t3692 = t3729*t1406;
    double t3949 = t2407-t3692;
    double t3688 = t3725*t1403;
    double t2408 = t767-t3688;
    double t3948 = t2408-t3754;
    double t1733 = t1869*t2256;
    double t2180 = t2252*t2232;
    double t1013 = t2020*t2252-t1733+t2180;
    double t2182 = t2253*t2232;
    double t3451 = t1869*t2257;
    double t1059 = -t2020*t2253-t2182+t3451;
    double t2163 = t2256-t2252;
    double t2167 = t2257-t2253;
    double t1603 = t2163*t2240+t2167*t2243;
    double t3828 = t1603*t3730;
    double t3944 = t1013*t2240-t1059*t2243-t3828;
    double t1236 = t1906*t3354;
    double t1237 = t1906*t3361;
    double t1422 = t2127*t3065;
    double t1767 = t2240*t1906;
    double t2348 = -t1767*t3727+t1422;
    double t3393 = t1908*t2244;
    double t1516 = t2127*t1895;
    double t1769 = t2243*t1906;
    double t743 = t2230*t1769+(t1906*t3125+t1516)*t2254;
    double t165 = -t773*t3393+(t2256*(t1236+t2348)-t2257*t743+t1237)*t2245;
    double t3185 = t2235*t2245;
    double t2908 = t550*t3185;
    double t3067 = t2254*t1895;
    double t1132 = t3067+t1769;
    double t1134 = t3065-t1767;
    double t1374 = t1906*t3733;
    double t356 = -t1406*t3393+t2245*(t1132*t2257-t1134*t2256-t1374);
    double t3186 = t2235*t2244;
    double t3642 = -t2402*t3186-t3185*t427;
    double t1109 = -t3069+t2088+t2696;
    double t2424 = t2101+t2709;
    double t1118 = t3071+t2424;
    double t1375 = t1922*t1908;
    double t3679 = t1109*t2256+t1118*t2257-t1375;
    double t1242 = t1908*t3365;
    double t1243 = t1908*t3374;
    double t2181 = t2253*t2230;
    double t1697 = t1895*t2181;
    double t2185 = t2254*t2253;
    double t1699 = t1895*t2185;
    double t3153 = t2239*t2240;
    double t1875 = t2127*t3153;
    double t2305 = -t1878*t2240+(t1699-t1875)*t2254+t1697;
    double t2184 = t2254*t2252;
    double t1695 = t1895*t2184;
    double t1876 = t2127*t3152;
    double t2456 = t2127*t2101;
    double t2179 = t2252*t2230;
    double t2634 = t1895*t2179;
    double t684 = t2634+t2456+(t1695+t1876)*t2254;
    double t3680 = t684*t2257-t1243-t2256*(t1242+t2305);
    double t3903 = -t767+t3754;
    double t3943 = (t3679*t3730+t3642+t3680)*t2247-(t3733*t3903+t2908)*t2246+t165-t3729*t356;
    double t694 = t3725*t771;
    double t2939 = t3729*t440+t694;
    double t2941 = t3725*t763+t3730*t428;
    double t2940 = t3725*t764+t3730*t435;
    double t2161 = t2255-t2253;
    double t2964 = t2229*t2253+t2181;
    double t3285 = t2127*t2255;
    double t2605 = t3285-t2964;
    double t991 = t2161*t3726+t2605;
    double t1443 = (t2184-t2127)*t2254+t2179;
    double t2159 = t2254-t2252;
    double t996 = t2159*t3726-t1443;
    double t3942 = t2239*t996+t2242*t991;
    double t3941 = -t2240*t996-t2243*t991;
    double t3602 = t3726*t772;
    double t3001 = t1922*t2233+t3372;
    double t3144 = t2239*t2258;
    double t3731 = t2157+t3144;
    double t3026 = t3731*t1871;
    double t548 = t1922*t3726+t3001-t3026;
    double t3937 = t3729*t548+t3602;
    double t3410 = t1906*t2234;
    double t3012 = t1906*t2233+t3410;
    double t3027 = t3731*t1870;
    double t533 = t1906*t3726+t3012-t3027;
    double t3404 = t1906*t2258;
    double t765 = t3410-t2127*t2157+t2258*(-t3291+t3404);
    double t3936 = t3726*t765+t3730*t533;
    double t3028 = t3731*t1869;
    double t532 = t1553-t3028+t3012;
    double t3935 = t3727*t765+t3730*t532;
    double t1806 = t1921*t2256;
    double t2793 = t3727*t2142;
    double t769 = t3386+(t1806-t3280)*t2256-t2793;
    double t175 = -t2127*t769+t2400*t3730;
    double t2594 = -t2407*t3729-t3725*t773;
    double t2597 = -t2408*t3730-t3725*t767;
    double t1400 = t3733-t1908;
    double t3685 = t3725*t1400;
    double t2409 = t766-t3685;
    double t2598 = -t2409*t3730-t3725*t766;
    double t3684 = t3726*t1400;
    double t2410 = t766-t3684;
    double t129 = -t2410*t3730-t3726*t766;
    double t3893 = t1921*t2226-t1938*t2018+t3005;
    double t205 = t2226*t769+t3725*t3893;
    double t3932 = (t1132*t2259-t1134*t2258-t1374)*t2245;
    double t2236 = x[23];
    double t3174 = t2236*t2238;
    double t1887 = -t3174+t3189;
    double t3139 = t2241*t2236;
    double t1890 = -t3139+t3188;
    double t1120 = t1887*t2252+t1890*t2253;
    double t1073 = t1120*t2232;
    double t3284 = t2127*t2257;
    double t3450 = t1887*t2127;
    double t396 = t1073-t1890*t3284+t2256*(t1120*t2256-t3450);
    double t1760 = t2254*t1887;
    double t1121 = t1890*t2255+t1760;
    double t1075 = t1121*t2232;
    double t3273 = t3727*t2257;
    double t3842 = t1887*t3727;
    double t3696 = t1121*t2256-t3842;
    double t397 = -t1890*t3273+t2256*t3696+t1075;
    double t2237 = x[22];
    double t3168 = t2237*t2238;
    double t1888 = t2235*t2240-t3168;
    double t3138 = t2241*t2237;
    double t3187 = t2235*t2243;
    double t1892 = -t3138+t3187;
    double t1124 = t1888*t2252+t1892*t2253;
    double t1077 = t1124*t2230;
    double t3446 = t1888*t2127;
    double t398 = t1077-t1892*t3285+(t1124*t2254-t3446)*t2254;
    double t1071 = t1120*t2230;
    double t2437 = -t2254*(t1120*t2254-t3450)+t1890*t3285-t1071;
    double t3132 = t2242*t2254;
    double t2093 = t2235*t3132;
    double t1380 = t1757+t2093;
    double t2094 = t2230*t3188;
    double t1047 = t1380*t2254+t2094;
    double t3017 = t3067+t2090;
    double t3049 = t3017*t3726;
    double t3928 = t1047*t2251+t3049;
    double t3106 = t2245*t2248;
    double t3117 = t2244*t2249;
    double t3927 = -t3117-t3106;
    double t3108 = t2245*t2246;
    double t3119 = t2244*t2247;
    double t3926 = -t3119-t3108;
    double t992 = t2161*t3725+t2605;
    double t997 = t2159*t3725-t1443;
    double t3925 = -t2239*t997-t2242*t992;
    double t3268 = t3726*t2239;
    double t3334 = t1939*t2258;
    double t3338 = t1939*t2234;
    double t3656 = t3338+(-t3268+t3334)*t2258;
    double t3764 = t3726*t2157;
    double t3922 = t3656-t3764;
    double t1602 = t2163*t2239+t2167*t2242;
    double t3847 = t1602*t3730;
    double t3921 = -t1013*t2239+t1059*t2242+t3847;
    double t2171 = t2258-t2252;
    double t2176 = t2259-t2253;
    double t1610 = t2171*t2240+t2176*t2243;
    double t3897 = t3730*t1610;
    double t1729 = t2226+t1869;
    double t1568 = t1729*t2258;
    double t2202 = t2234*t2252;
    double t2956 = t2233*t2252+t2202;
    double t821 = t2018*t2252-t1568+t2956;
    double t1873 = t2233+t2018;
    double t2203 = t2234*t2253;
    double t3454 = t1729*t2259;
    double t891 = -t1873*t2253-t2203+t3454;
    double t3920 = -t2240*t821+t2243*t891+t3897;
    double t1730 = t2226+t1870;
    double t1571 = t1730*t2258;
    double t2021 = t2226+t3726;
    double t822 = t2021*t2252-t1571+t2956;
    double t1874 = t2233+t2021;
    double t3453 = t1730*t2259;
    double t892 = -t1874*t2253-t2203+t3453;
    double t3919 = -t2240*t822+t2243*t892+t3897;
    double t2189 = t2255*t2232;
    double t2960 = t2231*t2255+t2189;
    double t1438 = -t3273+t2960;
    double t3829 = -t2169*t3725+t1438;
    double t2186 = t2254*t2232;
    double t2194 = t2256*t2254;
    double t1447 = (t2194-t3727)*t2256+t2186;
    double t999 = t2165*t3725-t1447;
    double t3918 = -t2239*t999+t2242*t3829;
    double t2789 = t3726*t3185;
    double t2535 = t763*t2789;
    double t2808 = t2127*t3185;
    double t2536 = t773*t2808;
    double t3281 = t3727*t2235;
    double t2920 = t767*t3281;
    double t3833 = t3733*t3730;
    double t2951 = t2247*(t2220*t3680-(-t2244*t3680-t2920)*t2244-t2535)+t165*t2222+(t165*t2246+t3833*t767-t2536)*t2246;
    double t2963 = t2231*t2253+t2182;
    double t1436 = -t3284+t2963;
    double t3830 = -t2167*t3725+t1436;
    double t2192 = t2256*t2252;
    double t1445 = (t2192-t2127)*t2256+t2180;
    double t998 = t2163*t3725-t1445;
    double t3916 = t2239*t998-t2242*t3830+t3847;
    double t547 = t1548-t3028+t3001;
    double t3911 = t2245*t547;
    double t2992 = -t1939*t2233-t3338;
    double t557 = t1939*t2127-t2992-t3027;
    double t3910 = t2245*t557;
    double t558 = t1939*t3727-t2992-t3026;
    double t3909 = t2247*t558;
    double t3157 = t2238*t2242;
    double t2085 = t2237*t3157;
    double t2754 = t2235*t3152;
    double t1725 = -t2085+t2754;
    double t1508 = t1725*t2255;
    double t1761 = t2254*t1888;
    double t1658 = t2239*t1761;
    double t974 = -t1658-t1508;
    double t3908 = t2256*t974;
    double t1657 = t1888*t2146;
    double t971 = t1725*t2253+t1657;
    double t880 = t971*t2254;
    double t3906 = t971*t2256;
    double t1410 = t2383-t1921;
    double t2279 = t1410*t3730-t542;
    double t2590 = t3729*t773;
    double t3899 = t1947*t2590;
    double t3418 = t1906*t3732;
    double t3432 = t1895*t2257;
    double t3433 = t1895*t2256;
    double t3896 = (t2258*(t3432-t1767)-t2259*(t3433+t1769)+t3418)*t2245;
    double t3370 = t1922*t2243;
    double t3380 = t1922*t3732;
    double t3895 = (t2258*(-t1922*t2240+t3432)-t2259*(t3433+t3370)+t3380)*t2247;
    double t2250 = x[9];
    double t2225 = std::pow(t2250, 2);
    double t3894 = t2225+t3730;
    double t1731 = t2226+t1871;
    double t3780 = t1731*t1947;
    double t3891 = -t2021*t3733-t2997+t3780;
    double t2325 = t3731*t1731;
    double t3890 = t1922*t2021-t2325+t3001;
    double t1846 = t2226*t1922;
    double t3343 = t1939*t2018;
    double t3889 = t3002+t1846-t3343;
    double t2324 = t1947*t1729;
    double t3396 = t1908*t2234;
    double t3008 = t1908*t2233+t3396;
    double t3403 = t1908*t2018;
    double t3888 = t3008+t3403-t2324;
    double t2323 = t1947*t1730;
    double t3887 = t1908*t2021-t2323+t3008;
    double t1845 = t2226*t1908;
    double t3841 = t2017*t3732;
    double t3886 = t3009+t1845-t3841;
    double t2327 = t3731*t1729;
    double t3885 = t1906*t2018-t2327+t3012;
    double t2326 = t3731*t1730;
    double t3884 = t1906*t2021-t2326+t3012;
    double t1844 = t2226*t1906;
    double t3344 = t1939*t2017;
    double t3883 = t3013+t1844-t3344;
    double t1552 = t3727*t1905;
    double t3422 = t1905*t2232;
    double t3015 = t1905*t2231+t3422;
    double t528 = t1552+t3015-t3033;
    double t1775 = t1905*t2256;
    double t2805 = t2127*t2142;
    double t761 = t3422+(t1775-t3292)*t2256-t2805;
    double t2593 = t3727*t761+t3729*t528;
    double t3881 = t3729+t3730;
    double t1574 = t1731*t2258;
    double t2206 = t2234*t2256;
    double t2957 = t2233*t2256+t2206;
    double t3303 = t2018*t2256;
    double t826 = -t1574+t2957+t3303;
    double t2207 = t2234*t2257;
    double t3452 = t1731*t2259;
    double t900 = -t1873*t2257-t2207+t3452;
    double t3880 = -t2239*t826+t2242*t900;
    double t3304 = t2017*t2256;
    double t825 = -t1571+t2957+t3304;
    double t1872 = t2233+t2017;
    double t899 = -t1872*t2257-t2207+t3453;
    double t3879 = -t2239*t825+t2242*t899;
    double t2204 = t2234*t2254;
    double t2961 = t2233*t2254+t2204;
    double t824 = t2021*t2254-t1574+t2961;
    double t2205 = t2234*t2255;
    double t896 = -t1874*t2255-t2205+t3452;
    double t3878 = -t2239*t824+t2242*t896;
    double t823 = t2017*t2254-t1568+t2961;
    double t895 = -t1872*t2255-t2205+t3454;
    double t3877 = -t2239*t823+t2242*t895;
    double t3876 = t2239*t822-t2242*t892;
    double t3875 = t2239*t821-t2242*t891;
    double t3874 = -t2240*t826+t2243*t900;
    double t3873 = -t2240*t825+t2243*t899;
    double t3872 = -t2240*t823+t2243*t895;
    double t2173 = t2258-t2254;
    double t2177 = t2259-t2255;
    double t1612 = t2173*t2240+t2177*t2243;
    double t3869 = t1612*t3729-t2240*t824+t2243*t896;
    double t3270 = t3726*t2226;
    double t2311 = t2021*t3725+t3270;
    double t2044 = t2226*t2127;
    double t1016 = t2017*t3726+t2044;
    double t3633 = t3731*t1016;
    double t293 = t1906*t2311-t3633;
    double t3282 = t3727*t2226;
    double t2313 = t2018*t3725+t3282;
    double t1015 = t2017*t3727+t2044;
    double t3634 = t3731*t1015;
    double t289 = t1906*t2313-t3634;
    double t3630 = t1947*t1016;
    double t294 = t1908*t2311-t3630;
    double t3631 = t1947*t1015;
    double t290 = t1908*t2313-t3631;
    double t1017 = t2018*t3726+t3282;
    double t3632 = t3731*t1017;
    double t295 = t1922*t2311-t3632;
    double t1014 = t2019*t2254-t1733+t2186;
    double t3695 = -t2019*t2255-t2189+t3451;
    double t3865 = -t1014*t2239+t2242*t3695;
    double t2188 = t2255*t2252;
    double t2962 = t2185-t2188;
    double t1376 = t2962*t1895;
    double t1036 = t3732*t1376;
    double t3156 = t2238*t2243;
    double t1893 = -t2240*t2241+t3156;
    double t3439 = t1893*t2237;
    double t1645 = t2253*t3439;
    double t1646 = t2254*t3439;
    double t2887 = t1888*t3290;
    double t2336 = -t1881*t1888+t2230*t1645+(t1646*t2253-t2887)*t2254;
    double t2086 = t2235*t3136;
    double t2743 = t2236*t3156;
    double t1726 = -t2086+t2743;
    double t2890 = t1887*t3290;
    double t3167 = t2237*t2239;
    double t3173 = t2236*t2240;
    double t1889 = -t3167+t3173;
    double t1650 = t1889*t2145;
    double t2084 = t2240*t3139;
    double t1721 = -t2084+t2085;
    double t3024 = -t1721*t2253+t1650;
    double t865 = t3024*t2254;
    double t2936 = t1726*t3285+t2254*(-t865-t2890)-t3024*t2230;
    double t1724 = -t2084+t2754;
    double t1365 = t2127*t1724;
    double t1369 = t1890*t1881;
    double t2083 = t2239*t3138;
    double t1723 = -t2083+t2743;
    double t1894 = t2236*t2243-t2237*t2242;
    double t2870 = t1894*t2148;
    double t950 = t1723*t2252+t2870;
    double t343 = t2230*t950+t2254*(t2254*t950+t1365)+t1369;
    double t1420 = t1892*t3290;
    double t2874 = t2252*t3439;
    double t517 = -t2230*t2874-t1892*t1881-(t1646*t2252+t1420)*t2254;
    double t1722 = -t2083+t2086;
    double t966 = -t1722*t2253-t1657;
    double t869 = t966*t2254;
    double t2877 = t1892*t2149;
    double t3456 = t1725*t2252;
    double t954 = t2877+t3456;
    double t590 = -t2255*t954+t869;
    double t18 = -(t2232*t590+t2257*t343-(-t2256*t590+t2936)*t2256)*t2245+t1036*t2220-t2244*(-t2244*t1036+t1124*t3361+t517*t2257+(t1124*t3354+t2336)*t2256);
    double t2193 = t2256*t2253;
    double t2197 = t2257*t2252;
    double t2959 = t2193-t2197;
    double t1377 = t2959*t1895;
    double t1038 = t1947*t1377;
    double t1370 = t1890*t1882;
    double t3161 = t2237*t2256;
    double t1643 = t1893*t3161;
    double t1842 = t3732*t2234;
    double t3330 = t3732*t2258;
    double t870 = t966*t2256;
    double t3628 = -t2257*t954+t870;
    double t867 = t3024*t2256;
    double t2949 = t2245*(t2234*t3628+t2259*(t2232*t950+t2256*(t2256*t950+t1365)+t1370)-(-t3628*t2258-t3024*t2232+t1726*t3284+(-t867-t2890)*t2256)*t2258)+(-t2244*t1038+t1124*t1842+(-t2232*t2874-t1892*t1882-(t1643*t2252+t1420)*t2256)*t2259+(t1124*t3330+t2232*t1645-t1888*t1882+(t1645*t2256-t2887)*t2256)*t2258)*t2244-t2220*t1038;
    double t1037 = t1947*t1376;
    double t3353 = t3733*t2258;
    double t2950 = t2245*(t2234*t590+t2259*t343-(-t2258*t590+t2936)*t2258)+(-t2244*t1037+t1124*t3359+t517*t2259+(t1124*t3353+t2336)*t2258)*t2244-t2220*t1037;
    double t2195 = t2256*t2255;
    double t2198 = t2257*t2254;
    double t2958 = t2195-t2198;
    double t1378 = t2958*t1895;
    double t1039 = t1947*t1378;
    double t1371 = t1890*t1883;
    double t2873 = t2255*t3439;
    double t2889 = t1887*t3835;
    double t3038 = t1722*t2255+t1658;
    double t871 = t3038*t2256;
    double t1510 = t2254*t1725;
    double t1665 = t1892*t3131;
    double t956 = t1665+t1510;
    double t3627 = -t2257*t956-t871;
    double t3741 = -t1892*t2255-t1761;
    double t1651 = t1889*t2151;
    double t963 = t1721*t2255-t1651;
    double t868 = t963*t2256;
    double t1663 = t1894*t2153;
    double t952 = t1723*t2254+t1663;
    double t2948 = t2247*(t2234*t3627+t2259*(t2232*t952+t2256*(t1724*t3727+t2256*t952)+t1371)-(-t3627*t2258+t963*t2232+t1726*t3273+(t868-t2889)*t2256)*t2258)+t2246*(-t2246*t1039-t3741*t1842+(-t2232*t1646-t1892*t1883-(t1646*t2256+t1892*t3835)*t2256)*t2259+(-t3741*t3330+t2232*t2873-t1888*t1883+t2256*(t1643*t2255-t1888*t3835))*t2258)-t2222*t1039;
    double t3629 = t1947*t1017;
    double t296 = t2311*t3733-t3629;
    double t1843 = t2226*t1905;
    double t3722 = -t1938*t2017+t1843+t3015;
    double t204 = t2226*t761+t3722*t3725;
    double t3677 = t1905*t2229-t1921*t2017+t1843+t3424;
    double t203 = t2226*t760+t3677*t3725;
    double t2572 = t2240*t3726;
    double t2265 = t1842+(-t2572+t3330)*t2258;
    double t3863 = t3359+t2258*(-t3835+t3353);
    double t3300 = t3730*t2127;
    double t3858 = t3300*t770;
    double t1702 = t2143+t1908;
    double t1714 = t1908*t2143;
    double t717 = t1702*t3733-t1714;
    double t3857 = t3725*t717;
    double t718 = t1702*t3732-t1714;
    double t3856 = t3725*t718;
    double t1704 = t2143+t3733;
    double t1715 = t3733*t2143;
    double t721 = t1704*t3732-t1715;
    double t3855 = t3725*t721;
    double t2929 = t775*t3300;
    double t1598 = t2159*t2239+t2161*t2242;
    double t3849 = t1598*t2245;
    double t3848 = t1602*t2245;
    double t3233 = t2173*t2239;
    double t1611 = t2177*t2242+t3233;
    double t3846 = t1611*(-t2225-t3729);
    double t3845 = t1612*t2245;
    double t2175 = t2258-t2256;
    double t2178 = t2259-t2257;
    double t3223 = t2178*t2243;
    double t1614 = t2175*t2240+t3223;
    double t3844 = t1614*t2245;
    double t3843 = t1614*t2247;
    double t3840 = t2245*t3705;
    double t3839 = t2247*t3705;
    double t2208 = t2259*t2252;
    double t3838 = t3726*t2208;
    double t3837 = t3726*t2235;
    double t3836 = t3727*t2208;
    double t3834 = t3732*t2018;
    double t3363 = t3733*t2017;
    double t967 = t1723*t2253+t1650;
    double t3826 = -t2167*t2247+t2169*t2245;
    double t3825 = t2227*t2235+t2140;
    double t2321 = t1947*t1870;
    double t3824 = -t1908*t3726+t2321;
    double t2322 = t1947*t1869;
    double t3823 = t2322-t1554;
    double t3208 = t2222*t2245;
    double t3278 = t3727*t2245;
    double t3818 = t2221*t3278+t3208*t3727;
    double t3209 = t2222*t2244;
    double t3817 = t2221*t2244+t3209;
    double t3341 = t1939*t2220;
    double t3816 = t1939*t2219+t3341;
    double t3445 = t1888*t3727;
    double t3812 = -t2258*t3741-t3445;
    double t3697 = t2256*t3741+t3445;
    double t1930 = -t2148+t2155;
    double t2602 = t2145-t1930;
    double t1401 = t2142-t2602;
    double t3674 = t1401*t3729-t528;
    double t3179 = t2235*t2254;
    double t1913 = t2144-t3179;
    double t1849 = t2254*t1913;
    double t2141 = t2235*t2230;
    double t1453 = t1849-t2141;
    double t2112 = t2251*t2154;
    double t1185 = t2112+t1453;
    double t3178 = t2235*t2256;
    double t1713 = t3733*t3178;
    double t3194 = t2232*t2235;
    double t2755 = t3733*t3194;
    double t447 = t2755+t1185*t3123+(t1185*t2240+t1713)*t2256;
    double t1705 = -t2143+t3733;
    double t722 = t1705*t3732+t1715;
    double t3810 = t2251*t447+t3725*t722;
    double t1108 = t2240*t1183;
    double t1712 = t1908*t3178;
    double t2756 = t1908*t3194;
    double t446 = t2756+t1183*t3123+(t1712+t1108)*t2256;
    double t1703 = -t2143+t1908;
    double t720 = t1703*t3732+t1714;
    double t3809 = t2251*t446+t3725*t720;
    double t1711 = t1908*t3179;
    double t2757 = t1908*t2141;
    double t444 = t2757+t1183*t2154+t2254*(t1711+t1108);
    double t719 = t1703*t3733+t1714;
    double t3808 = t2251*t444+t3725*t719;
    double t1361 = t1895*t3303;
    double t1373 = t2090+t2424;
    double t3807 = t1373*t3726+t1361;
    double t1910 = t2143+t2152;
    double t3388 = t1910*t2239;
    double t1397 = t2696+t3388;
    double t2818 = t2018*t3432;
    double t3806 = t1397*t3726-t2818;
    double t3734 = t2140+(t2144+t3181)*t2252;
    double t2416 = t3734+t2109;
    double t3804 = t1702*t3725+t2251*t2416;
    double t1364 = t2127*t1723;
    double t1368 = t1894*t1877;
    double t1666 = t1890*t2150;
    double t957 = t1724*t2252+t1666;
    double t2364 = t2230*t957+t2254*(t2254*t957+t1364)+t1368;
    double t2883 = t1889*t3292;
    double t1661 = t1887*t2147;
    double t975 = t1726*t2253-t1661;
    double t3542 = t975*t2254;
    double t2937 = t1721*t3285+(-t2883+t3542)*t2254+t975*t2230;
    double t3460 = t1722*t2252;
    double t953 = t2877+t3460;
    double t586 = t2255*t953+t880;
    double t3801 = t2257*t2364-t586*t2232-(t2256*t586+t2937)*t2256;
    double t1360 = t1895*t3304;
    double t1372 = t2090+t1769;
    double t2697 = t2240*t2149;
    double t1899 = t2143+t2147;
    double t3426 = t1899*t2239;
    double t1396 = t2697+t3426;
    double t2819 = t2017*t3432;
    double t2033 = t2242*t2109;
    double t3149 = t2239*t2251;
    double t2100 = t2243*t3149;
    double t989 = t2092+t2033+t2252*(t2091+t2100);
    double t901 = t2251*t989;
    double t2679 = t2251*t2149;
    double t2024 = t2240*t2679;
    double t3772 = t2239*t3734;
    double t1041 = t2024+t3772;
    double t942 = t2251*t1041;
    double t3799 = t2258*(t1396*t3726-t2819+t942)+t2259*(t1372*t3726+t1360+t901);
    double t1359 = t2017*t3067;
    double t2820 = t2017*t3065;
    double t3798 = t2258*(t1396*t3727-t2820+t942)+t2259*(t1372*t3727+t1359+t901);
    double t3793 = t2240*t997+t2243*t992;
    double t2575 = t3730*t3725;
    double t3792 = t2575*t766;
    double t3791 = t2575*t767;
    double t2925 = t3729*t699;
    double t1214 = t1890*t3406;
    double t2864 = t1890*t3414;
    double t1891 = -t2239*t2241+t3157;
    double t3440 = t1891*t2236;
    double t2880 = t2255*t3440;
    double t2298 = -t1121*t3412-(t1906*t3696+t2127*t2880)*t2256+(t2864+t2254*(t2127*t3440+t1214))*t2257;
    double t292 = t2313*t3732-t3629;
    double t2991 = t2233*t3732+t1842;
    double t560 = t3727*t3732-t2320+t2991;
    double t3788 = -t2225*t560-t292;
    double t2310 = t2017*t3725+t2044;
    double t288 = t2310*t3732-t3630;
    double t559 = t2127*t3732-t2321+t2991;
    double t3787 = -t2225*t559-t288;
    double t286 = t2310*t3733-t3631;
    double t551 = t1549-t2322+t2997;
    double t3786 = -t2225*t551-t286;
    double t3062 = t2257*t2258;
    double t2686 = t2240*t3062;
    double t2866 = t1895*t2197;
    double t2375 = -(-t1908*t3145+t2866)*t2259-t1906*t2686;
    double t2865 = t1895*t2198;
    double t2373 = -(-t3145*t3733+t2865)*t2259-t1922*t2686;
    double t2867 = t1895*t2188;
    double t1057 = t1906*t2152+t2867;
    double t2856 = t1908*t2195;
    double t2374 = t1057*t2257-t2239*t2856;
    double t1056 = -t1908*t3147+t2867;
    double t2688 = t2240*t2195;
    double t2377 = -t1056*t2257-t1906*t2688;
    double t2201 = t2258*t2255;
    double t2687 = t2240*t2201;
    double t2376 = -t1056*t2259-t1906*t2687;
    double t3779 = t1889*t3280;
    double t2210 = t2259*t2256;
    double t1981 = t2210-t3062;
    double t3435 = t1895*t1981;
    double t3357 = t3733*t2246;
    double t3349 = t1938*t2253;
    double t3331 = t3732*t2248;
    double t2318 = t1947*t2021;
    double t2209 = t2259*t2254;
    double t1976 = -t2201+t2209;
    double t3778 = t1976*t3729;
    double t2953 = t2225+t2226;
    double t3773 = t3725*t2953;
    double t3200 = t2225*t2246;
    double t3755 = t3730*t1400;
    double t2304 = -t766+t3755;
    double t3771 = t2304*t3732;
    double t3770 = t2304*t1947;
    double t3767 = (-t773+t3692)*t1947;
    double t3766 = t3903*t1947;
    double t1119 = t2251*t1183;
    double t3762 = -t1703*t3726-t1119;
    double t3761 = -t1703*t3727-t1119;
    double t1408 = t3731-t1906;
    double t3753 = t3730*t1408;
    double t1415 = -t2156+t3140+t3223;
    double t3751 = t2126*t1415;
    double t3750 = t3725*t1398;
    double t3749 = t3725*t1401;
    double t3748 = t3725*t1404;
    double t1292 = t1401*t2245;
    double t1358 = t2251*t1413;
    double t3747 = -t1358-t1292;
    double t1599 = t2159*t2240+t2161*t2243;
    double t3746 = t3730*t1599;
    double t1765 = t2256*t1888;
    double t2884 = t2239*t1765;
    double t2431 = -t1722*t2257-t2884;
    double t3745 = t1658-t967;
    double t1659 = t1887*t2156;
    double t3035 = -t1724*t2257-t1659;
    double t2876 = t1892*t3129;
    double t2429 = -t1725*t2256-t2876;
    double t1662 = t1887*t2152;
    double t976 = t1726*t2255-t1662;
    double t1668 = t1890*t3123;
    double t3034 = t1726*t2256-t1668;
    double t1522 = t2252*t1721;
    double t949 = -t1522+t2870;
    double t1505 = t1724*t2255;
    double t3744 = -t1662-t1505;
    double t3068 = t2254*t1721;
    double t3743 = t1663-t3068;
    double t1667 = t1890*t2154;
    double t960 = -t1726*t2254+t1667;
    double t3019 = t1947*t3732;
    double t2218 = std::pow(t2243, 2);
    double t2215 = std::pow(t2240, 2);
    double t3219 = t2215*t2252;
    double t3742 = (-t2147*t2243-t2218*t2253)*t2259+(-t2150*t2240-t3219)*t2258;
    double t2390 = -t1887*t2256-t1890*t2257;
    double t2389 = -t1892*t2257-t1765;
    double t1912 = t2144+t3179;
    double t3738 = t1912*t2254+t2141;
    double t2062 = t2176*t2247;
    double t2075 = t2251*t2161;
    double t3737 = t2075-t2062;
    double t2063 = t2176*t2249;
    double t2078 = t2251*t2167;
    double t3736 = t2078-t2063;
    double t2064 = t2177*t2249;
    double t2079 = t2251*t2169;
    double t3735 = t2079-t2064;
    double t3252 = t2161*t2249;
    double t3723 = -t3252-t3826;
    double t3721 = t1947*t1908;
    double t3720 = -t2240*t998+t2243*t3830-t3828;
    double t2073 = t2165*t2259;
    double t3719 = -t2958-t2073;
    double t2082 = t2258*t2169;
    double t3718 = t2958-t2082;
    double t2071 = t2163*t2259;
    double t3717 = -t2959-t2071;
    double t2081 = t2258*t2167;
    double t3716 = t2959-t2081;
    double t2069 = t2159*t2259;
    double t3715 = -t2962-t2069;
    double t2080 = t2258*t2161;
    double t3714 = t2962-t2080;
    double t3713 = t2126*t2251;
    double t3712 = t2126*t2246;
    double t3711 = t2126*t2244;
    double t3710 = t3729*t2251;
    double t3709 = t3730*t2251;
    double t2164 = t2256+t2254;
    double t2072 = t2164*t2259;
    double t2172 = t2258+t2254;
    double t3708 = t2172*t2257-t2072;
    double t2162 = t2256+t2252;
    double t2070 = t2162*t2259;
    double t2170 = t2258+t2252;
    double t3707 = t2170*t2257-t2070;
    double t2158 = t2254+t2252;
    double t2068 = t2158*t2259;
    double t3706 = t2170*t2255-t2068;
    double t3335 = t1939*t2249;
    double t3703 = -t3331+t3335;
    double t3702 = t2126*t3926;
    double t2317 = -t1888*t3726-t2258*t2389;
    double t1409 = t1947-t1908;
    double t3480 = t1409*t2220;
    double t3481 = t1409*t2219;
    double t3694 = -t3480-t3481;
    double t3494 = t1404*t2247;
    double t3690 = t3494-t1292;
    double t3689 = t3494+t1358;
    double t1407 = t2383-t1905;
    double t529 = t1552+t3014-t3032;
    double t2583 = -t1407*t3729+t529;
    double t2582 = -t1407*t2126+t530;
    double t2581 = -t1410*t2126+t543;
    double t3378 = t1922*t2017;
    double t3678 = t1906*t2229+t1844-t3378+t3414;
    double t3675 = t1398*t2126-t3904;
    double t1248 = t2256*t1376;
    double t1249 = t2232*t1376;
    double t3584 = t2239*t766;
    double t251 = (-t1248-t3584)*t2256-t1249-t766*t3129;
    double t3644 = -t2404*t3185-t2410*t3186;
    double t607 = t1400*t1939-t1376;
    double t3673 = -t3730*t607-t251+t3644;
    double t3672 = t289*t3730+t3282*t765;
    double t3671 = t293*t3730+t3270*t765;
    double t3670 = t295*t3729+t3270*t772;
    double t3669 = t2246*t3730;
    double t3668 = t2248*t3730;
    double t3667 = t2248*t3729;
    double t1609 = t2171*t2239+t2176*t2242;
    double t3662 = t3894*t1609;
    double t1184 = t2112+t3738;
    double t3661 = t1184*t2251+t1704*t3725;
    double t1240 = t1906*t3330;
    double t1241 = t1906*t1842;
    double t2869 = t1895*t3284;
    double t777 = -t3121*t3726+t2265;
    double t2443 = (t2258*(-t1906*t2572+t1240+t2869)-t2259*(t2232*t1769+t2256*(t1906*t3124+t1516))+t1241)*t2245-t777*t3393;
    double t1238 = t1906*t3353;
    double t1239 = t1906*t3359;
    double t774 = -t3121*t3727+t3863;
    double t2444 = (t2258*(t1238+t2348)-t2259*t743+t1239)*t2245-t774*t3393;
    double t1035 = t1922*t1377;
    double t3408 = t1906*t2245;
    double t1152 = -t3393+t3408;
    double t1233 = t2962*t3440;
    double t1234 = t2962*t3439;
    double t2888 = t1888*t3291;
    double t1504 = t1724*t2253;
    double t969 = t1504+t1661;
    double t876 = t969*t2254;
    double t2379 = -t1722*t3285+(t876-t2888)*t2254+t969*t2230;
    double t2441 = -t2254*(-t869-t2890)+t1724*t3285+t966*t2230;
    double t2900 = t1152*t1378;
    double t3313 = t2958*t2246;
    double t1366 = t2127*t1726;
    double t345 = -t954*t2230+t1369-(t2254*t954+t1366)*t2254;
    double t2467 = t1892*t1878;
    double t3457 = t1725*t2127;
    double t958 = -t1726*t2252+t1666;
    double t346 = t958*t2230-t2467+(t2254*t958-t3457)*t2254;
    double t3626 = -t2255*t950-t865;
    double t384 = t2239*t2437;
    double t385 = t2240*t398;
    double t873 = t967*t2254;
    double t580 = t2255*t949+t873;
    double t2286 = (-t1035*t2220+(-t2232*t1233+t2437*t3129-(t1233*t2256-t384)*t2256)*t2245+t2244*(-t2244*t1035+t580*t2232+t346*t2257+(t2256*t580+t2379)*t2256))*t2247-((-t3626*t2232+t345*t2257+(-t2256*t3626+t2441)*t2256)*t2245-t2244*(-t2232*t1234-t398*t3123-t2256*(t1234*t2256+t385))+(-t1152*t3313-t2959*t3833)*t1895)*t2246+t2222*t2900;
    double t1246 = t1922*t3330;
    double t1247 = t1922*t1842;
    double t2868 = t1895*t3273;
    double t3193 = t2232*t2243;
    double t3434 = t1895*t3727;
    double t2442 = (t2258*(-t1922*t2572+t1246+t2868)-t2259*(t1922*t3193+(t1922*t3124+t3434)*t2256)+t1247)*t2247-t777*t3357;
    double t3657 = t1908*t2229+t1845-t3363+t3400;
    double t741 = t2240*t763;
    double t252 = -t1249+t763*t3123+(-t1248+t741)*t2256;
    double t3652 = t2244*(t2244*t252+t2920)+t252*t2220;
    double t1250 = t2258*t1376;
    double t1251 = t2234*t1376;
    double t253 = -t1251+t763*t3121+(-t1250+t741)*t2258;
    double t3389 = t1908*t2258;
    double t768 = -t2127*t3121+(-t3290+t3389)*t2258+t3396;
    double t2919 = t768*t3281;
    double t3651 = t2244*(t2244*t253+t2919)+t253*t2220;
    double t1256 = t2258*t1377;
    double t1257 = t2234*t1377;
    double t255 = -t1257+t764*t3121+(t2240*t764-t1256)*t2258;
    double t2915 = t768*t3837;
    double t3650 = t2244*(t2244*t255+t2915)+t255*t2220;
    double t1258 = t2258*t1378;
    double t1259 = t2234*t1378;
    double t257 = -t1259+t771*t3121+(t2240*t771-t1258)*t2258;
    double t2914 = t774*t3837;
    double t3649 = t2246*(t2246*t257+t2914)+t257*t2222;
    double t2095 = t2242*t2152;
    double t2097 = t2239*t2154;
    double t3648 = (t2017*t2095+t1623+t3967)*t2259+(t2017*t2097+t1620+t3945)*t2258;
    double t2096 = t2242*t2156;
    double t2098 = t2239*t3123;
    double t3647 = (t2017*t2096+t1624+t3966)*t2259+(t2017*t2098+t1621+t3946)*t2258;
    double t1625 = t2018*t2099;
    double t3646 = (t2018*t2096+t1625-t3928)*t2259+(t2018*t2098+t1622+t3947)*t2258;
    double t538 = t3008-t3823;
    double t3645 = -t3185*t428+t3186*t538;
    double t539 = t3008-t3824;
    double t3643 = -t3185*t435+t3186*t539;
    double t3183 = t2235*t2247;
    double t3184 = t2235*t2246;
    double t3641 = -t3183*t440+t3184*t552;
    double t2710 = t2239*t2147;
    double t1391 = t3069+t2710;
    double t2484 = t2253*t2088;
    double t1005 = t1391*t2255-t2484;
    double t1392 = t3069-t2710;
    double t1006 = t1392*t2255+t2484;
    double t2028 = t2252*t2097;
    double t2674 = t2242*t2185;
    double t2477 = t2240*t2674;
    double t1485 = t2028-t2477;
    double t2677 = t2242*t2188;
    double t2026 = t2240*t2677;
    double t2110 = t2243*t2185;
    double t2027 = t2239*t2110;
    double t1486 = -t2026+t2027;
    double t3142 = t2240*t2244;
    double t2843 = t2962*t3142;
    double t3151 = t2239*t2245;
    double t2844 = t2962*t3151;
    double t223 = (t1939*t2844-(-t1005*t2256+t1486*t2257)*t2244)*t2247+t2246*((-t1006*t2256+t1485*t2257)*t2245+t3732*t2843);
    double t3120 = t2244*t2246;
    double t2792 = t3727*t3120;
    double t2799 = t3727*t3209;
    double t3639 = t761*t2799+t2246*(t2792*t761-t3300*t769);
    double t3638 = t3818*t762;
    double t3267 = t3726*t2245;
    double t3637 = t2126*t762*t3267;
    double t3636 = t2126*t2247*t3544;
    double t2804 = t2127*t3120;
    double t2809 = t2127*t3209;
    double t3299 = t3730*t3727;
    double t2928 = t764*t3299;
    double t206 = t771*t2809+t2246*(t2804*t771-t2928);
    double t3635 = (t873-t2888)*t2254+t967*t2230;
    double t887 = t2256*t967;
    double t581 = t2257*t949+t887;
    double t968 = t1723*t2255+t1651;
    double t875 = t968*t2256;
    double t584 = t2257*t3743+t875;
    double t587 = t2257*t953+t3906;
    double t1524 = t2254*t1722;
    double t955 = t1665+t1524;
    double t591 = t2257*t955-t3908;
    double t3625 = -t2257*t950-t867;
    double t3624 = -t2257*t952+t868;
    double t3623 = t1014*t2240-t2243*t3695;
    double t171 = t3727*t768+t3730*t538;
    double t3621 = t171*t2247;
    double t172 = t3726*t768+t3730*t539;
    double t3620 = t172*t2249;
    double t176 = t3726*t774+t3729*t552;
    double t3619 = t176*t2249;
    double t3618 = t3731*t771;
    double t3610 = t2127*t771;
    double t3609 = t3727*(t2246*t777+t2247*t3922);
    double t3564 = t2251*t953;
    double t3563 = t2251*t971;
    double t1626 = t1887*t3181;
    double t1627 = t1887*t2140;
    double t3442 = t1889*t2238;
    double t1648 = t2251*t3442;
    double t3076 = t2251*t2253;
    double t620 = t1627+t1723*t3076+(t1626+t1648)*t2252;
    double t3562 = t2254*t620;
    double t3561 = t2254*t949;
    double t3560 = t2256*t620;
    double t3559 = t2256*t975;
    double t3558 = t2256*t976;
    double t3557 = t251*t2220;
    double t285 = t1922*t2310-t3634;
    double t3556 = t285*t2245;
    double t3555 = t286*t2245;
    double t287 = t1939*t2310-t3633;
    double t3554 = t287*t2245;
    double t3553 = t288*t2245;
    double t291 = t1939*t2313-t3632;
    double t3552 = t291*t2247;
    double t3551 = t292*t2247;
    double t3550 = (t2244*t777+t2245*t3922)*t2127;
    double t1628 = t2235*t1760;
    double t1629 = t1887*t2141;
    double t3075 = t2251*t2255;
    double t3549 = (t1629+t1723*t3075+t2254*(t1628+t1648))*t2256;
    double t3546 = t762*t3727;
    double t3543 = t949*t2259;
    double t1660 = t1895*t2144;
    double t3537 = t1721*t2228+(t1522+t1660)*t2252;
    double t1641 = t2253*t3440;
    double t1642 = t2254*t3440;
    double t2891 = t1887*t3291;
    double t3536 = t2230*t1641+(t1642*t2253-t2891)*t2254;
    double t1638 = t2228*t3440;
    double t1656 = t2239*t1757;
    double t2726 = t2252*t3440;
    double t3535 = t1638+t2252*(t1656+t2726);
    double t1000 = t1392*t2254-t2028;
    double t2691 = t2240*t2193;
    double t2838 = t2959*t3142;
    double t491 = (t1000*t2257+t1922*t2691)*t2245-t3733*t2838;
    double t2200 = t2258*t2253;
    double t2690 = t2240*t2200;
    double t1973 = -t2200+t2208;
    double t2829 = t1973*t3142;
    double t492 = (t1000*t2259+t1922*t2690)*t2245+t3733*t2829;
    double t2659 = t2243*t2197;
    double t2031 = t2239*t2659;
    double t493 = ((t1392*t2256-t2031)*t2259+t1939*t2690)*t2245+t3732*t2829;
    double t1395 = t3065-t2088;
    double t2657 = t2243*t2198;
    double t2032 = t2239*t2657;
    double t3141 = t2240*t2246;
    double t2825 = t1976*t3141;
    double t494 = ((t1395*t2256-t2032)*t2259+t1939*t2687)*t2247+t3732*t2825;
    double t3162 = t2237*t2251;
    double t1644 = t1893*t3162;
    double t2211 = std::pow(t2235, 2);
    double t1855 = -t2211*t2243+t2235*t3138;
    double t3532 = (t1855*t2252+t1644)*t2252;
    double t3531 = (t1855*t2254+t1644)*t2254;
    double t3530 = t1046*t2230;
    double t3529 = t1046*t2232;
    double t3528 = t1047*t2232;
    double t3526 = (t1922*t2156+t2865)*t2259;
    double t3525 = t1093*t2230;
    double t3524 = t1093*t2232;
    double t3523 = t1094*t2232;
    double t3522 = t1120*t1922;
    double t3520 = t3741*t1908;
    double t3515 = t1185*t2246;
    double t3514 = t1185*t2251;
    double t1929 = t2144-t3178;
    double t3074 = t2251*t2257;
    double t2115 = t2243*t3074;
    double t1187 = t1929*t2256+t2115-t3194;
    double t3513 = t1187*t2248;
    double t3483 = t1407*t2245;
    double t3482 = t1407*t2251;
    double t3477 = t1410*t2246;
    double t3476 = t1410*t2247;
    double t3475 = t1410*t2251;
    double t1411 = t2157-t3131+t3233;
    double t3474 = t1411*t2221;
    double t1433 = t3285+t2964;
    double t3471 = t1433*t2239;
    double t3470 = t1433*t2240;
    double t3469 = (t3284+t2963)*t2240;
    double t3468 = (t3273+t2960)*t2240;
    double t3467 = t1599*t2244;
    double t3466 = t1603*t2244;
    double t1605 = t2165*t2240+t2169*t2243;
    double t1465 = t1605*t2221;
    double t3465 = t1611*t2247;
    double t3464 = t1612*t2246;
    double t3463 = t1694*t2257;
    double t3462 = t1703*t2239;
    double t3461 = t1703*t2242;
    double t3458 = t1723*t3727;
    double t3448 = t1887*t2242;
    double t3438 = t1894*t2241;
    double t3437 = t1895*t1973;
    double t3436 = t1895*t1976;
    double t3429 = t3926*t2225;
    double t3428 = t3927*t2225;
    double t3427 = t3964*t2225;
    double t3420 = t1905*t2255;
    double t3419 = t1905*t2257;
    double t3415 = t1906*t2220;
    double t3409 = t1906*t2244;
    double t3407 = t1906*t2251;
    double t3401 = t1908*t2225;
    double t3395 = t1908*t2240;
    double t3394 = t1908*t2243;
    double t3391 = t1908*t2255;
    double t3383 = t1921*t2252;
    double t3382 = t1921*t2253;
    double t3381 = t1921*t2257;
    double t3379 = t1922*t1981;
    double t3376 = t1922*t2220;
    double t3369 = t1922*t2244;
    double t3368 = t1922*t2245;
    double t3367 = t1922*t2247;
    double t3366 = t1922*t2251;
    double t3358 = t3733*t2242;
    double t3356 = t3733*t2252;
    double t3355 = t3733*t2253;
    double t3350 = t1938*t2252;
    double t3348 = t1938*t2254;
    double t3347 = t1938*t2255;
    double t3346 = t1939*t1908;
    double t3345 = t1939*t3733;
    double t3340 = t1939*t2222;
    double t3337 = t1939*t2244;
    double t3336 = t1939*t2245;
    double t3332 = t3732*t2220;
    double t3329 = t3731*t2220;
    double t3328 = t3731*t2244;
    double t3327 = t3731*t2245;
    double t3326 = t3731*t2251;
    double t3323 = t2962*t2238;
    double t3322 = t2962*t2239;
    double t3321 = t2962*t2240;
    double t3320 = t2962*t2244;
    double t3319 = t2962*t2245;
    double t3318 = t2959*t2244;
    double t3317 = t2959*t2245;
    double t3316 = t2958*t2239;
    double t3315 = t2958*t2240;
    double t3314 = t2958*t2242;
    double t3312 = t2958*t2247;
    double t3311 = t1973*t2244;
    double t3310 = t1973*t2245;
    double t3309 = t1976*t2247;
    double t3308 = t1981*t2239;
    double t3307 = t1981*t2240;
    double t3306 = t1981*t2242;
    double t3305 = t1981*t2243;
    double t3302 = t2024*t2254;
    double t3301 = t2024*t2256;
    double t3296 = t3729*t3726;
    double t3295 = t3729*t3725;
    double t3294 = t2127*t2222;
    double t3293 = t2127*t2235;
    double t3289 = t2127*t2244;
    double t3288 = t2127*t2245;
    double t3287 = t2127*t2246;
    double t3286 = t2127*t2251;
    double t3283 = t2127*t2259;
    double t3277 = t3727*t2246;
    double t3276 = t3727*t2247;
    double t3275 = t3727*t2251;
    double t3274 = t3727*t2253;
    double t3272 = t3727*t2259;
    double t3271 = t3726*t2224;
    double t3266 = t3726*t2249;
    double t3265 = t3726*t2259;
    double t3264 = t3725*t2220;
    double t3263 = t3725*t2225;
    double t3262 = t3725*t2235;
    double t3261 = t3725*t2244;
    double t3260 = t3725*t2245;
    double t3259 = t2159*t2248;
    double t3258 = t2159*t2249;
    double t3257 = t2159*t2250;
    double t3256 = t2159*t2257;
    double t2160 = t2255+t2253;
    double t3255 = t2160*t2256;
    double t3254 = t2160*t2258;
    double t3253 = t2161*t2248;
    double t3251 = t2161*t2250;
    double t3250 = t2161*t2256;
    double t3249 = t2163*t2245;
    double t3248 = t2163*t2250;
    double t3246 = t2165*t2250;
    double t2166 = t2257+t2253;
    double t3245 = t2166*t2258;
    double t3244 = t2167*t2245;
    double t3243 = t2167*t2250;
    double t2168 = t2257+t2255;
    double t3242 = t2168*t2258;
    double t3240 = t2169*t2250;
    double t3237 = t2171*t2244;
    double t3236 = t2171*t2246;
    double t2055 = t2171*t2247;
    double t3235 = t2171*t2248;
    double t2056 = t2171*t2249;
    double t3232 = t2173*t2246;
    double t3231 = t2173*t2248;
    double t2057 = t2173*t2249;
    double t3230 = t2175*t2239;
    double t3229 = t2175*t2251;
    double t3228 = t2176*t2244;
    double t3227 = t2176*t2246;
    double t3226 = t2176*t2248;
    double t2058 = t2177*t2245;
    double t3225 = t2177*t2246;
    double t3224 = t2177*t2248;
    double t2059 = t2178*t2245;
    double t2060 = t2178*t2247;
    double t3222 = t2178*t2251;
    double t2213 = std::pow(t2237, 2);
    double t3221 = t2213*t2244;
    double t3220 = t2213*t2246;
    double t3218 = t2215*t2254;
    double t3217 = t2215*t2258;
    double t2217 = std::pow(t2242, 2);
    double t3216 = t2217*t2240;
    double t3215 = t2218*t2239;
    double t3214 = t2218*t2259;
    double t3199 = t2225*t2248;
    double t3197 = t2228*t2239;
    double t3192 = t2234*t2235;
    double t3191 = t2234*t2242;
    double t3190 = t2234*t2243;
    double t3182 = t2235*t2249;
    double t3180 = t2235*t2253;
    double t3177 = t2235*t2231;
    double t3176 = t2235*t2258;
    double t3175 = t2236*t2237;
    double t3172 = t2236*t2245;
    double t3171 = t2236*t2247;
    double t3170 = t2236*t2251;
    double t3169 = t2236*t2258;
    double t3166 = t2237*t2244;
    double t3165 = t2237*t2245;
    double t3164 = t2237*t2246;
    double t3163 = t2237*t2249;
    double t3160 = t2237*t2257;
    double t3159 = t2237*t2258;
    double t3158 = t2238*t2241;
    double t3150 = t2239*t2247;
    double t3148 = t2239*t2253;
    double t3146 = t2239*t2255;
    double t3143 = t2240*t2243;
    double t1768 = t2242*t1908;
    double t1860 = t2242*t2962;
    double t3135 = t2242*t2243;
    double t3134 = t2242*t2245;
    double t3130 = t2242*t2256;
    double t3128 = t2242*t2258;
    double t3127 = t2243*t2244;
    double t3126 = t2243*t2246;
    double t3122 = t2243*t2258;
    double t1317 = t2244*t1407;
    double t1482 = t2244*t1610;
    double t3118 = t2244*t2248;
    double t3116 = t2244*t2252;
    double t3115 = t2244*t2253;
    double t3114 = t2244*t2254;
    double t3113 = t2244*t2255;
    double t3112 = t2244*t2256;
    double t3111 = t2244*t2257;
    double t3110 = t2244*t2258;
    double t3109 = t2244*t2259;
    double t3107 = t2245*t2247;
    double t3105 = t2245*t2249;
    double t3103 = t2245*t2252;
    double t3102 = t2245*t2253;
    double t3101 = t2245*t2254;
    double t3100 = t2245*t2255;
    double t3099 = t2245*t2256;
    double t3098 = t2245*t2257;
    double t3097 = t2245*t2258;
    double t3096 = t2245*t2259;
    double t3095 = t2246*t2248;
    double t3093 = t2246*t2250;
    double t3092 = t2246*t2254;
    double t3091 = t2246*t2255;
    double t3089 = t2247*t2249;
    double t3088 = t2247*t2251;
    double t3087 = t2247*t2254;
    double t3086 = t2247*t2255;
    double t3085 = t2248*t2250;
    double t3084 = t2248*t2256;
    double t3083 = t2248*t2257;
    double t3082 = t2249*t2251;
    double t3081 = t2249*t2256;
    double t3080 = t2249*t2257;
    double t3079 = t2250*t2258;
    double t3078 = t2250*t2259;
    double t1520 = t2251*t1725;
    double t1521 = t2251*t1726;
    double t1756 = t2251*t1890;
    double t2074 = t2251*t2159;
    double t2076 = t2251*t2163;
    double t2077 = t2251*t2165;
    double t3073 = t2251*t2258;
    double t3072 = t2251*t2259;
    double t3070 = t2252*t2258;
    double t3066 = t2254*t2258;
    double t2678 = t2242*t3075;
    double t2025 = t2240*t2678;
    double t3064 = t2256*t2025;
    double t3063 = t2256*t2258;
    double t3061 = t1120*t2231+t1073;
    double t3060 = t1121*t2231+t1075;
    double t1079 = t1124*t2232;
    double t3059 = t1124*t2231+t1079;
    double t1081 = t1124*t2234;
    double t3058 = t1124*t2233+t1081;
    double t1083 = t3741*t2232;
    double t3057 = -t2231*t3741-t1083;
    double t1085 = t3741*t2234;
    double t3056 = -t2233*t3741-t1085;
    double t1087 = t2389*t2234;
    double t3055 = -t2233*t2389-t1087;
    double t1205 = t1399*t3185;
    double t1208 = t1403*t3186;
    double t3053 = t1205-t1208;
    double t1210 = t1409*t3186;
    double t3052 = t1205-t1210;
    double t1206 = t1400*t3186;
    double t1207 = t1402*t3185;
    double t3051 = t1207-t1206;
    double t3050 = t1207-t1210;
    double t3048 = (t2110-t3290)*t2254+t2230*t2150;
    double t3047 = t1605*t2244+t3840;
    double t3043 = t1611*t2245+t1612*t2244;
    double t1613 = t2178*t2242+t3230;
    double t3042 = t1613*t2245+t1614*t2244;
    double t3041 = t1613*t2247+t1614*t2246;
    double t3040 = t3730*t1609;
    double t3036 = t1724*t2256+t1668;
    double t3022 = -t1726*t2257+t1659;
    double t1850 = t1887*t2239;
    double t3020 = -t1850*t2254+t1641;
    double t3016 = t3065+t2088;
    double t2034 = t2251*t2101;
    double t2983 = t2034+t2094;
    double t2982 = -t2163*t2247+t2165*t2245;
    double t2051 = t2173*t2245;
    double t2981 = -t2055+t2051;
    double t2052 = t2175*t2245;
    double t2980 = -t2056+t2052;
    double t2053 = t2175*t2247;
    double t2979 = -t2057+t2053;
    double t2978 = -t2062+t2058;
    double t2977 = -t2063+t2059;
    double t2976 = -t2064+t2060;
    double t2975 = t2089+t2098;
    double t2974 = t2095+t2101;
    double t2973 = t2096+t2099;
    double t2118 = t2241*t2208;
    double t2972 = t2238*t3070+t2118;
    double t2120 = t2241*t2209;
    double t2971 = t2238*t3066+t2120;
    double t2122 = t2241*t2210;
    double t2970 = t2238*t3063+t2122;
    double t2106 = t2238*t3062;
    double t2969 = t2257*t3137+t2106;
    double t2107 = t2238*t2200;
    double t2968 = t2148*t2259+t2107;
    double t2108 = t2238*t2201;
    double t2967 = t2153*t2259+t2108;
    double t2966 = t2148-t2151;
    double t1949 = t2185+t2188;
    double t1955 = t2193+t2197;
    double t1959 = t2195+t2198;
    double t2955 = t2200+t2208;
    double t2954 = t2201+t2209;
    double t2139 = t2247+t2251;
    double t2952 = -t2249-t2251;
    double t60 = t586*t2234-t2364*t2259+(t2258*t586+t2937)*t2258;
    double t61 = t587*t2234+(-t957*t2232-t1894*t2805-(t2256*t957+t1364)*t2256)*t2259+(t587*t2258+t975*t2232+t1721*t3284+t2256*(-t2883+t3559))*t2258;
    double t959 = t1724*t2254+t1667;
    double t62 = t591*t2234+(-t959*t2232-t1894*t2793-(t2256*t959+t3458)*t2256)*t2259+(t591*t2258+t976*t2232+t1721*t3273+(t3558-t3779)*t2256)*t2258;
    double t593 = t2255*t957-t3542;
    double t856 = t953*t2254;
    double t859 = t953*t2230;
    double t882 = t971*t2230;
    double t63 = t593*t2232+(-t859+t1368-(t1721*t2127+t856)*t2254)*t2257+(t593*t2256-t882+t1723*t3285-(t880-t2883)*t2254)*t2256;
    double t2934 = t2240*t999-t2243*t3829+t1465;
    double t2932 = t3922*t3367;
    double t2930 = t763*t3341;
    double t2926 = t768*t3298;
    double t2924 = t774*t3296;
    double t2923 = t771*t3293;
    double t2922 = t773*t3288;
    double t2918 = t768*t3275;
    double t2911 = t3922*t3289;
    double t2910 = t760*t3120;
    double t2909 = t3892*t3186;
    double t2907 = t3926*t3547;
    double t2906 = t2244*t3545;
    double t682 = t766*t3837;
    double t2905 = t2246*t3544;
    double t2904 = t3922*t3277;
    double t1535 = t2243*t1693;
    double t2902 = t1722*t2228+t1535+(t1660+t3460)*t2252;
    double t2901 = t1120*t2143;
    double t2899 = t1406*t3185;
    double t2898 = t1408*t3185;
    double t2897 = t1411*t3183;
    double t2896 = t1412*t3185;
    double t2895 = t1415*t3185;
    double t2894 = t1415*t3183;
    double t1442 = t2179+t2254*(t2184+t2127);
    double t2893 = t1442*t3121;
    double t2892 = t2127*t1520;
    double t2886 = t1888*t2563;
    double t2885 = t1888*t2143;
    double t2882 = t1890*t3129;
    double t2881 = t2234*t3440;
    double t2879 = t1891*t3169;
    double t2878 = t1892*t2143;
    double t2875 = t2234*t3439;
    double t2872 = t1893*t3160;
    double t2871 = t1893*t3159;
    double t2863 = t1976*t3407;
    double t2862 = t2242*t3415;
    double t2861 = t2242*t3409;
    double t1907 = -t2146+t2149;
    double t2859 = t1907*t3119;
    double t1909 = -t2147+t2150;
    double t2855 = t1909*t3108;
    double t2854 = t2246*t3379;
    double t2853 = t1922*t2235*t2257;
    double t2852 = t3733*t1377;
    double t2851 = t3733*t3062;
    double t2850 = t1939*t3192;
    double t2849 = t1939*t3176;
    double t2848 = t3731*t3312;
    double t2847 = t3731*t3104;
    double t2846 = t1939*t1376;
    double t2845 = t3731*t1376;
    double t2842 = t2962*t3134;
    double t2841 = t2962*t3127;
    double t2840 = t3731*t1377;
    double t2839 = t2959*t3151;
    double t2837 = t2959*t3134;
    double t2836 = t2959*t3127;
    double t2835 = t3731*t1378;
    double t2834 = t2958*t3150;
    double t2833 = t2958*t3141;
    double t2832 = t2958*t3128;
    double t2831 = t2958*t3126;
    double t2830 = t1973*t3151;
    double t2828 = t1973*t3134;
    double t2827 = t1973*t3127;
    double t2826 = t1976*t3150;
    double t2824 = t2242*t3309;
    double t2823 = t1976*t3126;
    double t2822 = t1981*t3149;
    double t2821 = t2251*t3306;
    double t2817 = t3730*t3296;
    double t2816 = t3730*t3293;
    double t2815 = t2247*t3300;
    double t2814 = t3730*t3276;
    double t2813 = t3730*t3266;
    double t2812 = t3730*t3183;
    double t2811 = t3729*t3266;
    double t2810 = t2126*t3725*t2250;
    double t2807 = t2127*t3136;
    double t2806 = t2127*t2144;
    double t2803 = t2127*t3104;
    double t2802 = t2127*t3075;
    double t2801 = t2127*t3074;
    double t2797 = t3727*t3185;
    double t2796 = t3727*t3183;
    double t2795 = t3727*t3153;
    double t2794 = t3727*t2144;
    double t2791 = t3727*t3088;
    double t2790 = t3727*t3074;
    double t2788 = t3726*t2143;
    double t2787 = t3726*t2144;
    double t2786 = t3726*t3082;
    double t2785 = t3725*t3185;
    double t2784 = t3725*t3183;
    double t2783 = t3725*t3182;
    double t2782 = t3725*t2143;
    double t2781 = t3725*t3104;
    double t2780 = t3725*t3088;
    double t2779 = t3725*t3082;
    double t2778 = t2159*t3145;
    double t2777 = t2159*t3144;
    double t2776 = t2161*t2157;
    double t2775 = t2163*t3144;
    double t2774 = t2165*t3144;
    double t2773 = t2167*t2157;
    double t2772 = t2169*t2149;
    double t2771 = t2169*t2157;
    double t2770 = t2177*t2149;
    double t2769 = t2178*t2149;
    double t2768 = t2178*t3131;
    double t2767 = t2213*t3095;
    double t2766 = t2213*t3085;
    double t2765 = t2218*t3148;
    double t2764 = t2218*t3072;
    double t2763 = t2225*t3107;
    double t2762 = t2225*t3105;
    double t2761 = t2225*t3089;
    double t2760 = t2230*t2149;
    double t2759 = t2235*t2186;
    double t2758 = t2234*t3180;
    double t2753 = t2245*t2143;
    double t2752 = t2252*t2143;
    double t2751 = t2235*t3076;
    double t2750 = t2254*t2143;
    double t2749 = t2235*t3075;
    double t2748 = t2256*t2143;
    double t2747 = t2235*t3074;
    double t2746 = t2235*t2200;
    double t2745 = t2235*t2189;
    double t2744 = t1401*t3172;
    double t2742 = t2236*t3149;
    double t2741 = t2236*t3119;
    double t2740 = t2236*t3117;
    double t2739 = t2236*t3101;
    double t2738 = t2236*t3100;
    double t2737 = t2236*t3099;
    double t2736 = t2236*t3098;
    double t2735 = t2236*t3097;
    double t2734 = t2236*t3096;
    double t2733 = t2236*t3094;
    double t2732 = t2256*t3171;
    double t2731 = t2257*t3171;
    double t2730 = t2247*t3169;
    double t2729 = t2259*t3171;
    double t2728 = t1407*t3170;
    double t2727 = t1410*t3170;
    double t2725 = t2237*t1317;
    double t1419 = t2127*t3439;
    double t2724 = t2237*t3114;
    double t2723 = t2237*t3113;
    double t2722 = t2237*t3112;
    double t2721 = t2237*t3111;
    double t2720 = t2237*t3110;
    double t2719 = t2237*t3109;
    double t2718 = t2237*t3108;
    double t2717 = t2237*t3106;
    double t2716 = t2246*t3161;
    double t2715 = t2246*t3160;
    double t2714 = t2246*t3159;
    double t2713 = t2259*t3164;
    double t2712 = t2237*t3090;
    double t2711 = t1906*t3316;
    double t2707 = t2239*t3100;
    double t2706 = t2239*t3098;
    double t2705 = t2239*t3096;
    double t1655 = t1888*t3149;
    double t2704 = t2239*t2193;
    double t2703 = t2239*t2200;
    double t2702 = t2218*t3146;
    double t2701 = t2239*t2201;
    double t2700 = t2239*t3062;
    double t2699 = t3733*t3307;
    double t2698 = t2242*t2144;
    double t2694 = t2240*t3113;
    double t2693 = t2240*t3111;
    double t2692 = t2240*t3109;
    double t2689 = t2255*t3216;
    double t1664 = t2251*t3438;
    double t2685 = t1906*t3314;
    double t2684 = t2242*t2189;
    double t2683 = t2242*t2150;
    double t2682 = t2242*t3101;
    double t2681 = t2242*t3099;
    double t2680 = t2242*t3097;
    double t2676 = t2242*t2197;
    double t2675 = t2242*t2208;
    double t2673 = t2242*t2193;
    double t2672 = t2242*t2198;
    double t2671 = t2242*t2209;
    double t2670 = t2242*t2195;
    double t2669 = t2242*t2210;
    double t2668 = t1442*t3123;
    double t2667 = t2958*t3394;
    double t2666 = t1976*t3394;
    double t2665 = t1908*t3305;
    double t2664 = t3733*t3305;
    double t2663 = t2243*t3114;
    double t2662 = t2243*t3112;
    double t2661 = t2243*t3110;
    double t2660 = t2243*t3072;
    double t2658 = t2243*t2208;
    double t2656 = t2243*t2209;
    double t2113 = t2243*t2193;
    double t2114 = t2243*t2195;
    double t2655 = t2243*t2210;
    double t2653 = t2247*t3116;
    double t2652 = t2247*t3115;
    double t2651 = t2249*t3116;
    double t2650 = t2249*t3115;
    double t2649 = t2246*t3103;
    double t2648 = t2246*t3102;
    double t2647 = t1398*t3107;
    double t2646 = t2248*t3103;
    double t2645 = t2248*t3102;
    double t2644 = t1398*t3120;
    double t2643 = t2249*t3092;
    double t2642 = t2249*t3091;
    double t2641 = t2248*t3087;
    double t2640 = t2248*t3086;
    double t2639 = t1399*t3326;
    double t2638 = t1402*t3326;
    double t2637 = t3705*t3326;
    double t1423 = t2127*t1757;
    double t2636 = t2251*t2188;
    double t2635 = t2251*t2197;
    double t2633 = t1895*t2180;
    double t2632 = t1895*t2182;
    double t2631 = t2232*t2200;
    double t2630 = t1895*t2186;
    double t2629 = t1895*t2189;
    double t1700 = t1895*t2195;
    double t1701 = t1895*t2193;
    double t1533 = t2242*t1693;
    double t2628 = (t1890*t2252+t1757)*t2146+t1533+t1890*t3197;
    double t1112 = t3069+t2088+t2097;
    double t1117 = -t3071+t2974;
    double t2627 = t1112*t2256+t1117*t2257-t1374;
    double t475 = t1112*t2258+t1117*t2259-t1374;
    double t2625 = t1645*t2251+t1888*t3825;
    double t2624 = t1693*t2240+t2127*t3442;
    double t2604 = -t2087+t2975;
    double t2603 = -t2090+t2973;
    double t2600 = t2222+t2126;
    double t595 = t2255*t958+t876;
    double t2589 = t777*t2126;
    double t1128 = -t3067+t1768;
    double t1766 = t2239*t1908;
    double t1133 = t3065+t1766;
    double t348 = -t2244*(t1128*t2257+t1133*t2256-t1375)+t3705*t3408;
    double t2578 = t3732*t3730;
    double t2574 = t2239*t3725;
    double t2571 = t2244*t2139;
    double t2570 = t2244*t2952;
    double t2569 = t2246*t2952;
    double t2560 = t169*t2246+t3289*t771-t3817*t3892;
    double t1055 = t1906*t2154-t1699;
    double t746 = -t1055*t2256+t1908*t2672;
    double t2559 = t1391*t2254+t2026;
    double t2547 = t2163*t2246-t2165*t2244;
    double t2546 = t2167*t2246-t2169*t2244;
    double t2543 = -t2229*t2235-t2141;
    double t2542 = t2210+t3062;
    double t2540 = t767*t2814;
    double t2539 = t768*t2813;
    double t2538 = t763*t2812;
    double t2537 = t774*t2811;
    double t2534 = t763*t2785;
    double t2533 = t764*t2785;
    double t2532 = t774*t2808;
    double t2531 = t3726*t2910;
    double t2530 = t764*t2797;
    double t2529 = t765*t2797;
    double t2528 = t765*t2789;
    double t2527 = t771*t2784;
    double t2526 = t3183*t3602;
    double t2525 = t777*t2808;
    double t2524 = t777*t2796;
    double t2523 = t1906*t3725;
    double t2521 = t1981*t2126;
    double t2519 = t1887*t2806;
    double t2518 = t2127*t1655;
    double t2517 = t2258*t1423;
    double t2516 = t1895*t2676;
    double t2515 = t3730*t2811;
    double t2514 = t3730*t2250*t3295;
    double t2513 = t3730*t2810;
    double t2512 = t3730*t2796;
    double t2511 = t3730*t2791;
    double t2510 = t3730*t2786;
    double t2509 = t3729*t2810;
    double t2508 = t3729*t2786;
    double t2507 = t2127*t2753;
    double t2506 = t2127*t2698;
    double t2505 = t2127*t2660;
    double t2504 = t2239*t2794;
    double t2503 = t3727*t2660;
    double t2502 = t3726*t2660;
    double t2501 = t3725*t2753;
    double t2500 = t2252*t2087;
    double t2499 = t2236*t2653;
    double t2498 = t2236*t2652;
    double t2497 = t2236*t2651;
    double t2496 = t2236*t2650;
    double t2495 = t2236*t2643;
    double t2494 = t2236*t2642;
    double t2493 = t2237*t2649;
    double t2492 = t2237*t2648;
    double t2491 = t2237*t2646;
    double t2490 = t2237*t2645;
    double t2489 = t2237*t2641;
    double t2488 = t2237*t2640;
    double t2487 = t3731*t2844;
    double t2486 = t3731*t2839;
    double t2485 = t3731*t2834;
    double t2483 = t2239*t2691;
    double t2482 = t2239*t2652;
    double t2481 = t2239*t1700;
    double t2479 = t2239*t2688;
    double t2478 = t2240*t2676;
    double t2476 = t2240*t2673;
    double t2475 = t2240*t2648;
    double t2470 = t3731*t2842;
    double t2469 = t3731*t2837;
    double t2468 = t2242*t2848;
    double t2466 = t1892*t1879;
    double t2465 = t1892*t1880;
    double t2464 = t2251*t2093;
    double t2463 = t2240*t1879;
    double t2462 = t2240*t1880;
    double t2461 = t2240*t2670;
    double t2460 = t2240*t2672;
    double t2459 = t2242*t2653;
    double t1531 = t1892*t2678;
    double t1532 = t2251*t2876;
    double t1534 = t2242*t1694;
    double t2458 = t1895*t2672;
    double t2457 = t3727*t2098;
    double t1772 = t2127*t2100;
    double t2455 = t2127*t2099;
    double t2454 = t3727*t2099;
    double t2453 = t2243*t2649;
    double t2452 = t2243*t2636;
    double t2451 = t2243*t2635;
    double t2450 = t2254*t2115;
    double t2449 = t2962*t2847;
    double t2448 = t2959*t2847;
    double t2447 = -t3008-t3694;
    double t2446 = t1599*t3729+t3746;
    double t2445 = t3881*t1598;
    double t2347 = -t1908*t2563-t1422;
    double t742 = -t2230*t1768-(t1908*t3132-t1516)*t2254;
    double t162 = t3408*t771-t2244*(t1243+t742*t2257+(t1242+t2347)*t2256);
    double t2284 = -(t1699+t1875)*t2254-t2097*t2127-t1697;
    double t685 = t2634-t2456+t2254*(t1695-t2807);
    double t225 = t2256*(t1236+t2284)+t2257*t685+t1237;
    double t3 = -(t162*t2246+t225*t2220-t2530+(t2244*t225+t682)*t2244)*t2246-t162*t2222+(t764*t3376+t2244*(t3369*t764-t2923))*t2247;
    double t1244 = t1908*t3364;
    double t1245 = t1908*t3372;
    double t163 = t3408*t772-t2244*(t1245+t742*t2259+(t1244+t2347)*t2258);
    double t1252 = t1908*t3334;
    double t1253 = t1908*t3338;
    double t164 = t3408*t3922-t2244*(t1253+(-t2232*t1768-t2256*(t1908*t3130-t1516))*t2259+(-t1908*t3268+t1252-t2869)*t2258);
    double t1254 = t3733*t3334;
    double t1255 = t3733*t3338;
    double t161 = -t2246*(t1255+(-t2232*t3358-(t3130*t3733-t3434)*t2256)*t2259+(-t3268*t3733+t1254-t2868)*t2258)+t2932;
    double t2438 = t1399*t3816-t1939*t763;
    double t2436 = (t2226+t2233)*t3440;
    double t2435 = t3730*t3395;
    double t2434 = t3729*t3288;
    double t2433 = t2248*t3773;
    double t2432 = t1721*t2257-t1889*t2155;
    double t2430 = -t1723*t2256-t1894*t2142;
    double t1852 = -t2215*t2235+t2240*t3168;
    double t2428 = t1852*t2256-t1888*t3123;
    double t1854 = -t2218*t2235+t2243*t3138;
    double t2427 = t1854*t2257-t1892*t2156;
    double t1382 = -t3071+t2683;
    double t2426 = t2089+t2695;
    double t2425 = t2099+t2708;
    double t470 = (t3069+t2975)*t2258+(-t3071+t2973)*t2259-t3418;
    double t471 = (t3065+t2975)*t2258+(-t3067+t2973)*t2259-t3380;
    double t2423 = -t1046+t2033;
    double t2422 = t1046+t2033;
    double t1381 = t3071+t2683;
    double t2035 = t2252*t2101;
    double t1001 = -t1381*t2254+t2035;
    double t1002 = -t1382*t2254+t2035;
    double t224 = -((t1001*t2257+t1485*t2256)*t2245+t3732*t2841)*t2246+(-t1939*t2842-t2244*(t1002*t2257-t1486*t2256))*t2247;
    double t2415 = t2127*t2034;
    double t2414 = t2251*t2455;
    double t2413 = t2251*t2454;
    double t2412 = t2242*t2452;
    double t2411 = t2242*t2451;
    double t2396 = -t1411*t2222-t3474;
    double t1414 = t2157-t3129+t3230;
    double t2395 = t2126*t1414;
    double t2394 = t2227*t2239+t3197;
    double t2392 = t1398*t2245+t3475;
    double t2391 = t1401*t2244-t1404*t2246;
    double t2388 = -t1888*t2258-t1892*t2259;
    double t1923 = t3131-t3147;
    double t1940 = t3129-t3145;
    double t2378 = t2230*t949-t2467;
    double t2372 = t2249*t3881;
    double t2371 = t2018*t2708+t1625;
    double t2370 = -t2087-t2426;
    double t2369 = -t2090-t2425;
    double t226 = t2258*(t1238+t2284)+t2259*t685+t1239;
    double t1696 = t1895*t2192;
    double t227 = t2258*(t1240-t2632-t2127*t2098-t2256*(t1701+t1875))+t2259*(t2633-t2455+(t1696-t2807)*t2256)+t1241;
    double t229 = t2258*(t1244+t2305)-t2259*t684+t1245;
    double t1698 = t1895*t2194;
    double t230 = t2258*(t1246-t2629-t2457-(t1700+t2795)*t2256)+t2259*(t2630-t2454+t2256*(-t3136*t3727+t1698))+t1247;
    double t231 = t2258*(t1252+t2632-t2463+(t1701-t1875)*t2256)-t2259*(t2633+t2455+t2256*(t1696+t1876))+t1253;
    double t232 = t2258*(t1254+t2629-t2462+t2256*(t1700-t2795))-t2259*(t2630+t2454+t2256*(t3152*t3727+t1698))+t1255;
    double t2360 = -t1124*t2141+t2254*(-t1124*t3179+t2625);
    double t2359 = -t1124*t3194+t2256*(-t1124*t3178+t2625);
    double t2358 = t3741*t3194+(t1644*t2255+t2235*t3697)*t2256;
    double t644 = -t2018*t3731+t1846+t3001;
    double t2354 = -t3408*t644+((t2242*t3761+t1359)*t2259+(t2239*t3761-t2820)*t2258+t1922*t1119+t3001*t1703)*t2244+t3730*t2639;
    double t2353 = t2234*t2416;
    double t2352 = t2240*t2416;
    double t2351 = t2243*t2416;
    double t2349 = t2258*t2416;
    double t2346 = (t1626+t1655)*t2252+t1722*t3076;
    double t2345 = (t1628+t1655)*t2254+t1722*t3075;
    double t2342 = t2143*t2243-t3214;
    double t2341 = t1109*t2258+t1118*t2259-t1375;
    double t646 = t1939*t2226-t2021*t3731-t2992;
    double t2340 = -t3408*t646+((t2242*t3762+t1360)*t2259+(t2239*t3762-t2819)*t2258+t1939*t1119-t2992*t1703)*t2244+t3730*t2638;
    double t2316 = -t1705*t3726-t3514;
    double t2339 = -t3367*t646+((t2242*t2316+t1361)*t2259+(t2239*t2316-t2818)*t2258+t1939*t3514-t2992*t1705)*t2246+t3729*t2637;
    double t2337 = -t2815*t769+t3818*t761;
    double t611 = -t1399*t3732-t1376;
    double t38 = t3730*t611+t252+t3642;
    double t612 = -t1399*t1947-t1376;
    double t39 = t3730*t612+t253+t3645;
    double t613 = -t1402*t1947-t1377;
    double t40 = t3730*t613+t255+t3643;
    double t41 = t257+t3641+t3729*(-t1947*t3705-t1378);
    double t2333 = t2240*(-(t2144-t3176)*t2258+t3192);
    double t2332 = t2390*t1869;
    double t2331 = t2389*t1869;
    double t2330 = t2388*t1869;
    double t2329 = t2388*t1870;
    double t2328 = t2388*t1871;
    double t2319 = t1947*t2017;
    double t1707 = t3732-t2143;
    double t2315 = -t1187*t2251-t1707*t3725;
    double t1928 = t2144+t3178;
    double t1186 = t1928*t2256+t2115+t3194;
    double t1706 = t3732+t2143;
    double t2309 = t1186*t2251+t1706*t3725;
    double t1631 = t1890*t3181;
    double t2296 = -t1890*t2109+t2252*(t1631+t1521);
    double t1633 = t1890*t3179;
    double t2295 = -t1890*t2112+t2254*(t1633+t1521);
    double t1517 = t2251*t1721;
    double t1853 = -t2211*t2242+t2235*t3139;
    double t2294 = t1664*t2253-t2252*(t1853*t2252+t1517);
    double t2293 = t1664*t2255-t2254*(t1853*t2254+t1517);
    double t479 = -t1922*t2839-t2244*(t2257*t2559-t2704*t3733);
    double t1004 = t1382*t2255+t2027;
    double t483 = -t1922*t2837-(-t1004*t2256+t2676*t3733)*t2244;
    double t1003 = t1381*t2255+t2477;
    double t487 = t3733*t2836+(-t1003*t2256+t1922*t2659)*t2245;
    double t488 = -t3733*t2827+(-t1003*t2258+t1922*t2658)*t2245;
    double t489 = -t3732*t2827+(t1939*t2658-(t1381*t2257+t2476)*t2258)*t2245;
    double t1383 = t3067+t2101;
    double t490 = -t3732*t2823+(t1939*t2656-(t1383*t2257+t2461)*t2258)*t2247;
    double t2292 = -t1887*t3726-t2258*t2390;
    double t2291 = -(t1906*t2156+t2866)*t2259+t1908*t2700;
    double t1052 = t1908*t3131+t1699;
    double t750 = -t1052*t2256+t1906*t2657;
    double t751 = -t1052*t2258+t1906*t2656;
    double t752 = -(t1908*t3129+t1701)*t2258+t1906*t2655;
    double t753 = -t2258*(t3129*t3733+t1700)+t1922*t2655;
    double t2290 = -t1057*t2259+t1908*t2701;
    double t2289 = -t1769*t2239+t2253*t3216;
    double t2288 = (-t3069+t2426)*t2258+(t3071+t2425)*t2259-t3346;
    double t2287 = (-t3065+t2426)*t2258+(t3067+t2425)*t2259-t3345;
    double t1525 = t2252*t1642;
    double t2276 = -t1878*t1890-t2230*t2726;
    double t17 = t2220*t2846-(-t2244*t2846+t595*t2232+((-t1722*t2127+t3561)*t2254+t2378)*t2257+(-t1725*t3285+t2256*t595+t3635)*t2256)*t2244+(t1120*t3374+(-(t1890*t3291+t1525)*t2254+t2276)*t2257+(t1120*t3365-t1878*t1887+t3536)*t2256)*t2245;
    double t1 = -t162+(t2909+(t764-t3898)*t1922)*t2247+(t2627*t3730-t225+t3644)*t2246+t3729*t348;
    double t2285 = t2222*t3379-t2251*t2848;
    double t1529 = t2239*t1693;
    double t788 = t2227*t3440+t1533+t1638;
    double t78 = t1121*t3410+t2258*(t1529*t2254+t788*t2255+(t1121*t2258-t3842)*t1906)-t2259*(t2864+t2252*t1534+(t1214+t3535)*t2254);
    double t76 = -t2390*t3410+t2258*(t1529*t2256+t1906*t2292+t2257*t788)-t2259*(t1890*t3412+t2251*t2516+(t1890*t3405+t3535)*t2256);
    double t1639 = t2230*t3440;
    double t77 = -t2390*t3372+t2258*((t2229*t3440+t1534+t1639)*t2257+t2251*t2481+t2292*t1922)-t2259*(t1890*t3374+t2251*t2458+(t1890*t3365+t1639+(t1642+t1656)*t2254)*t2256);
    double t1367 = t2255*t1419;
    double t616 = t1892*t3400+(t1892*t3392+t1419)*t2254;
    double t2283 = -t3741*t3398+(-t1908*t3697+t1367)*t2256-t616*t2257;
    double t2282 = -t3741*t3396+(t1908*t3812+t1367)*t2258-t616*t2259;
    double t2281 = -t2389*t3396+(t1419*t2257+t1908*t2317)*t2258-(t1892*t3398+(t1892*t3390+t1419)*t2256)*t2259;
    double t2280 = -t2389*t3359+(t2317*t3733+t2872*t3727)*t2258-(t1892*t3361+(t1892*t3354+t3439*t3727)*t2256)*t2259;
    double t2274 = -t2781*t760-t3858;
    double t2273 = -t2781*t761-t2929;
    double t2272 = -t2780*t769-t2925;
    double t2271 = -t2246*(t3287*t374-t3299*t767)+t2814*t764-t3294*t374;
    double t443 = t2757-t2255*t2351-(-t1711+t2352)*t2254;
    double t2270 = t3733*t2505+t2234*t443-t2258*(-t2258*t443-t2806*t3733);
    double t445 = t2756-t2257*t2351-(-t1712+t2352)*t2256;
    double t2269 = t3732*t2505+t2234*t445-t2258*(-t2258*t445-t2806*t3732);
    double t448 = t2755-t1184*t3123-(t1184*t2240-t1713)*t2256;
    double t2268 = t3732*t2503+t2234*t448-t2258*(-t2258*t448-t2794*t3732);
    double t2266 = -t2257*t3216+(t1939*t2243-t2096)*t2239;
    double t2264 = t1940*t3143+t2215*t3130-t2257*t3215;
    double t638 = -t2017*t3731+t1844+t3012;
    double t2263 = t2237*((t765-t3753)*t2225+t2226*t765+t3730*t638);
    double t2262 = t2258*t2431+t2259*t2429;
    double t2261 = t2258*t3035+t2259*t3034;
    double t2216 = std::pow(t2241, 2);
    double t2214 = std::pow(t2238, 2);
    double t2212 = std::pow(t2236, 2);
    double t2174 = t2258+t2256;
    double t2138 = t2245+t2251;
    double t2134 = t2247+t2249;
    double t2133 = t2246+t2244;
    double t2132 = t2245+t2249;
    double t2131 = t2245+t2247;
    double t2117 = t2241*t2198;
    double t2116 = t2241*t2197;
    double t2104 = t2238*t2195;
    double t2067 = t2158*t2257;
    double t2061 = t2178*t2248;
    double t2054 = t2175*t2248;
    double t2050 = t2169*t2247;
    double t2047 = t2165*t2247;
    double t2037 = t2242*t2657;
    double t2036 = t2242*t2659;
    double t2030 = t2239*t2114;
    double t2029 = t2239*t2113;
    double t2023 = t2235*t2679;
    double t2022 = t2251*t2091;
    double t2016 = t2177*t3129;
    double t2015 = t2176*t3129;
    double t2014 = t2161*t3129;
    double t2013 = t2176*t3131;
    double t2012 = t2167*t3131;
    double t2011 = t2176*t3104;
    double t2010 = t2171*t3104;
    double t2009 = t2164*t3121;
    double t2008 = t2162*t3121;
    double t2007 = t2158*t3121;
    double t2006 = t2158*t3123;
    double t2005 = t2158*t3129;
    double t2004 = t2164*t3137;
    double t2003 = t2162*t3137;
    double t2002 = t2158*t3137;
    double t2001 = t2158*t2142;
    double t2000 = t2168*t3140;
    double t1999 = t2166*t3140;
    double t1998 = t2160*t3140;
    double t1997 = t2160*t2156;
    double t1996 = t2173*t3145;
    double t1995 = t2171*t3145;
    double t1994 = t2175*t3147;
    double t1993 = t2171*t3147;
    double t1992 = t2163*t3147;
    double t1991 = t2175*t2146;
    double t1990 = t2173*t2146;
    double t1989 = t2165*t2146;
    double t1988 = t2160*t3145;
    double t1987 = t2168*t3155;
    double t1986 = t2166*t3155;
    double t1985 = t2160*t3155;
    double t1984 = t2160*t2155;
    double t1983 = t2161*t3120;
    double t1982 = t2159*t3120;
    double t1980 = t2209-t3062;
    double t1979 = t2208-t3062;
    double t1978 = -t2201+t2210;
    double t1977 = -t2200+t2210;
    double t1975 = -t2201+t2208;
    double t1974 = -t2200+t2209;
    double t1972 = -t2198+t2210;
    double t1971 = -t2197+t2210;
    double t1970 = -t2195+t2209;
    double t1969 = -t2193+t2208;
    double t1968 = -t2188+t2209;
    double t1967 = -t2185+t2208;
    double t1966 = -t2195+t3062;
    double t1965 = -t2193+t3062;
    double t1964 = -t2198+t2201;
    double t1963 = -t2197+t2200;
    double t1962 = -t2185+t2201;
    double t1961 = -t2188+t2200;
    double t1958 = -t2195+t2197;
    double t1957 = -t2193+t2198;
    double t1954 = -t2188+t2198;
    double t1953 = -t2185+t2197;
    double t1952 = -t2185+t2195;
    double t1951 = -t2188+t2193;
    double t1948 = t3121-t3140;
    double t1946 = t2157-t3144;
    double t1943 = -t2143+t3140;
    double t1942 = -t2156+t3123;
    double t1937 = -t2152+t3123;
    double t1936 = t2142-t2151;
    double t1935 = -t2147+t3123;
    double t1934 = t2142-t2145;
    double t1933 = -t2154+t2156;
    double t1931 = -t2150+t2156;
    double t1927 = -t2143+t2156;
    double t1926 = t2143+t2156;
    double t1925 = -t2152+t2154;
    double t1920 = -t2147+t2154;
    double t1919 = -t2146+t3131;
    double t1918 = -t2145+t2153;
    double t1917 = -t2143+t2154;
    double t1916 = -t2150+t2152;
    double t1915 = -t2149+t3147;
    double t1911 = -t2143+t2152;
    double t1904 = -t2143+t2150;
    double t1903 = t2143+t2150;
    double t1900 = -t2143+t2147;
    double t1868 = t1959*t2234;
    double t1867 = t1959*t2258;
    double t1866 = t1955*t2234;
    double t1865 = t1955*t2258;
    double t1864 = t1949*t2234;
    double t1863 = t1949*t2258;
    double t1862 = t1949*t2232;
    double t1861 = t1949*t2256;
    double t1859 = t2241*t2962;
    double t1858 = t2215*t2242-t2239*t3143;
    double t1857 = -t2239*t3135+t3216;
    double t1856 = t2240*t3135-t3215;
    double t1851 = -t2211*t2239+t2235*t3174;
    double t1834 = t1938*t2259;
    double t1811 = t1921*t2259;
    double t1780 = t1905*t2259;
    double t1771 = t2251*t1875;
    double t1770 = t2159*t2238+t2153;
    double t1728 = -t2087-t2697;
    double t1727 = t2146*t2243+t2090;
    double t1709 = -t2145+t2965;
    double t1708 = t2145+t2966;
    double t1692 = t2073+t2082;
    double t1691 = -t2174*t2255+t2072;
    double t1690 = t2071+t2081;
    double t1689 = -t2174*t2253+t2070;
    double t1688 = t2069+t2080;
    double t1687 = t3250+t3256;
    double t1686 = -t2172*t2253+t2068;
    double t1685 = -t2162*t2255+t2067;
    double t1684 = -t2164*t2253+t2067;
    double t1683 = t1858*t2254;
    double t1682 = t1858*t2252;
    double t1681 = t1857*t2255;
    double t1680 = t1857*t2253;
    double t1678 = t1853*t2230;
    double t1677 = t1853*t2228;
    double t1675 = t1851*t2230;
    double t1674 = t1851*t2228;
    double t1673 = t1850*t2256;
    double t1671 = t2243*t1757;
    double t1670 = t1895*t2154;
    double t1669 = t1895*t2150;
    double t1654 = t2239*t3067;
    double t1653 = t1895*t2146;
    double t1640 = t1891*t3170;
    double t1636 = t1890*t2143;
    double t1635 = t1887*t2143;
    double t1634 = t1890*t2141;
    double t1632 = t1890*t2140;
    double t1579 = t2114-t3835;
    double t1578 = t2113-t3290;
    double t1576 = t2674-t3291;
    double t1566 = t1981*t2088;
    double t1565 = t1981*t2710;
    double t1564 = t1976*t2710;
    double t1562 = t2112+t2543;
    double t1561 = t2109-t3825;
    double t1546 = t2195+t2210-t3242;
    double t1545 = t2193+t2210-t3245;
    double t1544 = -t2198-t2209+t3242;
    double t1543 = t2185+t2209-t3254;
    double t1542 = -t2197-t2208+t3245;
    double t1541 = -t2188-t2208+t3254;
    double t1540 = t2185+t2198-t3255;
    double t1539 = -t2188-t2197+t3255;
    double t1538 = t2962-t3250;
    double t1537 = -t2962-t3256;
    double t1536 = t2243*t1694;
    double t1519 = t2251*t1723;
    double t1518 = t2251*t1722;
    double t1490 = t2030-t2460;
    double t1489 = t2032-t2461;
    double t1488 = t2029-t2478;
    double t1487 = t2031-t2476;
    double t1470 = t1609*t2245;
    double t1450 = t2206+t2258*(-t3726+t3063);
    double t1449 = t2204+t2258*(-t3727+t3066);
    double t1448 = t2202+t2258*(-t2127+t3070);
    double t1446 = t2186+t2256*(t2194+t3727);
    double t1444 = t2180+t2256*(t2192+t2127);
    double t1441 = t2233*t2257+t2207-t3265;
    double t1440 = t2233*t2255+t2205-t3272;
    double t1439 = t2233*t2253+t2203-t3283;
    double t1431 = t2954-t1959;
    double t1430 = t2542-t1959;
    double t1429 = t2955-t1955;
    double t1428 = t2542-t1955;
    double t1427 = t2955-t1949;
    double t1426 = t2954-t1949;
    double t1425 = t1955-t1949;
    double t1424 = t1959-t1949;
    double t1418 = t2240*t1561;
    double t1417 = t2240*(t2109+t3825);
    double t1416 = t2239*t1561;
    double t1384 = -t3067+t2101;
    double t1363 = t1908*t1892;
    double t1362 = t1888*t1908;
    double t1315 = t1413*t2248;
    double t1312 = t1413*t2249;
    double t1275 = t2077+t2979;
    double t1274 = t2076+t2980;
    double t1273 = t2074+t2981;
    double t1272 = t2120-(t2165*t2238+t2142)*t2258;
    double t1271 = -t1770*t2258+t2118;
    double t1270 = t2118-(t2163*t2238+t2142)*t2258;
    double t1269 = -t1770*t2256+t2116;
    double t1268 = -t2178*t2246+t3224-t3240;
    double t1267 = -t2178*t2244+t3226-t3243;
    double t1266 = -t2175*t2246+t3231-t3246;
    double t1265 = -t2175*t2244+t3235-t3248;
    double t1264 = -t2177*t2244+t3227-t3251;
    double t1263 = t2546-t3253;
    double t1262 = -t2173*t2244+t3236-t3257;
    double t1261 = t2547-t3259;
    double t1260 = t2982+t3258;
    double t1235 = -t2100*t2252-t2227*t3188-t2092;
    double t1220 = t2127*t1521;
    double t1219 = t1906*t1756;
    double t1218 = t1887*t3407;
    double t1213 = t1407*t3104;
    double t1212 = t2236*t1358;
    double t1211 = t1398*t3172;
    double t1209 = t3705*t3186;
    double t1204 = t2147*t3727-t1881;
    double t1199 = (t2142+t1932)*t2259-t2108;
    double t1198 = (t2142+t1930)*t2259-t2107;
    double t1197 = (t2142-t1921)*t2259+t2106;
    double t1196 = (t2142-t1905)*t2259+t2106;
    double t1195 = t1710*t2259-t2107;
    double t1194 = t1710*t2257-t2193*t2238;
    double t1193 = t1709*t2259+t2108;
    double t1192 = t1709*t2257+t2104;
    double t1191 = -t2258*t2601+t2122;
    double t1190 = -t2258*t2602+t2122;
    double t1189 = -t1708*t2258+t2120;
    double t1188 = -t1708*t2256+t2117;
    double t1173 = t2958*t2881;
    double t1172 = t2959*t2881;
    double t1171 = t2234*t1233;
    double t1169 = t3381-t3420;
    double t1168 = -t3382+t3419;
    double t1167 = t1834-t3381;
    double t1166 = t1834-t3419;
    double t1165 = t1832-t1806;
    double t1164 = t1832-t1775;
    double t1163 = t1811-t3347;
    double t1162 = t1811-t3420;
    double t1161 = t1809-t3348;
    double t1160 = t1809-t3421;
    double t1159 = t1806-t3421;
    double t1158 = t1780-t3349;
    double t1157 = t1780-t3382;
    double t1156 = t1778-t3350;
    double t1155 = t1778-t3383;
    double t1154 = t1775-t3383;
    double t1153 = -t3357+t3367;
    double t1150 = t2969-t3347;
    double t1149 = t2969-t3349;
    double t1148 = t2970-t3348;
    double t1147 = t2970-t3350;
    double t1146 = t2967-t3381;
    double t1145 = t2967-t3382;
    double t1144 = t2971-t3383;
    double t1143 = -t1806+t2971;
    double t1142 = t2968-t3419;
    double t1141 = t2968-t3420;
    double t1140 = -t1775+t2972;
    double t1139 = t2972-t3421;
    double t1138 = t2153*t2257+t2104-t3382;
    double t1137 = t2194*t2238+t2117-t3383;
    double t1136 = -t3420+t3349;
    double t1135 = t2192*t2238+t2116-t3421;
    double t1131 = t1900*t2239+t3069;
    double t1127 = -t3069+t3426;
    double t1116 = -t1382+t2090;
    double t1115 = -t2683-t1389;
    double t1107 = -t2169*t3072+t2177*t3080-t2178*t3086;
    double t1106 = -t2167*t3072+t2176*t3080-t2178*t3102;
    double t1105 = -t2161*t3072+t2176*t3086-t2177*t3102;
    double t1104 = t2169*t3078-t2177*t3083+t2178*t3091;
    double t1103 = t2167*t3078-t2176*t3083+t2178*t3115;
    double t1102 = t2161*t3078-t2176*t3091+t2177*t3115;
    double t1101 = t2165*t3079-t2173*t3084+t2175*t3092;
    double t1100 = t2163*t3079-t2171*t3084+t2175*t3116;
    double t1099 = t2159*t3079-t2171*t3092+t2173*t3116;
    double t1098 = t2161*t3080-t2167*t3086+t2169*t3102;
    double t1097 = t2161*t3083-t2167*t3091+t2169*t3115;
    double t1096 = t2159*t3084-t2163*t3092+t2165*t3116;
    double t1089 = t2226*t1124;
    double t1088 = t2226*t1120;
    double t1045 = (-t2165*t3073+t2173*t3081-t2175*t3087)*t2239;
    double t1044 = (-t2163*t3073+t2171*t3081-t2175*t3103)*t2239;
    double t1043 = (-t2159*t3073+t2171*t3087-t2173*t3103)*t2239;
    double t1042 = t2239*t3738+t2025;
    double t1040 = (-t2159*t3081+t2163*t3087-t2165*t3103)*t2239;
    double t1034 = t1680-t1640;
    double t1033 = t1856*t2252+t1664;
    double t1030 = t2240*t3069+t1648;
    double t1029 = t1653+t1640;
    double t1028 = -t1645-t2885;
    double t1027 = t2874-t2878;
    double t1024 = t1124*t2143;
    double t1020 = t1094*t2256;
    double t1019 = t1093*t2256;
    double t1018 = t1093*t2254;
    double t1012 = t1414*t3367;
    double t1011 = t1414*t3408;
    double t1010 = t1411*t3408;
    double t990 = t2254*(t2093+t2100)+t2983;
    double t979 = t1682-t1517;
    double t961 = t1669+t1519;
    double t945 = t1047*t2256;
    double t944 = t1046*t2256;
    double t943 = t1046*t2254;
    double t940 = t3741*t2127;
    double t939 = t3727*t1124;
    double t925 = t1404*t2259+t2238*t2958;
    double t924 = t1404*t2258-t2241*t2958;
    double t923 = t1401*t2259+t2238*t2959;
    double t922 = t1401*t2258-t2241*t2959;
    double t921 = t1398*t2259+t3323;
    double t920 = t1398*t2258-t1859;
    double t919 = t1398*t2257+t3323;
    double t918 = t1398*t2256-t1859;
    double t917 = t1936*t2259+t1987-t3381;
    double t916 = t1934*t2259+t1986-t3419;
    double t915 = -t1932*t2259+t1987-t3347;
    double t914 = -t1930*t2259+t1986-t3349;
    double t913 = t1918*t2259+t1985-t3420;
    double t912 = t1918*t2257+t1984-t3420;
    double t911 = t2259*t2966+t1985-t3382;
    double t910 = t2257*t2966+t1984-t3382;
    double t909 = -t1936*t2258+t2004-t3348;
    double t908 = t1932*t2258-t1806+t2004;
    double t907 = -t1934*t2258+t2003-t3350;
    double t906 = t1930*t2258-t1775+t2003;
    double t905 = -t1918*t2258+t2002-t3383;
    double t904 = -t2258*t2966+t2002-t3421;
    double t903 = -t1918*t2256+t2001-t3383;
    double t902 = -t2256*t2966+t2001-t3421;
    double t886 = t2251*t3024;
    double t879 = t3744*t2256;
    double t878 = t969*t2256;
    double t830 = t1362-t2873;
    double t829 = t1646+t1363;
    double t828 = t1452*t2239+t1693;
    double t827 = t1693-t3772;
    double t820 = t3733*t1124;
    double t818 = t1887*t1900+t1504;
    double t815 = t1438*t2258+t1447*t2259;
    double t814 = t1436*t2258+t1445*t2259;
    double t813 = t1443*t2259-t2258*t2605;
    double t812 = t1443*t2257-t2256*t2605;
    double t804 = t1680-t2239*(t3071+t1756);
    double t803 = t1854*t2255-t1892*t2152-t2874;
    double t802 = t1852*t2254-t1888*t2154+t1645;
    double t801 = t1653+(-t1887*t2251+t3069)*t2242;
    double t796 = t1868-t3727*t2210+(t1867-t3273)*t2258;
    double t795 = t1868-t3726*t2209+(-t2255*t3726+t1867)*t2258;
    double t794 = t1866-t2127*t2210+t2258*(t1865-t3284);
    double t793 = t1866-t3838+(-t2253*t3726+t1865)*t2258;
    double t792 = t1864-t2127*t2209+(t1863-t3285)*t2258;
    double t791 = t1864-t3836+t2258*(t1863-t3274);
    double t790 = t1862-t2127*t2198+(t1861-t3285)*t2256;
    double t789 = t1862-t3727*t2197+(t1861-t3274)*t2256;
    double t787 = t1856*t2253+t1520+t1682;
    double t786 = t1635+t967;
    double t784 = t1635-t966;
    double t783 = t1895*t2147+t1518+t1669;
    double t781 = -t1636+t958;
    double t779 = t1636+t954;
    double t778 = t1636+t949;
    double t759 = t1855*t2228+t3532;
    double t758 = t2228*t3438-(-t2252*t3438+t1671)*t2252;
    double t757 = t1892*t2140-t3532;
    double t755 = -t2700*t3733+t3526;
    double t749 = t3733*t2669-(t1922*t3123-t1700)*t2258;
    double t748 = t1908*t2669-(t1906*t3123-t1701)*t2258;
    double t747 = -t1055*t2258+t1908*t2671;
    double t740 = t1535+t1364;
    double t731 = -t1124-t3741;
    double t730 = -t1121-t2390;
    double t729 = -t1120-t2390;
    double t728 = -t1120+t1121;
    double t701 = t777*t3727;
    double t700 = t777*t2127;
    double t697 = t774*t2127;
    double t677 = t1724*t3075+t1849*t1887+t1675;
    double t676 = t1724*t3076+t1847*t1887+t1674;
    double t669 = t2248*t2905;
    double t665 = t2248*t2906;
    double t664 = t762*t2792;
    double t656 = t2251*t676;
    double t654 = t3024-t976;
    double t653 = -t966+t3744;
    double t652 = t969-t3038;
    double t651 = t975+t963;
    double t650 = t954-t960;
    double t649 = t950+t959;
    double t648 = t958-t956;
    double t647 = -t952-t957;
    double t631 = -t2228*t3448+t1533+(-t1887*t3133+t1656)*t2252;
    double t630 = t1678-t2295;
    double t629 = t1677-t2296;
    double t628 = t1677-t2294;
    double t627 = t1674-t2346;
    double t626 = t1634+t1531+(t1633+t1520)*t2254;
    double t625 = t1632+t2296;
    double t624 = t1632+t1892*t2679+t2252*(t1631+t1520);
    double t623 = t1632+t2294;
    double t621 = t1629+t2345;
    double t619 = t1627+t2346;
    double t610 = t1406*t3731-t1378;
    double t609 = t1403*t3731-t1377;
    double t608 = t1400*t3731-t1376;
    double t606 = -t1725*t2228+t1535+(t1660-t3456)*t2252;
    double t605 = t2251*t629;
    double t604 = t2251*t624;
    double t603 = t2251*t619;
    double t602 = -t3481+t768;
    double t598 = t2257*t960-t879;
    double t597 = t2257*t959-t3558;
    double t596 = t2257*t958+t878;
    double t594 = t2257*t957-t3559;
    double t506 = (-t3433+t3358)*t2259+(t2239*t3733+t3432)*t2258-t3345;
    double t505 = (-t3433+t1768)*t2259+(t3432+t1766)*t2258-t3346;
    double t504 = t1128*t2259+t1133*t2258-t1375;
    double t486 = t1939*t2824-t2246*(t3732*t2671-(t1384*t2257+t2030)*t2258);
    double t485 = t1939*t2828-(t3732*t2675-(t1382*t2257+t2029)*t2258)*t2244;
    double t484 = t1922*t2828-t2244*(-t1004*t2258+t2675*t3733);
    double t482 = t1939*t2826-t2246*((t2256*t3016+t2460)*t2259-t3732*t2701);
    double t481 = t1939*t2830-t2244*((t1391*t2256+t2478)*t2259-t3732*t2703);
    double t480 = t1922*t2830-(t2259*t2559-t2703*t3733)*t2244;
    double t469 = t2991+t3834-t3780;
    double t468 = -t2323+t2991+t3841;
    double t467 = -t2325-t2992+t3343;
    double t466 = -t2326-t2992+t3344;
    double t464 = -t2324+t2997+t3363;
    double t462 = -t2327+t3001+t3378;
    double t438 = -t769+t3748;
    double t433 = -t761+t3749;
    double t424 = -t760+t3750;
    double t403 = -t1892*t3265+t2258*t2317-t1087;
    double t402 = -t1892*t3272+t2258*t3812-t1085;
    double t401 = -t1892*t3273-t2256*t3697-t1083;
    double t400 = t1081-t1892*t3283+(t1124*t2258-t3446)*t2258;
    double t399 = t1079-t1892*t3284+(t1124*t2256-t3446)*t2256;
    double t375 = t2244*t774+t2245*t772;
    double t368 = -t3893+t3748;
    double t367 = -t3722+t3749;
    double t366 = -t3677+t3750;
    double t326 = t1411*t3729-t548;
    double t325 = t2447+t3824;
    double t324 = t2447+t3823;
    double t323 = -t533+t3753;
    double t322 = -t532+t3753;
    double t318 = t3337*t763+t2923;
    double t298 = t2221*t529+t3546;
    double t276 = t1121*t3194+t952*t3074-t2256*(-t1121*t3178+t2251*t963);
    double t275 = t1120*t3194+t950*t3074-(-t1120*t3178-t886)*t2256;
    double t274 = t1120*t2141+t950*t3075-(-t1120*t3179-t886)*t2254;
    double t273 = (t1634+t2293)*t2257+t3549;
    double t272 = t2257*t623+t3560;
    double t271 = t2255*t623+t3562;
    double t258 = -t1259-t773*t2157+(-t2239*t773-t1258)*t2258;
    double t256 = -t1257-t767*t2157+(-t2239*t767-t1256)*t2258;
    double t254 = -t1251-t766*t2157+(-t1250-t3584)*t2258;
    double t235 = (t1855*t2230+t3531)*t2257-t2358;
    double t234 = t2257*t759-t2359;
    double t233 = t2255*t759-t2360;
    double t221 = t2590*t3725+t2791*t777;
    double t220 = t2803*t777+t3791;
    double t219 = t2803*t774+t3792;
    double t213 = t765*t3341+t2244*(-t3293*t3922+t3337*t765);
    double t212 = t765*t3376+t2244*(-t3293*t772+t3369*t765);
    double t211 = t772*t3340+t2246*(t1939*t2246*t772-t3281*t3922);
    double t210 = t2244*t318+t2930;
    double t166 = t2244*t251+t682;
    double t143 = t2247*t368+t2251*t2277;
    double t142 = t2245*t367+t2251*t2278;
    double t141 = t2245*t366+t2251*t2279;
    double t140 = t2222*t694+t3922*t2791+t2246*(t2246*t694+t3275*t777);
    double t139 = t764*t3264+t3922*t2803+(t3261*t764+t3286*t777)*t2244;
    double t138 = t763*t3264+t772*t2803+(t3261*t763+t3286*t774)*t2244;
    double t135 = -t2245*t3674+t2247*t321;
    double t121 = -t1173-t397*t2157-(t2239*t397+t2879*t2958)*t2258;
    double t120 = -t1172-t396*t2157-(t2239*t396+t2879*t2959)*t2258;
    double t119 = -t1171+t2437*t2157-(t1233*t2258-t384)*t2258;
    double t114 = t1187*t3372+(t3528-t2413+t2256*(-t2698*t3727+t945))*t2259+(t1187*t3364+t3523-t2251*t2457-(-t1020+t2504)*t2256)*t2258;
    double t113 = t1185*t3410+(t3530-t2415+(t943-t2506)*t2254)*t2259+(t1185*t3404+t3525-t2255*t1772-(-t1018+t1771)*t2254)*t2258;
    double t112 = t1939*t2353+(-t3529-t2414-(t944+t1772)*t2256)*t2259+(t1939*t2349-t3524-t2251*t2463+t2256*(-t1019-t1771))*t2258;
    double t111 = t1184*t3338+(-t3528-t2413-(t2100*t3727+t945)*t2256)*t2259+(t1184*t3334-t3523-t2251*t2462+(-t1020-t2504)*t2256)*t2258;
    double t110 = t1922*t2353+(-t3530-t2415-(t943+t1772)*t2254)*t2259+(t1922*t2349-t3525-t2127*t2025+(-t1018-t1771)*t2254)*t2258;
    double t109 = t1187*t3410+(t3529-t2414+(t944-t2506)*t2256)*t2259+(t1187*t3404+t3524-t2257*t1772-t2256*(-t1019+t1771))*t2258;
    double t95 = t3729*t3891-t296;
    double t94 = -t3729*t3890-t295;
    double t93 = -t3730*t3887-t294;
    double t92 = -t3730*t3888-t290;
    double t91 = -t3730*t3884-t293;
    double t90 = -t3730*t3885-t289;
    double t75 = t296*t3729+t3270*t774;
    double t74 = t294*t3730+t3270*t768;
    double t73 = t290*t3730+t3282*t768;
    double t50 = t3729*t3618+(-t3277*t3435+t2932)*t2251-t3922*t3515;
    double t49 = t764*t3329-t2244*(t1423*t2210-t2257*t2517-t3328*t764)+t3977*t3922;
    double t48 = t763*t3329-t2244*(t1423*t2209-t2255*t2517-t3328*t763)+t3977*t772;
    double t47 = -t2527+t3649;
    double t46 = -t2533+t3650;
    double t45 = -t2534+t3651;
    double t44 = -t2535+t3652;
    double t43 = t166*t2244-t2530+t3557;
    double t32 = t597*t2234+(-t955*t2232+(t2230*t3438-t2254*(-t2254*t3438+t1671))*t2257-(t955*t2256+t1721*t2230+t2254*(t3068+t1660))*t2256)*t2259+(t597*t2258+t974*t2232+(t1536+t3458)*t2257+(t1694*t2240+t3779+t3908)*t2256)*t2258;
    double t31 = t594*t2234+(-t953*t2232+t758*t2257-(t2256*t953+t3537)*t2256)*t2259+(t594*t2258-t971*t2232+t740*t2257+(t2624-t3906)*t2256)*t2258;
    double t30 = t593*t2234+(-t859+t758*t2255-(t856+t3537)*t2254)*t2259+(t593*t2258-t882+t740*t2255+t2254*(t2624-t880))*t2258;
    double t28 = t3729*(t2410-t3755)-t129;
    double t27 = t3729*t3958+t2942;
    double t20 = t129*t3729-t3298*t766;
    double t14 = t258*t2222+(-t1186*t3372+(t990*t2232+(t1757*t3727+t2256*t990)*t2256)*t2259-(-t1042*t3726+t1186*t3364+t1895*t2790)*t2258)*t2247+t2246*(t258*t2246+t447*t2234-t3733*t2502+(t2258*t447-t2787*t3733)*t2258);
    double t13 = t256*t2220+(-t1186*t3410+(t989*t2232+(t2256*t989+t1423)*t2256)*t2259-(-t1041*t3726+t1186*t3404+t1423*t2257)*t2258)*t2245+t2244*(t256*t2244+t446*t2234-t1908*t2502+(-t1908*t2787+t2258*t446)*t2258);
    double t12 = t254*t2220+(-t1184*t3410+(t989*t2230+(t2254*t989+t1423)*t2254)*t2259-(-t1041*t3727+t1184*t3404+t1423*t2255)*t2258)*t2245+t2244*(t254*t2244+t444*t2234-t1908*t2503+(-t1908*t2794+t2258*t444)*t2258);
    double t6 = t2222*t2835+(t1121*t3338+(-t2232*t1642-t1890*t1880-(t2256*t1642+t1534+(t1890*t2230+(t1890*t2254+t1757)*t2254)*t2239)*t2256)*t2259+(t1121*t3334+t2232*t2880+(-t2230*t3448+t1534+(-t1760*t2242+t1656)*t2254)*t2257+t2256*(-t1887*t2563+t2256*t2880))*t2258)*t2247-t2246*(-t2246*t2835+t598*t2234+(t3743*t2232-t2465-(-t3743*t2256+t1722*t2230+t1536+(t1524+t1660)*t2254)*t2256)*t2259+(t598*t2258+t968*t2232+(-t1725*t2230+t1536+(-t1510+t1660)*t2254)*t2257+(t875-t2886)*t2256)*t2258);
    double t5 = t2220*t2840+(t1120*t3338+(-t2232*t2726-t1890*t1879-(t2256*t2726+t2628)*t2256)*t2259+(t1120*t3334+t2232*t1641+t631*t2257+(t1641*t2256-t2891)*t2256)*t2258)*t2245-t2244*(-t2244*t2840+t596*t2234+(t949*t2232-t2466-(-t2256*t949+t2902)*t2256)*t2259+(t596*t2258+t967*t2232+t606*t2257+(t887-t2888)*t2256)*t2258);
    double t4 = t2220*t2845+(t1120*t3372+(-(t1525+t2628)*t2254+t2276)*t2259+(t1120*t3364+t2255*t631+t3536)*t2258)*t2245-t2244*(-t2244*t2845+t595*t2234+(-(t2902-t3561)*t2254+t2378)*t2259+(t2255*t606+t2258*t595+t3635)*t2258);

    // Here is the coefficients

    coeffs[0] = (t771*t2509+t2953*(t2224*t2904+t2248*(t2248*t2904-t3296*t772)))*t2213-((t2224*t3609-t772*t2811+t2248*(t2248*t3609-t2924))*t2225+t773*t2509+t2251*(t140*t2224-t772*t2508+t2248*(t140*t2248-t2251*t2924)))*t3175+((t2589*t3276-t2537)*t2225+t2251*(t2126*t221-t2508*t774))*t2212;
    coeffs[1] = (-t3937*t3199+(t2126*t2939+t3295*t771)*t2250-t3670*t2248)*t2213+((t3937*t2249+t176*t2248-t3609+t2126*(-t2246*t560-t3909))*t2225+(t2126*t2594-t3295*t773)*t2250+t3670*t2249+t75*t2248-t2251*t140+t2126*(-t2246*t292-t2251*t2939-t3552))*t3175-((t3619+(-t2126*t560-t701)*t2247)*t2225+t75*t2249-t2251*t221+t2126*(t2251*t2594-t3551))*t2212+((t2126*t558+t3727*t3922)*t2225+t3922*t3282+t2126*t291)*t3220;
    coeffs[2] = (t326*t3199+(t2126*t3785+t2939)*t2250+t94*t2248)*t2213-((t3909-t2248*t3956+t2249*t326+t2126*(-t1414*t2247-t1415*t2246))*t2225+(t2126*t3949-t2594)*t2250+t94*t2249+t95*t2248+t3552+t2126*(t2246*t469+t2247*t467+t2251*t3785))*t3175+((-t3975+(t560-t3751)*t2247)*t2225+t95*t2249+t3551+t2126*(t2247*t469+t2251*t3949))*t2212+(-t2212*t2594-t2939*t3175)*t2251+(((-t2395+t558)*t2225+t291+t2126*t467)*t2213+t3788*t3175)*t2246;
    coeffs[3] = ((-t2224*t2905-t2248*(t669-t2925))*t2250+t769*t2246*t2433)*t2213+((t769*t3964*t3263+(-t2249*t2925+t3636)*t2250+t2251*(t2248*(t669+t2272)+(-t2779*t769+t3271*t770)*t2246))*t2236+(-t161*t2224+t211*t2249-t2248*(t161*t2248+t230*t2222-t2526+t2246*(t2246*t230+t3262*t773)))*t2225+(t47*t2224-t771*t3729*t2783+t2248*(-t3281*t3729*t777+t2248*t47))*t2250-t2251*(t50*t2224-t211*t3082+(t50*t2248+t114*t2222-t2251*t2526+(t114*t2246+t2782*t773)*t2246)*t2248))*t2237-t2236*((-t3725*t769*t2761+t2251*(t2249*t2272+t3636))*t2236+(-t2442*t2224+(t232*t2222+t2527+(t2246*t232-t2914)*t2246)*t2249-t2248*(t3729*t3732*t774+t2248*t2442-t2524))*t2225+(-t2235*t2537+t2126*(t2524+t3899))*t2250+t2251*(t14*t2224+(t111*t2222+t2251*t2527+t2246*(t111*t2246-t2788*t774))*t2249+(t14*t2248+t2251*t2524+t2268*t3729)*t2248));
    coeffs[4] = ((-t1611*t2249-t1612*t2248+t3041)*t2225+(t1605*t2600+t2934)*t2250+(-t1611*t3729-t3878)*t2249-t3869*t2248+t3880*t2247+t3874*t2246+t2126*(t2251*t3705+t3041))*t3175+((t1612*t2249-t3843)*t2225+t3869*t2249-t3874*t2247+t2126*(-t1605*t2251-t3843))*t2212+((t2567-t3918)*t3175+(-t1605*t2222-t2934)*t2212)*t2251+(-t2246*t3880+(-(t2221+t2600)*t3705+t3918)*t2250+(-t3846+t3878)*t2248+(-t3712-t3200)*t1613)*t2213;
    coeffs[5] = (-t3939*t3085+(-t3924*t2250+(-t2225*t438+t205)*t2248)*t2246)*t2213+((t205*t3964+t2250*t3971-t3427*t438)*t2236+((t3729*t471-t230)*t2248-t161+t2126*(-t2246*t506+t1012))*t2225+(t2126*t41+t3649)*t2250+(t1922*t2315+t3646)*t3667+t2126*(-t3326*t771+t2339))*t2237+t2236*((t205*t3089-t2761*t438)*t2236+((t2287*t3729-t232+t3641)*t2249+(t774-t3900)*t3331+t2442+t2126*(t1415*t3357+t3895))*t2225+(-t3899+t2126*(-t3183*t560+t3767))*t2250+t3729*t2249*((t2371+t3928)*t2259+t3952-t3661*t1939)+(-t1947*t3834-t2251*t448+t3855)*t3667+t2126*(((-t2251*t990-t3807)*t2259+(-t1042*t2251-t3806)*t2258+t2309*t1922)*t2247+(t2318*t3733-t3810)*t2246-t2251*t258-t3710*t610))+(((-t558*t3094+(-t2246*t2407+t2247*t548)*t2248)*t2225+(-t2939*t2249-(t3729*t560+t701)*t2248-t2247*t694)*t2250-t291*t3094+(t295*t2247-(t2226*t773+t3725*(t2226*t3733+t2998-t3834))*t2246)*t2248)*t2237+t2236*((-t3276*t777+t3619)*t2250+(-(t2226*t771+t3725*t3889)*t2247+t296*t2246)*t2249+t3788*t3090))*t2235+((t2396+t772)*t2225+t2226*t772+t3729*t644)*t1939*t3163+(((t2248*t3939+t3712*t543+t2905)*t2236-t114*t2248-t50)*t2237+t2236*(-t111*t2249-t2236*t3971-t2248*t2268-t14))*t2251;
    coeffs[6] = (t1266*t2239+t1268*t2242)*t2213-(t1268*t2243+(-t2060-t3735)*t2242+t1266*t2240-t2239*t1275)*t3175-((t2079+t2976)*t2243+t1275*t2240)*t2212;
    coeffs[7] = -t2277*t2766+((-t1404*t3427+(t2247*t2581+t2249*t2277)*t2250+t143*t2248)*t2236+(-t1411*t3335+(t471-t2897)*t2248+t1012)*t2225+(t2126*(-t1412*t3184-t1378+(-t1947+t3183)*t3705)+(-t3785*t2249-(-t1415*t3729+t560)*t2248)*t2235+t41)*t2250+(-t1411*t3340+(-t3474+t644)*t1939)*t2249+(t3890*t3183+t3646+t3729*((-t3067+t2603)*t2259+(t3065+t2604)*t2258-t1922*t1707)-t3001*t1707)*t2248+t2339+t2126*(t1012+((-t1705*t2242+t3433)*t2259+(-t1705*t2239-t3432)*t2258+t1939*t1705)*t2246+t2637))*t2237-t2236*((t1404*t2761+t143*t2249)*t2236+((-t3183*t3705-t2287)*t2249+(t1412*t3732-t2894)*t2248-t3895)*t2225+(t2126*(-t1406*t1947-t2894)+(t2247*t560-t3975)*t2235-t3767)*t2250+(-(t3691-t3889)*t3183+(-t2371-t3049)*t2259-t3952+t3729*((-t3067+t2369)*t2259+(t3065+t2370)*t2258+t1939*t1704)-t2992*t1704)*t2249+(t3183*t469-t3855+t3729*(t3019-t721)+t3019*t2018)*t2248+(-t1706*t3001+t2258*t3806+t2259*t3807)*t2247+t2126*(((t1373+t3433)*t2259+(t1397-t3432)*t2258-t1922*t1706)*t2247+((-t2152*t2243-t2218*t2255)*t2259+(-t2154*t2240-t3218)*t2258+t722)*t2246+t2251*t610))+((-t1922*t3513-t3618)*t2237-t2236*((-t1047*t2259+t1184*t1939)*t2249+t448*t2248+t258+t3729*t610)-(t1042*t2258-t1186*t1922+t2236*t2581+t2259*t990)*t3171)*t2251+((-t1404*t3199-t2248*t368-t2250*t2581)*t2213+((-t1410*t3713+t2249*t368+t2251*t543)*t2236-t506*t2225)*t2237-t2236*t3810-t2236*(-t1415*t2225-t2318)*t3733+((t1406*t2225-t3361+t3834+(-t2226-t2231)*t3733+t3693)*t2248*t2237+((t1414*t2225-t467)*t2237-t2236*(t1412*t2225+t3891))*t2249)*t2235)*t2246;
    coeffs[8] = ((t121*t2247+(t584*t2234+(t960*t2232-t2465+(-t1725*t3727+t2256*t960)*t2256)*t2259+(t584*t2258-t3744*t2232-t1722*t3273+(-t879-t2886)*t2256)*t2258)*t2246)*t2249-((-t3624*t2234+(-t956*t2232+t1371-(t1726*t3727+t2256*t956)*t2256)*t2259+(-t3624*t2258-t3038*t2232+t1724*t3273-(t871-t2889)*t2256)*t2258)*t2247-t2246*(-t2958*t2875-t401*t3121-(t2240*t401+t2871*t2958)*t2258))*t2248+(-t1153*t2521+t3703*t3778)*t1895)*t2225+(t2948*t2224+(t62*t2222+t397*t2784+t2246*(t2246*t62-t3837*t402))*t2249-t2248*(-t2248*t2948+t2280*t3729-t2796*t403))*t2250+t2251*(t6*t2224+(-t77*t2222+t121*t3088-t2246*(t77*t2246+((t1678-t2293)*t2257-t3549)*t2234+((t1634+t2295)*t2232+t3727*t1532-(-t1520*t3727+t2256*t630)*t2256)*t2259-(t273*t2258+t677*t2232-t1722*t2790+(-t1655*t3727+t2256*t677)*t2256)*t2258))*t2249+t2248*(t6*t2248+t32*t2222+(-t276*t2234+(t626*t2232-t2251*t1371+(t1521*t3727+t2256*t626)*t2256)*t2259-(t276*t2258+(t1675-t2345)*t2232+t1724*t2790-t2256*(-t1887*t2794+t2256*t621))*t2258)*t2247+(t32*t2246+t235*t2234-t401*t2660-(((t1892*t2141-t3531)*t2257+t2358)*t2258+t401*t2144)*t2258)*t2246));
    coeffs[9] = ((-t1315+t3477)*t2250-t1404*t3095)*t2213+(((t1312-t3476)*t2250+t3689*t2248+(t1404*t2249-t3475)*t2246)*t2236+(-t1104*t2242+(t1544*t2248+t1546*t2246+t2250*t3719)*t2239+t2235*((t2061-t3225)*t2250+t2169*t3095))*t2243-t1107*t2217+((t1691*t2248+t2246*t3708+t2250*t3718)*t2240+(-t1430*t2249+t1431*t2247+t1692*t2251)*t2239-t2235*(-t2134*t3240+t2139*t3224+t2178*t2569))*t2242+(-t1101*t2239+((t2054-t3232)*t2250+t2165*t3095)*t2235)*t2240-(t1045+t2235*(-t2134*t3246+t2139*t3231+t2175*t2569))*t2239)*t2237+t2236*((t1410*t3088-t2249*t3689)*t2236+t1104*t2218+(t1107*t2242+(-t1430*t2248+t1431*t2246+t1692*t2250)*t2240+(t1691*t2249+t2247*t3708+t2251*t3718)*t2239+(t2976*t2250+(t2060+t2079)*t2248+t3735*t2246)*t2235)*t2243+((t1544*t2249+t1546*t2247+t2251*t3719)*t2240-((-t2050-t3222)*t2249+t2177*t3088)*t2235)*t2242+t1101*t2215+(t1045+(t2979*t2250+(t2053+t2077)*t2248+(t2077-t2057)*t2246)*t2235)*t2240-((-t2047-t3229)*t2249+t2173*t3088)*t3189);
    coeffs[10] = (((-t2958*t3440+t3731*t730)*t2247+((t2429+t960)*t2259+(t2431-t3744)*t2258+t584)*t2246+t1939*t3436)*t2249+(((t956+t3034)*t2259+(t3035+t3038)*t2258+t3624)*t2247+(-t2958*t3439+t1947*(-t2389+t3741))*t2246-t3732*t3436)*t2248-t1153*t3435)*t2225+((-(t3725*t730-t397)*t3183-(-t3726*t3741+t2328+t3056)*t3184+t62+t3729*((t2430-t959)*t2259+(t2432+t976)*t2258+t591))*t2249+((-t2389*t3727+t2328+t3055)*t3183+t3729*((t1892*t3733+t1643)*t2259+(t1888*t3733-t2872)*t2258+t3733*t2389)-t2280)*t2248+t2948+t2126*(((t952+t3036)*t2259+(t3022-t963)*t2258+t3627)*t2247+((-t1646+t2427)*t2259+(t2428+t2873)*t2258-t3732*t3741)*t2246-t1039))*t2250+((-t1173-t3731*(t1121*t2226+t2018*t2390+t3060)-t2958*t2436)*t2247+((t2251*t630+t3726*(-t1636+t960))*t2259+(t2251*t677+t3726*(t1887*t1911+t1505))*t2258+t2251*t273+t3725*((t1636+t3743)*t2257+t2256*(t1635+t968))+t2262*t2018)*t2246-t2251*t77+t3729*((t2458+(t1654+t1640)*t2256+t1922*t1756)*t2259+((t1681-t1640)*t2257-t2481+t1887*t3366)*t2258+t2390*t3366))*t2249+(((t2251*t626+t3726*(t1636+t956))*t2259+(t2251*t621+t3726*(t1635+t3038))*t2258-t2251*t276+t3725*(-t1121*t2143+t3624)+t2261*t2018)*t2247+(t2251*t235+t3725*((t1646-t2878)*t2257+(-t2873-t2885)*t2256-t3741*t2143)-t1947*(t2018*t2389-t2226*t3741+t3057))*t2246+t2251*t32+t3729*(((t1856*t2254+t1664)*t2257+(t1683-t1517)*t2256-t955*t2251)*t2259+((t1670+t1519)*t2257+(t2240*t3065+t1648)*t2256+t2251*t974)*t2258+t2251*t597))*t2248+t2251*t6+t2126*(((t1681-(t3067+t1756)*t2239)*t2210+(t2242*t3065+t1654)*t3062)*t2247+((t1532+(t1895*t2152+t1518+t1670)*t2256)*t2259+(t1856*t2255+t1520+t1683)*t3062)*t2246+(((-t1642-t2882)*t2259+(-t1887*t3129-t1673+t2880)*t2258+t1939*t1121)*t2247+(-t3743*t2259+(t2884-t968)*t2258-t598)*t2246+t2835)*t2251);
    coeffs[11] = (((t3464-t3839)*t2249-t1614*t3090)*t2250+t2251*(-t1613*t3094+t2248*(-t1605*t2246+t3465)))*t2211+(((t1404*t3171-t1410*t3164+(-t1970*t2239-t2768)*t2243-(t1964*t2242+t1994)*t2240)*t2249+(t1413*t2237*t2247+t1614*t3733)*t2248+((t1972*t2239+t2016)*t2243+t2240*(t1966*t2242+t1996))*t2247-t3732*t3464)*t2250+(t3731*t3839+((-t1978*t2239-t2771)*t2243+t1212+(t1980*t2242-t2774)*t2240)*t2246+t1613*t3366)*t2249+(((t1980*t2239-t2771)*t2243-t2727+(-t1978*t2242-t2774)*t2240)*t2247+(t1404*t3162+t1692*t3143+t2165*t3217+t2169*t3214)*t2246-t2251*((t1964*t2239+t2768)*t2243+t2240*(t1970*t2242+t1994)))*t2248-t2251*(t1939*t3465-((t1966*t2239+t2016)*t2243+t2240*(t1972*t2242+t1996))*t2246))*t2235+(-t1039+((-t1199*t2243+t1272*t2240)*t2249+(-t1191*t2240-t1197*t2243)*t2247)*t2236+((t1148*t2239+t1150*t2242)*t2249-(t2240*t909+t2243*t915)*t2248+(-t1143*t2239-t1146*t2242)*t2247+(t2240*t908+t2243*t917)*t2246)*t2237)*t2250+((t1165*t2239+t1167*t2242)*t3164+t2266*t1976+(-(t2239*t924+t2242*t925)*t2247+(-t1161*t2240-t1163*t2243)*t2246+(-t2239*t909-t2242*t915)*t2251)*t2236)*t2249+(((t1165*t2240+t1167*t2243)*t2247+(t1148*t2240+t1150*t2243)*t2251)*t2236+((-t1161*t2239-t1163*t2242)*t2247-(t2240*t924+t2243*t925)*t2246+(-t1199*t2242+t1272*t2239)*t2251)*t2237+t2264*t1976)*t2248+((t3170*t917+t1566)*t2242+t908*t2742+(-t1922*t3152+t2689)*t1981)*t2247+(t1981*t2702+(-t1146*t3170-t1981*t2696+t1566)*t2243+(-t1197*t3162-t1981*t3218)*t2242-t2251*(t1143*t3173+t1191*t3167))*t2246+t2251*t2835;
    coeffs[12] = (((-t1438*t2729+t1440*t2715)*t2249-t1441*t2488)*t2250+t2251*(-t1441*t2494+t2248*(-t1438*t2713+t1440*t2731)))*t2216+((((t3164*t796-t3171*t815)*t2249-t795*t2712)*t2250+(-t795*t2733+t2248*(-t3164*t815+t3171*t796))*t2251)*t2238+((t2485-(t1490*t2259-t2258*(t2257*t3016-t2479))*t2246)*t2249+((t1489*t2259-(t1395*t2257+t2479)*t2258)*t2247+t1947*t2833)*t2248)*t2225+(t494*t2224+(t2373*t2222+(t2259*t771-t2574*t2958)*t3183-t2246*(-t2373*t2246+(t3733*t2207+(t2254*t2572-t1883)*t2259+(t2851-t3468)*t2258)*t2235))*t2249+t2248*(t494*t2248+(t3732*t2205+(-t1579*t2256-t2154*t2232)*t2259+t2258*(t2201*t3732-t3468))*t3183-t3729*t2699))*t2250-t2251*(-t482*t2224-(t2255*t2850+(-t2235*t2684+t2251*t2460-t3131*t3177)*t2259+(t2255*t2849+t3463)*t2258)*t3094+t2248*(-t482*t2248-t2222*t3526+(t2234*t2853+((-t2229*t3188-t2094)*t2257+t3064)*t2259+(t2258*t2853+t3463)*t2258)*t2247-t2246*(t755*t2246+(t2755-t3738*t3123+(t1562*t2240+t1713)*t2256)*t2259-t2958*t2333))+((-t2246*(-t2854-t1562*t2210+(t1453*t2257-t1928*t2195-t2745)*t2258)+t2285)*t2249+t2248*(t2222*t2851+((t2254*t3177-t2450+t2759)*t2259+(t1929*t2195-t2257*t3738-t2745)*t2258)*t2247))*t2239))*t2241+((((-t1447*t2730+t1449*t2716)*t2249-t1450*t2489)*t2250+t2251*(-t1450*t2495+(-t1447*t2714+t1449*t2732)*t2248))*t2238+((-t2468-t2246*((-t1384*t2256+t2037)*t2259-t2258*t1490))*t2249-t2248*(((-t1383*t2256+t2037)*t2259+t2258*t1489)*t2247+t1947*t2831))*t2225+(t490*t2224+(-t753*t2222-(-t2958*t3191+(-t771-t2832)*t2258)*t3183-t2246*(t753*t2246+((-t1446*t2259+t2201*t2232)*t2243+(t3359+(t1579+t3353)*t2258)*t2256)*t2235))*t2249+t2248*(t490*t2248+(-t1446*t3121+t1883*t2258+t2254*t2265)*t3183+t3729*t2664))*t2250-t2251*(t486*t2224+(-t2285*t2242+(-t2254*t2850-(-t1047+t2034)*t2210-(t2254*t2849-t2239*t2759+(-t2194*t2235+t2112)*t3145)*t2258+(t1453*t3062-t2854-(-t3837-t2115)*t2209)*t2242)*t2246)*t2249+t2248*(t486*t2248+t749*t2222+(t3178*t3372+(-t2256*t2983+(-t2256*t1380+(-t3837+t2115)*t2242)*t2254)*t2259+(t2239*t2450-t3064+(t2684+(t2670+t3820)*t2256)*t2235)*t2258)*t2247+t2246*(t749*t2246-(t2755+t1453*t3123-(-t1713+t2240*(t2112-t2543))*t2256)*t2258-(t3187*t3725-t2764)*t2958))))*t2238;
    coeffs[13] = (((t2169*t2729-t2177*t2715)*t2249+t2178*t2488)*t2250-t2251*(-t2178*t2494+(-t2169*t2713+t2177*t2731)*t2248))*t2216+((((-t1430*t3164+t1692*t3171)*t2249+t1431*t2712)*t2250-t2251*(-t1431*t2733+(t1430*t3171-t1692*t3164)*t2248))*t2238+(((-(t2259*t3705+t3316)*t2247+(t1937*t2259-t2257*t3733+t2000)*t2246)*t2235+t2373)*t2249+(-(-t1933*t2259-t2255*t3732+t2000)*t3183-t2699)*t2248+t494)*t2250+(t2485+((-t1917*t3145+(t2198*t2240-t2749)*t2242)*t2259+((t1911*t2239+t3065)*t2257-t1926*t3146)*t2258+t1939*t2749)*t2246-t1922*t2822)*t2249+((((t2090+t2709)*t2257-t2461-t2254*t2087)*t2259+((-t3065+t3388)*t2257-t1927*t3146)*t2258-t1922*t2747)*t2247+((-t1910*t3123+t1917*t2156+t1715)*t2259+t1943*t3315)*t2246+t2251*t755)*t2248+t2251*t482)*t2241-((((-t2165*t2730+t2173*t2716)*t2249-t2175*t2489)*t2250+t2251*(-t2175*t2495+t2248*(-t2165*t2714+t2173*t2732)))*t2238+((((t2258*t3705-t3314)*t2247-(t1933*t2258+t2009-t3354)*t2246)*t2235+t753)*t2249+((-t1937*t2258-t2254*t3732+t2009)*t3183-t2664)*t2248-t490)*t2250+(t2468+((t2037+(-t2101+t3017)*t2256+t2464)*t2259+(t1911*t3129-t2239*(t2114-t2750))*t2258-t1939*t2750)*t2246-t1922*t2821)*t2249+(((t2037+(-t2101-t3017)*t2256-t2464)*t2259+(t2032+(-t2087-t2696)*t2256+t2235*t2678)*t2258+t1922*t2748)*t2247+((-t1911*t3123+(t2143+t2154)*t2156-t1715)*t2258-t2342*t2958)*t2246+t2251*t749)*t2248+t2251*t486)*t2238;
    coeffs[14] = (((-t2257*t2825-t2259*t2834)*t2249+t2640*t3307)*t2250-t2251*(-t2642*t3308+t2248*(t2257*t2826+t2259*t2833)))*t2216-(((-t1942*t1976*t2246-t1946*t3312)*t2249+t1925*t1981*t3090)*t2250-t2251*(-t1923*t1981*t3094+(t1940*t3309+t1948*t3313)*t2248))*t3158-(((-t2247*t2832-t2256*t2823)*t2249+t2641*t3305)*t2250-t2251*(-t2643*t3306+(t2256*t2824+t2258*t2831)*t2248))*t2214;
    coeffs[15] = (t764*t2513+t2953*(t2224*t2911+(t2248*t2911-t3298*t765)*t2248))*t2213-((t2224*t3550-t765*t2813+t2248*(t2248*t3550-t2926))*t2225+t767*t2513+t2251*(t139*t2224-t765*t2510+t2248*(t139*t2248-t2251*t2926)))*t3175+((t2589*t3288-t2539)*t2225+t2251*(t2126*t220-t2510*t768))*t2212;
    coeffs[16] = (-t3936*t3199+(t2126*t2940+t2575*t764)*t2250-t3671*t2248)*t2213+((t3936*t2249+t172*t2248-t3550+t2126*(-t2244*t559-t3910))*t2225+(t2126*t2597-t3791)*t2250+t3671*t2249+t74*t2248-t2251*t139+t2126*(-t2244*t288-t2251*t2940-t3554))*t3175-((t3620+(-t2126*t559-t700)*t2245)*t2225+t74*t2249-t2251*t220+t2126*(t2251*t2597-t3553))*t2212+((t2126*t557+t2127*t3922)*t2225+t3922*t2044+t2126*t287)*t3221;
    coeffs[17] = (t323*t3199+(t2126*t3933+t2940)*t2250+t91*t2248)*t2213-((t3910+t2248*t325+t2249*t323+t2126*(-t1414*t2245-t1415*t2244))*t2225+(t2126*t3948-t2597)*t2250+t91*t2249+t93*t2248+t3554+t2126*(t2244*t468+t2245*t466+t2251*t3933))*t3175+t2212*((t325*t2249+(t559-t3751)*t2245)*t2225+t93*t2249+t3553+t2126*(t2245*t468+t2251*t3948))+(-t2212*t2597-t2940*t3175)*t2251+(((-t2395+t557)*t2225+t287+t2126*t466)*t2213+t3787*t3175)*t2244;
    coeffs[18] = ((-t2224*t2906-(t665-t2929)*t2248)*t2250+t761*t2244*t2433)*t2213+((t761*t3927*t3263+(-t2249*t2929+t3637)*t2250+t2251*((t665+t2273)*t2248+(-t2779*t761+t3271*t762)*t2244))*t2236+(-t164*t2224+t213*t2249-t2248*(t164*t2248+t227*t2220-t2528+t2244*(t2244*t227+t3262*t767)))*t2225+(t46*t2224-t3730*t764*t2783+(t2248*t46-t2816*t777)*t2248)*t2250-t2251*(t49*t2224-t213*t3082+(t49*t2248+t109*t2220-t2251*t2528+t2244*(t109*t2244+t2782*t767))*t2248))*t2237-t2236*((-t761*t3725*t2762+t2251*(t2249*t2273+t3637))*t2236+(-t2443*t2224+(t231*t2220+t2533+t2244*(t2244*t231-t2915))*t2249-t2248*(t2248*t2443+t2578*t768-t2525))*t2225+(-t2235*t2539+t2126*(t2525+t3960))*t2250+t2251*(t13*t2224+(t112*t2220+t764*t2501+t2244*(t112*t2244-t2788*t768))*t2249+t2248*(t13*t2248+t2269*t3730+t2507*t777)));
    coeffs[19] = ((-t1602*t2126-t3916)*t2250-t2244*t3879+(t3662-t3876)*t2248+(-t2225*t2244-t3711)*t1613)*t2213+((-t1609*t2249-t1610*t2248+t3042)*t2225+(t1603*t2126-t3720)*t2250+(-t3040+t3876)*t2249-t3919*t2248+t3879*t2245+t3873*t2244+t2126*(t1602*t2251+t3042))*t3175+((t1610*t2249-t3844)*t2225+t3919*t2249-t3873*t2245+t2126*(-t1603*t2251-t3844))*t2212+(t2212*t3720+t3175*t3916)*t2251;
    coeffs[20] = (-t3938*t3085+(-t3923*t2250+(-t2225*t433+t204)*t2248)*t2244)*t2213+((t204*t3927+t2250*t3972-t3428*t433)*t2236+((t3730*t470-t227)*t2248-t164+t2126*(-t2244*t505+t1011))*t2225+(t2126*t40+t3650)*t2250+(t1906*t2315+t3647)*t3668+t2126*(-t3326*t764+t2340))*t2237+((t204*t3105-t2762*t433)*t2236+((t2288*t3730-t231+t3643)*t2249+(-t1409*t3332+t3732*t602)*t2248+t2443+t2126*(t1415*t3393+t3896))*t2225+(-t3960+t2126*(-t3185*t559+t3766))*t2250+t3730*t2249*(-t1939*t3804-t3962)+(-t2251*t445-t2319*t3732+t3856)*t3668+t2126*((t1906*t2309-t3799)*t2245+(t1908*t2318-t3809)*t2244-t2251*t256-t3709*t609))*t2236+(((-t557*t3117+(-t2244*t2408+t2245*t533)*t2248)*t2225+(-t2940*t2249-(t3730*t559+t700)*t2248-t764*t3260)*t2250-t287*t3117+(t293*t2245-(t2226*t767+t3725*t3886)*t2244)*t2248)*t2237+((-t3288*t777+t3620)*t2250+(-(t2226*t764+t3725*t3883)*t2245+t294*t2244)*t2249+t3787*t3106)*t2236)*t2235+t2263*t3335+(((t2248*t3938+t3711*t530+t2906)*t2236-t109*t2248-t49)*t2237+(-t112*t2249-t2236*t3972-t2248*t2269-t13)*t2236)*t2251;
    coeffs[21] = (t1265*t2239+t1267*t2242)*t2213-(t1267*t2243+(-t2059-t3736)*t2242+t1265*t2240-t2239*t1274)*t3175-((t2078+t2977)*t2243+t1274*t2240)*t2212;
    coeffs[22] = -t2278*t2766+((-t1401*t3428+(t2245*t2582+t2249*t2278)*t2250+t142*t2248)*t2236+(-t1408*t3335+(t1208+t470-t2898)*t2248+t1011)*t2225+(t2126*(t613+t3050)+(-t3933*t2249-(-t1415*t3730+t559)*t2248)*t2235+t40)*t2250+(-t1408*t3816+t1939*t638)*t2249+(t3884*t3185+t3647+t3730*((-t3071+t2603)*t2259+(t3069+t2604)*t2258-t1906*t1707)-t3012*t1707)*t2248+t2340+t2126*(t1011+((t3433-t3461)*t2259+(-t3432-t3462)*t2258+t1939*t1703)*t2244+t2638))*t2237-t2236*((t1401*t2762+t142*t2249)*t2236+((-t2288-t3050)*t2249+(t1409*t3732-t2895)*t2248-t3896)*t2225+(t2126*(-t1403*t1947-t2895)+(-(t539+t3694)*t2249+t559*t2245)*t2235-t3766)*t2250+(-(t3687-t3883)*t3185+t3730*((-t3071+t2369)*t2259+(t3069+t2370)*t2258+t1939*t1702)-t2992*t1702+t3962)*t2249+(t3185*t468-t3856+t3730*(t3019-t718)+t3019*t2017)*t2248+(-t1706*t3012+t3799)*t2245+t2126*(((t3433+t1372)*t2259+(t1396-t3432)*t2258-t1906*t1706)*t2245+(t720+t3742)*t2244+t2251*t609))+((-t1906*t3513-t3731*t764)*t2237-t2236*(t2248*t445+t2416*t3335+t3730*t609+t256)-(-t1186*t1906+t2236*t2582)*t3172)*t2251+((-t1401*t3199-t2248*t367-t2250*t2582)*t2213+((-t1407*t3713+t2249*t367+t2251*t530)*t2236+(t1414*t3182-t505)*t2225-t466*t3182+(t3688-t3886)*t2235*t2248)*t2237-t2236*(-t1415*t3401-t2021*t3721-t3182*t3887+t3809))*t2244;
    coeffs[23] = ((t120*t2245+(t581*t2234+(t958*t2232-t2466+(t2256*t958-t3457)*t2256)*t2259+(t581*t2258+t969*t2232-t1722*t3284+(t878-t2888)*t2256)*t2258)*t2244)*t2249-((-t3625*t2234+(-t954*t2232+t1370-(t2256*t954+t1366)*t2256)*t2259+(-t3625*t2258+t966*t2232+t1724*t3284-t2256*(-t870-t2890))*t2258)*t2245-t2244*(-t2959*t2875-t399*t3121-(t2240*t399+t2871*t2959)*t2258))*t2248+(t1973*t3703*t3730-t1152*t2521)*t1895)*t2225+(t2949*t2224+(t61*t2220+t396*t2785+t2244*(t2244*t61-t3837*t400))*t2249-(-t2248*t2949+t2281*t3730-t2808*t403)*t2248)*t2250+t2251*(t5*t2224+(-t76*t2220+t120*t3104-(t76*t2244+(t2257*t628-t3560)*t2234+(t625*t2232+t2127*t1532-(t2256*t629-t2892)*t2256)*t2259-(t272*t2258+t676*t2232-t1722*t2801+(t2256*t676-t2518)*t2256)*t2258)*t2244)*t2249+t2248*(t5*t2248+t31*t2220+(-t275*t2234+(t624*t2232-t2251*t1370+(t2256*t624+t1220)*t2256)*t2259-(t275*t2258+t627*t2232+t1724*t2801-(t2256*t619-t2519)*t2256)*t2258)*t2245+(t31*t2244+t234*t2234-t399*t2660-((t2257*t757+t2359)*t2258+t399*t2144)*t2258)*t2244));
    coeffs[24] = ((-t1315+t1317)*t2250-t1401*t3118)*t2213+(((t1312-t3483)*t2250-t3747*t2248+(t1401*t2249-t3482)*t2244)*t2236+(-t1103*t2242+(t1542*t2248+t1545*t2244+t2250*t3717)*t2239+((t2061-t3228)*t2250+t2167*t3118)*t2235)*t2243-t1106*t2217+((t1689*t2248+t2244*t3707+t2250*t3716)*t2240+(-t1428*t2249+t1429*t2245+t1690*t2251)*t2239-(-t2132*t3243+t2138*t3226+t2178*t2570)*t2235)*t2242+(-t1100*t2239+((t2054-t3237)*t2250+t2163*t3118)*t2235)*t2240-t2239*(t1044+(-t2132*t3248+t2138*t3235+t2175*t2570)*t2235))*t2237+t2236*((t2249*t3747+t1213)*t2236+t1103*t2218+(t1106*t2242+(-t1428*t2248+t1429*t2244+t1690*t2250)*t2240+(t1689*t2249+t2245*t3707+t2251*t3716)*t2239+(t2977*t2250+(t2059+t2078)*t2248+t3736*t2244)*t2235)*t2243+((t1542*t2249+t1545*t2245+t2251*t3717)*t2240-t2235*((-t3222-t3244)*t2249+t2011))*t2242+t1100*t2215+(t1044+t2235*(t2980*t2250+(t2052+t2076)*t2248+(t2076-t2056)*t2244))*t2240-((-t3229-t3249)*t2249+t2010)*t3189);
    coeffs[25] = (((-t2959*t3440+t3731*t729)*t2245+((t2429+t958)*t2259+(t2431+t969)*t2258+t581)*t2244+t1939*t3437)*t2249+(((t954+t3034)*t2259+(t3035-t966)*t2258+t3625)*t2245+(-t2959*t3439+t1947*(-t1124-t2389))*t2244-t3732*t3437)*t2248-t1152*t3435)*t2225+(((-(t3725*t729-t396)*t2245-(t1124*t3726+t2329+t3058)*t2244)*t2235+t3730*((t2430-t957)*t2259+(t2432+t975)*t2258+t587)+t61)*t2249+((-t2127*t2389+t2329+t3055)*t3185+t3730*((t1643+t1363)*t2259+(t1362-t2872)*t2258+t1908*t2389)-t2281)*t2248+t2949+t2126*(((t950+t3036)*t2259+(t3022+t3024)*t2258+t3628)*t2245+((t2427-t2874)*t2259+(t1645+t2428)*t2258+t3732*t1124)*t2244-t1038))*t2250+((-t1172-t3731*(t2017*t2390+t1088+t3061)-t2959*t2436)*t2245+((t3726*t781+t605)*t2259+(t3726*t818+t656)*t2258+t2251*t272+t3725*(t2256*t786+t2257*t778)+t2262*t2017)*t2244-t2251*t76+t3730*((t1029*t2256+t1219+t2516)*t2259+(t1034*t2257-t1701*t2239+t1218)*t2258+t2390*t3407))*t2249+(((t3726*t779+t604)*t2259+(t3726*t784+t603)*t2258-t2251*t275+t3725*(-t2901+t3625)+t2261*t2017)*t2245+(t2251*t234+t3725*(t1027*t2257+t1028*t2256+t1024)-t1947*(t2017*t2389+t1089+t3059))*t2244+t2251*t31+t3730*((t1033*t2257+t2256*t979-t3564)*t2259+(t1030*t2256+t2257*t961-t3563)*t2258+t2251*t594))*t2248+t2251*t5+t2126*((t2210*t804+t3062*t801)*t2245+((t2256*t783+t1532)*t2259+t787*t3062)*t2244+(((-t2726-t2882)*t2259+(-t1673+t1641)*t2258+t1120*t1939)*t2245+(-t3543+(t2884-t967)*t2258-t596)*t2244+t2840)*t2251);
    coeffs[26] = (((t1482-t3848)*t2249-t1614*t3106)*t2250+t2251*(-t1613*t3117+t2248*(t1470-t3466)))*t2211+(((t2744-t2725+(-t1969*t2239-t2769)*t2243-t2240*(t1963*t2242+t1991))*t2249+(t1413*t3165+t1614*t1908)*t2248+((t1971*t2239+t2015)*t2243+t2240*(t1965*t2242+t1995))*t2245-t3732*t1482)*t2250+(t1602*t3327+((-t1977*t2239-t2773)*t2243+t1212+(t1979*t2242-t2775)*t2240)*t2244+t1613*t3407)*t2249+(((t1979*t2239-t2773)*t2243-t2728+(-t1977*t2242-t2775)*t2240)*t2245+(t1401*t3162+t1690*t3143+t2163*t3217+t2167*t3214)*t2244-t2251*((t1963*t2239+t2769)*t2243+t2240*(t1969*t2242+t1991)))*t2248-t2251*(t1609*t3336-t2244*((t1965*t2239+t2015)*t2243+t2240*(t1971*t2242+t1995))))*t2235+(-t1038+((-t1198*t2243+t1270*t2240)*t2249+(-t1190*t2240-t1196*t2243)*t2245)*t2236+((t1147*t2239+t1149*t2242)*t2249-(t2240*t907+t2243*t914)*t2248+(-t1140*t2239-t1142*t2242)*t2245+(t2240*t906+t2243*t916)*t2244)*t2237)*t2250+((t1164*t2239+t1166*t2242)*t3166+t2266*t1973+(-(t2239*t922+t2242*t923)*t2245+(-t1156*t2240-t1158*t2243)*t2244+(-t2239*t907-t2242*t914)*t2251)*t2236)*t2249+(((t1164*t2240+t1166*t2243)*t2245+(t1147*t2240+t1149*t2243)*t2251)*t2236+((-t1156*t2239-t1158*t2242)*t2245-(t2240*t922+t2243*t923)*t2244+(-t1198*t2242+t1270*t2239)*t2251)*t2237+t2264*t1973)*t2248+((t3170*t916+t1565)*t2242+t906*t2742+t2289*t1981)*t2245+(t1981*t2765+(-t1142*t3170-t1981*t2697+t1565)*t2243+(-t1196*t3162-t1981*t3219)*t2242-t2251*(t1140*t3173+t1190*t3167))*t2244+t2251*t2840;
    coeffs[27] = (((-t1436*t2734+t1439*t2721)*t2249-t1441*t2490)*t2250+t2251*(-t1441*t2496+(-t1436*t2719+t1439*t2736)*t2248))*t2216+((((t3166*t794-t3172*t814)*t2249-t793*t2717)*t2250+t2251*(-t793*t2740+(-t3166*t814+t3172*t794)*t2248))*t2238+((t2486-t2244*(t1488*t2259-(t1391*t2257-t2483)*t2258))*t2249+t2248*((t1487*t2259-(t1392*t2257+t2483)*t2258)*t2245+t1947*t2838))*t2225+(t493*t2224+(t2375*t2220+(t2259*t764-t2574*t2959)*t3185-t2244*(-t2375*t2244+(t1908*t2207+(t2252*t2572-t1882)*t2259+(t1908*t3062-t3469)*t2258)*t2235))*t2249+t2248*(t493*t2248+(t3732*t2203+(-t1578*t2256-t2150*t2232)*t2259+(t2200*t3732-t3469)*t2258)*t3185-t1981*t2435))*t2250-t2251*(-t481*t2224+(-(t1939*t2758+(-t1416*t2256+(t2240*t2635-t2253*t3837)*t2242)*t2259+(t1939*t2746+t2257*t828)*t2258)*t2244+(t1981*t3415-t2448-(-t1981*t3409+(-t1928*t2193-t2182*t2235)*t2258)*t2244)*t2239)*t2249+t2248*(-t481*t2248+t2291*t2220+((t1235*t2257+t3301)*t2259+(t1929*t2704+t2257*t827)*t2258+(t2257*t2523+(-t2631+t3838)*t2239)*t2235)*t2245-t2244*(-t2291*t2244+(t2756-t3734*t3123+(t1712+t1418)*t2256)*t2259-t2959*t2333))))*t2241+((((-t1445*t2735+t1448*t2722)*t2249-t1450*t2491)*t2250+t2251*(-t1450*t2497+(-t1445*t2720+t1448*t2737)*t2248))*t2238+((-t2469-t2244*((-t1382*t2256+t2036)*t2259-t2258*t1488))*t2249-t2248*(((-t1381*t2256+t2036)*t2259+t2258*t1487)*t2245+t1947*t2836))*t2225+(t489*t2224+(-t752*t2220-(-t2959*t3191+(-t2959*t3128-t764)*t2258)*t3185-t2244*(t752*t2244+((-t1444*t2259+t2631)*t2243+(t3396+(t1578+t3389)*t2258)*t2256)*t2235))*t2249+(t489*t2248+(-t1444*t3121+t1882*t2258+t2252*t2265)*t3185+t3730*t2665)*t2248)*t2250-t2251*(t485*t2224+(-t1981*t2862+t2242*t2448-t2244*(t1981*t2861+(t2256*t2423-t2411)*t2259+(-t1452*t3129+t2109*t3145)*t2258))*t2249+t2248*(t485*t2248+t748*t2220+((-t2256*t2422+t2411)*t2259+(t2239*t2451-t3301)*t2258)*t2245+(t748*t2244+t2959*t2764-t2258*(t1452*t3123-(-t1712+t1417)*t2256))*t2244)+(t2248*((t1906*t2206+(t1906*t3063+t2232*t2149-t2256*(t2394-t2673))*t2258)*t2245+(-t2959*t3190-t2258*(t2959*t3122+t3398))*t2244)+(-t3656*t3117+(-t3106+t3117)*t3764)*t2252)*t2235))*t2238;
    coeffs[28] = (((t2167*t2734-t2176*t2721)*t2249+t2178*t2490)*t2250-(-t2178*t2496+(-t2167*t2719+t2176*t2736)*t2248)*t2251)*t2216+((((-t1428*t3166+t1690*t3172)*t2249+t1429*t2717)*t2250-t2251*(-t1429*t2740+(t1428*t3172-t1690*t3166)*t2248))*t2238+(((-(t1402*t2259+t2239*t2959)*t2245+(-t1908*t2257+t1935*t2259+t1999)*t2244)*t2235+t2375)*t2249+(-(-t1931*t2259-t2253*t3732+t1999)*t3185-t1908*t3307)*t2248+t493)*t2250+(t2486+((-t1904*t3145-t2023+t2478)*t2259+(t1131*t2257-t1926*t3148)*t2258+t1939*t2751)*t2244-t1906*t2822)*t2249+(((t1727*t2257-t2476-t2500)*t2259+(t1127*t2257-t1927*t3148)*t2258-t1906*t2747)*t2245+((-t1899*t3123+t1904*t2156+t1714)*t2259+t2240*t2959*t1943)*t2244-t2251*t2291)*t2248+t2251*t481)*t2241-t2238*((((-t2163*t2735+t2171*t2722)*t2249-t2175*t2491)*t2250+t2251*(-t2175*t2497+(-t2163*t2720+t2171*t2737)*t2248))*t2238+((((t1402*t2258-t2242*t2959)*t2245-(t1931*t2258+t2008-t3390)*t2244)*t2235+t752)*t2249+((-t1935*t2258-t2252*t3732+t2008)*t3185-t2665)*t2248-t489)*t2250+(t2469+((t1116*t2256+t2022+t2036)*t2259+(t1900*t3129-t2239*(t2113-t2752))*t2258-t1939*t2752)*t2244-t1906*t2821)*t2249+(((t1115*t2256-t2022+t2036)*t2259+(t1728*t2256+t2023+t2031)*t2258+t1906*t2748)*t2245+((-t1900*t3123+t1903*t2156-t1714)*t2258-t2342*t2959)*t2244+t2251*t748)*t2248+t2251*t485);
    coeffs[29] = (((-t1973*t2693-t2705*t2959)*t2249+t2645*t3307)*t2250-t2251*(-t2650*t3308+t2248*(t1973*t2706+t2692*t2959)))*t2216-(((-t1942*t3311-t1946*t3317)*t2249+t1909*t1981*t3106)*t2250-t2251*(-t1907*t1981*t3117+t2248*(t1940*t3310+t1948*t3318)))*t3158-(((-t1973*t2662-t2680*t2959)*t2249+t2646*t3305)*t2250-t2251*(-t2651*t3306+t2248*(t1973*t2681+t2661*t2959)))*t2214;
    coeffs[30] = (t763*t2514+t2953*(t772*t2809+t2246*(t2804*t772-t3299*t765)))*t2213-((t375*t3294-t765*t2814+t2246*(t3287*t375-t3299*t768))*t2225+t766*t2514+t2251*(t138*t2222-t765*t2511+t2246*(t138*t2246-t2918*t3730)))*t3175+((t2434*t774-t2814*t768)*t2225+t2251*(t219*t3729-t2511*t768))*t2212;
    coeffs[31] = (-t3935*t3200+(t2575*t763+t2941*t3729)*t2250-t3672*t2246)*t2213+((t3935*t2247+t171*t2246-t2127*t375+t3729*(-t2244*t551-t3911))*t2225+(t2598*t3729-t3792)*t2250+t3672*t2247+t73*t2246-t2251*t138+t3729*(-t2244*t286-t2251*t2941-t3556))*t3175-((t3621+(-t3729*t551-t697)*t2245)*t2225+t73*t2247-t2251*t219+t3729*(t2251*t2598-t3555))*t2212+((t2127*t772+t3729*t547)*t2225+t772*t2044+t3729*t285)*t3221;
    coeffs[32] = (t322*t3200+(t3729*t3957+t2941)*t2250+t90*t2246)*t2213-((t3911+t2246*t324+t2247*t322+t3729*(-t1411*t2245-t1412*t2244))*t2225+(t3729*(t2409-t3755)-t2598)*t2250+t90*t2247+t92*t2246+t3556+t3729*(t2244*t464+t2245*t462+t2251*t3957))*t3175+((t324*t2247+(t551-t3900)*t2245)*t2225+t92*t2247+t3555+t3729*(t464*t2245+(-t2304-t3685)*t2251))*t2212+(-t2212*t2598-t2941*t3175)*t2251+(((t2396+t547)*t2225+t285+t3729*t462)*t2213+t3786*t3175)*t2244;
    coeffs[33] = ((-t762*t2799-(t664-t3858)*t2246)*t2250+t2910*t3773)*t2213+((t3926*t760*t3263+(-t2815*t770+t3638)*t2250+t2251*(t2246*(t664+t2274)+(t2222*t3546-t2780*t760)*t2244))*t2236+(-t163*t2222+t212*t2247-(t163*t2246+t226*t2220-t2529+t2244*(t2244*t226+t3262*t766))*t2246)*t2225+(t45*t2222-t3725*t2538+(t2246*t45-t2816*t774)*t2246)*t2250-t2251*(t48*t2222-t212*t3088+(t48*t2246+t113*t2220-t2251*t2529+t2244*(t113*t2244+t2782*t766))*t2246))*t2237-t2236*((-t3725*t760*t2763+t2251*(t2247*t2274+t3638))*t2236+(-t2444*t2222+(t229*t2220+t2534+t2244*(t2244*t229-t2919))*t2247-(t2246*t2444+t3833*t768-t2532)*t2246)*t2225+(-t768*t2512+t3729*(t2532+t3961))*t2250+t2251*(t12*t2222+(t110*t2220+t763*t2501+t2244*(t110*t2244-t2235*t2918))*t2247+t2246*(t12*t2246+t2270*t3730+t2507*t774)));
    coeffs[34] = ((-t2445+t3925)*t2250+(t3662-t3875)*t2246+(t3846-t3877)*t2244)*t2213+((-t1609*t2247-t1610*t2246+t3043)*t2225+(t2446+t3793)*t2250+(-t3040+t3875)*t2247-t3920*t2246+t3877*t2245+t3872*t2244+t3729*(t1598*t2251+t3043))*t3175+((t1610*t2247-t3845)*t2225+t3920*t2247-t3872*t2245+t3729*(-t1599*t2251-t3845))*t2212+((t1598*t3730-t3925)*t3175+(-t3746-t3793)*t2212)*t2251;
    coeffs[35] = (t2596*t3093+((-t3729*t529-t3546)*t2250+(-t2225*t424+t203)*t2246)*t2244)*t2213+((-t424*t3429+(-t3955+(t2222*t529+t298)*t2245)*t2250+t3926*t203)*t2236+((t3730*t475-t226)*t2246-t163+t3729*(-t2244*t504+t1010))*t2225+(t3729*t39+t3651)*t2250+((-t1705*t3725-t3514)*t1906+t3648)*t3669+t3729*(-t3326*t763+t2354))*t2237+t2236*((t203*t3107-t2763*t424)*t2236+((t2341*t3730-t229+t3645)*t2247+t2444+t3729*(t1412*t3393-t3932)+(-t3480+t602)*t3357)*t2225+(-t3961+t3729*(-t3185*t551+t3770))*t2250+t3730*t2247*(-t1922*t3804-t3963)+(-t2251*t443-t2319*t3733+t3857)*t3669+t3729*((t1906*t3661-t3798)*t2245+(t1947*t3403-t3808)*t2244-t2251*t254-t3709*t608))+(((-t547*t3119+(-t2244*t2409+t2245*t532)*t2246)*t2225+(-t2941*t2247-(t3730*t551+t697)*t2246-t763*t3260)*t2250-t285*t3119+(t289*t2245-(t2226*t766+t3657*t3725)*t2244)*t2246)*t2237+t2236*((-t3288*t774+t3621)*t2250+(-(t2226*t763+t3678*t3725)*t2245+t290*t2244)*t2247+t3786*t3108))*t2235+t2263*t3367+(((t2244*t3546-t2246*t2596+t3817*t529)*t2236-t113*t2246-t48)*t2237+t2236*((-t2245*t298-t3208*t529+t3955)*t2236-t110*t2247-t2270*t2246-t12))*t2251;
    coeffs[36] = (t1262*t2239+t1264*t2242)*t2213-(t1264*t2243+(-t2058-t3737)*t2242+t1262*t2240-t1273*t2239)*t3175-t2212*((t2075+t2978)*t2243+t1273*t2240);
    coeffs[37] = -t2279*t2213*t3093+((-t1398*t3429+(t2245*t2583+t2247*t2279)*t2250+t141*t2246)*t2236+((t1206+t475-t2898)*t2246+t1010)*t2225+(t3729*(t612+t3052)+(-t3957*t2247-(-t1412*t3730+t551)*t2246)*t2235+t39)*t2250+(t3885*t3185+t3648+t3730*((t2974-t1389)*t2259+(-t2087+t1112)*t2258-t1906*t1705)-t3012*t1705)*t2246+t2354+t3729*(t1010+((t3067-t3461)*t2259+(-t3065-t3462)*t2258+t1922*t1703)*t2244+t2639))*t2237-((t141*t2247+t2225*t2647)*t2236+((-t2341-t3052)*t2247+(t1409*t3733-t2896)*t2246+t3932)*t2225+(t3729*(-t1400*t1947-t2896)+(-(t538+t3694)*t2247+t551*t2245)*t2235-t3770)*t2250+(-(-t3678+t3683)*t3185+t3730*((-t1373-t3071)*t2259+(-t1109-t2087)*t2258+t1922*t1702)+t3963)*t2247+(t3185*t464-t3857+t3730*(t1947*t3733-t717)+t1947*t3363)*t2246+(-t1704*t3012+t3798)*t2245+t3729*(((t3067+t1372)*t2259+(t1396-t3065)*t2258-t1906*t1704)*t2245+(t719+t3742)*t2244+t2251*t608))*t2236+((-t1906*t3515-t3731*t763)*t2237-(t2246*t443+t3730*t608+t254)*t2236-(-t1184*t1906+t2236*t2583)*t3172)*t2251+(-t3804*t2236+(-t1408*t3894+t638)*t2237)*t3367+((-t1398*t3200-t2246*t366-t2250*t2583)*t2213+((-t1407*t3710+t2247*t366+t2251*t529)*t2236+(-t504+t2897)*t2225-t462*t3183+(-t3657+t3685)*t3184)*t2237-(-t1412*t3401-t2018*t3721-t3183*t3888+t3808)*t2236)*t2244;
    coeffs[38] = ((t119*t2245+t2244*(t580*t2234+t346*t2259+t2258*(t2258*t580+t2379)))*t2247-((-t3626*t2234+t345*t2259+(-t2258*t3626+t2441)*t2258)*t2245-(-t2234*t1234-t398*t3121-(t1234*t2258+t385)*t2258)*t2244)*t2246+(-t1152*t3778+(-t2246*t3833+t3367*t3730)*t1973)*t1895)*t2225+(t2950*t2222+(t60*t2220-t2437*t2785+t2244*(t2244*t60-t3281*t400))*t2247-(-t2246*t2950+t2282*t3730-t2808*t402)*t2246)*t2250+t2251*(t4*t2222+(-t78*t2220+t119*t3104-t2244*(t78*t2244+(t2255*t628-t3562)*t2234+(t625*t2230+t2127*t1531-(t2254*t629-t2892)*t2254)*t2259-(t271*t2258+t676*t2230-t1722*t2802+(t2254*t676-t2518)*t2254)*t2258))*t2247+t2246*(t4*t2246+t30*t2220+(-t274*t2234+(t624*t2230-t2251*t1369+(t2254*t624+t1220)*t2254)*t2259-(t274*t2258+t627*t2230+t1724*t2802-(t2254*t619-t2519)*t2254)*t2258)*t2245+t2244*(t30*t2244+t233*t2234-t398*t2660-((t2255*t757+t2360)*t2258+t398*t2144)*t2258)));
    coeffs[39] = ((t1317-t3477)*t2250-t2644)*t2213+(((t3476-t3483)*t2250+t2392*t2246+(t1398*t2247-t3482)*t2244)*t2236+(-t1102*t2242+(t1541*t2246+t1543*t2244+t2250*t3715)*t2239+((t3225-t3228)*t2250+t1983)*t2235)*t2243-t1105*t2217+((t1686*t2246+t2244*t3706+t2250*t3714)*t2240+(-t1426*t2247+t1427*t2245+t1688*t2251)*t2239-(-t2131*t3251+t2138*t3227-t2177*t2571)*t2235)*t2242+(-t1099*t2239+((t3232-t3237)*t2250+t1982)*t2235)*t2240-t2239*(t1043+t2235*(-t2131*t3257+t2138*t3236-t2173*t2571)))*t2237+((-t2247*t2392+t1213)*t2236+t1102*t2218+(t1105*t2242+(-t1426*t2246+t1427*t2244+t1688*t2250)*t2240+(t1686*t2247+t2245*t3706+t2251*t3714)*t2239+(t2978*t2250+(t2058+t2075)*t2246+t3737*t2244)*t2235)*t2243+((t1541*t2247+t1543*t2245+t2251*t3715)*t2240-((-t2161*t2245-t2177*t2251)*t2247+t2011)*t2235)*t2242+t1099*t2215+(t1043+t2235*(t2981*t2250+(t2051+t2074)*t2246+(t2074-t2055)*t2244))*t2240-((-t2159*t2245-t2173*t2251)*t2247+t2010)*t3189)*t2236;
    coeffs[40] = (((t3731*t728-t1233)*t2245+(t2258*t652+t2259*t648+t580)*t2244+t1922*t3437)*t2247+((t2258*t653+t2259*t650+t3626)*t2245+(t1947*t731-t1234)*t2244-t3733*t3437)*t2246-t1152*t3436)*t2225+(((-(t3725*t728+t2437)*t2245-(t939+t2330+t3058)*t2244)*t2235+t3730*(t2258*t651+t2259*t647+t586)+t60)*t2247+((-t940+t2330+t3056)*t3185+t3730*(t2258*t830+t2259*t829+t3520)-t2282)*t2246+t2950+t3729*((t2258*t654+t2259*t649+t590)*t2245+(t2258*t802+t2259*t803+t820)*t2244-t1037))*t2250+((-t1171-t3731*(t1120*t2229-t1121*t2017+t1071+t1088)-t2962*t2436)*t2245+((t3727*t781+t605)*t2259+(t3727*t818+t656)*t2258+t2251*t271+t3725*(t2254*t786+t2255*t778)+(-t2258*t3038-t2259*t956)*t2017)*t2244-t2251*t78+t3730*((t1029*t2254+t1895*t2677+t1219)*t2259+(t1034*t2255-t1699*t2239+t1218)*t2258-t1121*t3407))*t2247+(((t3727*t779+t604)*t2259+(t3727*t784+t603)*t2258-t2251*t274+t3725*(-t2901+t3626)+(t2258*t3744-t2259*t960)*t2017)*t2245+(t2251*t233+t3725*(t1027*t2255+t1028*t2254+t1024)-t1947*(t1124*t2229+t2017*t3741+t1077+t1089))*t2244+t2251*t30+t3730*((t1033*t2255+t2254*t979-t3564)*t2259+(t1030*t2254+t2255*t961-t3563)*t2258+t2251*t593))*t2246+t2251*t4+t3729*((t2201*t801+t2209*t804)*t2245+((t2254*t783+t1531)*t2259+t787*t2201)*t2244+(((-t1890*t3131-t2726)*t2259+t3020*t2258+t3522)*t2245+(t2258*t3745-t3543-t595)*t2244+t2845)*t2251);
    coeffs[41] = (((t1482-t3849)*t2247-t1612*t3108)*t2250+t2251*(-t1611*t3119+t2246*(t1470-t3467)))*t2211+(((t1211-t2725+(-t1967*t2239-t2770)*t2243-t2240*(t1961*t2242+t1990))*t2247+(t1410*t3165+t1612*t1908)*t2246+((t1968*t2239+t2013)*t2243+t2240*(t1962*t2242+t1993))*t2245-t3733*t1482)*t2250+(t1598*t3327+((-t1974*t2239-t2776)*t2243+t2727+(t1975*t2242-t2777)*t2240)*t2244+t1611*t3407)*t2247+(((t1975*t2239-t2776)*t2243-t2728+(-t1974*t2242-t2777)*t2240)*t2245+(t1398*t3162+t1688*t3143+t2159*t3217+t2161*t3214)*t2244-t2251*((t1961*t2239+t2770)*t2243+t2240*(t1967*t2242+t1990)))*t2246-t2251*(t1609*t3368-t2244*((t1962*t2239+t2013)*t2243+t2240*(t1968*t2242+t1993))))*t2235+(-t1037+((-t1195*t2243+t1271*t2240)*t2247+(-t1189*t2240-t1193*t2243)*t2245)*t2236+((t1144*t2239+t1145*t2242)*t2247-(t2240*t905+t2243*t911)*t2246+(-t1139*t2239-t1141*t2242)*t2245+(t2240*t904+t2243*t913)*t2244)*t2237)*t2250+((t1160*t2239+t1162*t2242)*t3166+(-t2689+(-t2095+t3370)*t2239)*t1973+(-(t2239*t920+t2242*t921)*t2245+(-t1155*t2240-t1157*t2243)*t2244+(-t2239*t905-t2242*t911)*t2251)*t2236)*t2247+(((t1160*t2240+t1162*t2243)*t2245+(t1144*t2240+t1145*t2243)*t2251)*t2236+((-t1155*t2239-t1157*t2242)*t2245-(t2240*t920+t2243*t921)*t2244+(-t1195*t2242+t1271*t2239)*t2251)*t2237+(t1923*t3143+t2215*t3132-t2702)*t1973)*t2246+((t3170*t913+t1564)*t2242+t904*t2742+t2289*t1976)*t2245+(t1976*t2765+(-t1141*t3170-t1976*t2697+t1564)*t2243+(-t1193*t3162-t1976*t3219)*t2242-t2251*(t1139*t3173+t1189*t3167))*t2244+t2251*t2845;
    coeffs[42] = (((t1439*t2723+t2605*t2734)*t2247-t1440*t2492)*t2250+t2251*(-t1440*t2498+(t1439*t2738+t2605*t2719)*t2246))*t2216+((((t3166*t792-t3172*t813)*t2247-t791*t2718)*t2250+t2251*(-t791*t2741+(-t3166*t813+t3172*t792)*t2246))*t2238+((t2487-(-t1005*t2258+t1486*t2259)*t2244)*t2247+((-t1006*t2258+t1485*t2259)*t2245+t1947*t2843)*t2246)*t2225+(t492*t2222+(t2376*t2220+(t2259*t763-t2574*t2962)*t3185-t2244*(-t2376*t2244+(t1908*t2205+t1204*t2259+(t1908*t2201-t3470)*t2258)*t2235))*t2247+(t492*t2246+(t3733*t2203-t3048*t2259+(t2200*t3733-t3470)*t2258)*t3185-t1976*t2435)*t2246)*t2250-t2251*(-t480*t2222+(-t2244*(t1922*t2758+(-t1416*t2254+(t2240*t2636-t3180*t3727)*t2242)*t2259+(t1922*t2746+t2255*t828)*t2258)+(t1976*t3415-t2449-t2244*(-t1976*t3409+(-t1912*t2185-t2181*t2235)*t2258))*t2239)*t2247+(-t480*t2246+t2290*t2220+((t1235*t2255+t3302)*t2259+(t1913*t2185*t2239+t2255*t827)*t2258+(t2255*t2523+(-t2200*t2230+t3836)*t2239)*t2235)*t2245-t2244*(-t2290*t2244+(t2757-t3734*t2154+(t1711+t1418)*t2254)*t2259-t2962*t2333))*t2246))*t2241+t2238*((((-t1443*t2735+t1448*t2724)*t2247-t1449*t2493)*t2250+t2251*(-t1449*t2499+t2246*(-t1443*t2720+t1448*t2739)))*t2238+((-t2470-(t1002*t2259-t1486*t2258)*t2244)*t2247-((t1001*t2259+t1485*t2258)*t2245+t1947*t2841)*t2246)*t2225+(t488*t2222+(-t751*t2220-(-t2234*t1860+(-t2962*t3128-t763)*t2258)*t3185-t2244*(t751*t2244+(t1908*t2204-t2893+(t1908*t3066+t3048)*t2258)*t2235))*t2247+(t488*t2246+(t1881*t2258+t2252*t3863-t2893)*t3185+t3730*t2666)*t2246)*t2250-t2251*(t484*t2222+(-t1976*t2862+t2242*t2449-(t1976*t2861+(t2254*t2423-t2412)*t2259+(-t1452*t3131+t2109*t3147)*t2258)*t2244)*t2247+t2246*(t484*t2246+t747*t2220+((-t2254*t2422+t2412)*t2259+(t2239*t2452-t3302)*t2258)*t2245+t2244*(t747*t2244+t2962*t2764-(t1452*t2154-(-t1711+t1417)*t2254)*t2258))+(t2246*((t1906*t2204+(t1906*t3066+t2760-t2254*(t2394-t2674))*t2258)*t2245+t2244*(-t2962*t3190-(t2962*t3122+t3400)*t2258))+(-t3800*t3119+(-t3108+t3119)*t3763)*t2252)*t2235));
    coeffs[43] = (((t2161*t2734-t2176*t2723)*t2247+t2177*t2492)*t2250-t2251*(-t2177*t2498+(-t2161*t2719+t2176*t2738)*t2246))*t2216+((((-t1426*t3166+t1688*t3172)*t2247+t1427*t2718)*t2250-t2251*(-t1427*t2741+(t1426*t3172-t1688*t3166)*t2246))*t2238+(((-(t1399*t2259+t3322)*t2245+(t1920*t2259+t1998-t3391)*t2244)*t2235+t2376)*t2247+(-(-t1916*t2259+t1998-t3355)*t3185-t1976*t3395)*t2246+t492)*t2250+(t2487+((-t1904*t3147-t2023+t2026)*t2259+(t1131*t2255-t1910*t3148)*t2258+t1922*t2751)*t2244-t2239*t2863)*t2247+(((t1727*t2255-t2477-t2500)*t2259+(t1127*t2255-t1911*t3148)*t2258-t1906*t2749)*t2245+((-t1899*t2154+t1904*t2152+t1714)*t2259+t1943*t3321)*t2244-t2251*t2290)*t2246+t2251*t480)*t2241-((((-t2159*t2735+t2171*t2724)*t2247-t2173*t2493)*t2250+t2251*(-t2173*t2499+t2246*(-t2159*t2720+t2171*t2739)))*t2238+((((t1399*t2258-t1860)*t2245-(t1916*t2258+t2007-t3392)*t2244)*t2235+t751)*t2247+((-t1920*t2258+t2007-t3356)*t3185-t2666)*t2246-t488)*t2250+(t2470+((t1116*t2254+t2022+t2035)*t2259+(t1900*t3131-t2239*(t2110-t2752))*t2258-t1922*t2752)*t2244-t2242*t2863)*t2247+(((t1115*t2254-t2022+t2035)*t2259+(t1728*t2254+t2023+t2028)*t2258+t1906*t2750)*t2245+((-t1900*t2154+t1903*t2152-t1714)*t2258-t2342*t2962)*t2244+t2251*t747)*t2246+t2251*t484)*t2238;
    coeffs[44] = (((-t1973*t2694-t2705*t2962)*t2247+t1976*t2475)*t2250-t2251*(-t1976*t2482+t2246*(t1973*t2707+t2692*t2962)))*t2216-(((-t1925*t3311-t1946*t3319)*t2247+t1976*t2855)*t2250-t2251*(-t1976*t2859+(t1923*t3310+t1948*t3320)*t2246))*t3158-(((-t1973*t2663-t2680*t2962)*t2247+t1976*t2453)*t2250-t2251*(-t1976*t2459+t2246*(t1973*t2682+t2661*t2962)))*t2214;
    coeffs[45] = (t206*t2224+(t206*t2248+t2817*t763)*t2248)*t2213-(-t2271*t2224+t763*t2515+(-t2248*t2271+t2817*t766)*t2248)*t3175+(t766*t2515+t2126*(t2434*t773-t2540))*t2212;
    coeffs[46] = (t2126*t2560+t2248*t3970+t206)*t2213+(t20*t2248-t2126*t3968-t2249*t3970+t2271)*t3175-(t20*t2249+t2126*t3976-t2922*t3729+t2540)*t2212;
    coeffs[47] = (t2248*t27+t2126*(t2246*t319+(-t3892-t2567)*t2244)+t2560)*t2213-(t2248*t28+t2249*t27+t2126*(t2246*t320+t2247*t319+t3729*(-t1406*t2244-t3840)-t3940)+t3968)*t3175+(t2249*t28+t2126*(t3959+(t550-t3692)*t2245)-t3976)*t2212;
    coeffs[48] = (t2224*t2531-(-t2248*t2531+t3639)*t2248)*t2213+((t2224*t2907+t3639*t2249+t2248*(t2248*t2907+t2337))*t2236+t3*t2224+(-t210*t2222-(t210*t2246-t2235*t2928)*t2246)*t2249+(t3*t2248+t44*t2222-t3726*t2538+(t2246*t44-t2816*t773)*t2246)*t2248)*t2237-t2236*((-t2126*t3107*t3547+t2249*t2337)*t2236-t2951*t2224+(t43*t2222+t2812*t3610+t2246*(t2246*t43+t3730*t682))*t2249-(t2951*t2248+t767*t2512-t3729*(t2578*t766+t2536))*t2248);
    coeffs[49] = ((-t2445-t3942)*t2248+t3921*t2246+t2126*(t1602*t2246-t2244*t3705)+(-t2567-t3865)*t2244)*t2213+(t3942*t2249+(t2446-t3941)*t2248-t3921*t2247+t3944*t2246+t3865*t2245-t2244*t3623+t3729*t3047+t2126*(-t1602*t2247-t1603*t2246+t3047)+t1598*t2372)*t3175+(t3941*t2249-t1605*t3208-t3944*t2247+t2245*(-t1465+t3623)-t1599*t2372+t2126*(t1603*t2247-t1605*t2245))*t2212;
    coeffs[50] = -t175*t2767+((t175*t3094+(t175*t2247+t2245*t2593)*t2248+t2907+t3702*t3904)*t2236+(-t2930+t3729*(t2438+t2909))*t2249+(t3729*t38+t3652)*t2248+t3+t2126*t1)*t2237+t2236*((-t175*t3089+(t2247*t3973-t2249*t2593)*t2245)*t2236+(t3673*t3729-t3557)*t2249+((-t2219*t3732-t3332)*t766+t3729*(-t2908+t3771))*t2248+t2951+t2126*t3943)+((t2246*t3973-t2248*t2593)*t2213+((t2236*t2593-t318)*t2237-t2236*t166)*t2249)*t2244+((-t169*t3094+(-t2942*t2247-(t3730*t550+t696)*t2246-t763*t3267)*t2248)*t2237+t2236*((-(-t3730*t3892+t3610)*t2247+t129*t2246+t764*t3278)*t2249+(-t2922-t3622)*t2248))*t2235;
    coeffs[51] = (t1261*t2239+t1263*t2242)*t2213-(-t1260*t2239+t1261*t2240+t1263*t2243+t2242*t3723)*t3175-(t1260*t2240-t2243*t3723)*t2212;
    coeffs[52] = -t321*t2767+((t135*t2248-t1398*t3702+t3094*t321+t3904*t3926)*t2236+(-t319*t3184+t2438+t3729*(t1399*t1939+t1209))*t2249+(t3729*(t611+t3053)+(-t3958*t2247-(-t1406*t3730+t550)*t2246)*t2235+t38)*t2248+t1+t2126*((-t1402*t1922+t1209)*t2247+(t2627-t3051)*t2246+t348))*t2237-((t135*t2249+t3107*t3675)*t2236+(t3729*(t607+t3051)+((-t3705*t3730-t3892)*t2247-(t2304+t3684)*t2246)*t2235-t3673)*t2249+(t3729*(-t1400*t3732-t2899)+(t2245*t550+t3959)*t2235-t3771)*t2248+t2126*((-t3679-t3053)*t2247+(t1403*t3733-t2899)*t2246+t356)-t3943)*t2236+(t3674*t2248*t2213+(t2235*t3892-t2236*t3674)*t3163-t3675*t3220)*t2244;
    coeffs[53] = t2286*t2224+(t17*t2222+(t2298*t2220-t2244*(-t2244*t2298-t3293*t397))*t2247+t2246*(t17*t2246+t63*t2220-t396*t2797+t2244*(t2244*t63+t3837*t398)))*t2249-t2248*(-t2286*t2248+t18*t2222+(t3801*t2220+t2437*t2789-t2244*(-t2244*t3801-t3281*t399))*t2247+t2246*(t18*t2246+t2283*t3730-t2808*t401));
    coeffs[54] = (t2248*t2391-t2644)*t2213+((-t1398*t3926+t2248*t3690-t2249*t2391)*t2236+(-t1097*t2242+(t1537*t2248+t1539*t2246+t1540*t2244)*t2239+((-t2167*t2244+t2169*t2246)*t2248+t1983)*t2235)*t2243+t1098*t2217+((t1538*t2248+t1684*t2246-t1685*t2244)*t2240+(-t1424*t2247+t1425*t2245+t1687*t2249)*t2239-(-t2131*t3253+t2167*t3108-t2169*t3119+t2249*t2546)*t2235)*t2242+(-t1096*t2239+((-t2163*t2244+t2165*t2246)*t2248+t1982)*t2235)*t2240-t2239*(t1040+(-t2131*t3259+t2163*t3108-t2165*t3119+t2249*t2547)*t2235))*t2237+t2236*((-t2249*t3690-t2647)*t2236+t1097*t2218+(-t1098*t2242+(-t1424*t2246+t1425*t2244+t1687*t2248)*t2240+(t1538*t2249+t1684*t2247-t1685*t2245)*t2239+(t2133*t3252-t2167*t3119+t2169*t3108+t2248*t3826)*t2235)*t2243+((t1537*t2249+t1539*t2247+t1540*t2245)*t2240-((-t2050+t3244)*t2249-t2161*t3107)*t2235)*t2242+t1096*t2215+(t1040+(t2133*t3258-t2163*t3119+t2165*t3108+t2248*t2982)*t2235)*t2240-((-t2047+t3249)*t2249-t2159*t3107)*t3189);
    coeffs[55] = (((t1121*t2127+t2332+t3060)*t3186+t3730*((t1890*t1906+t1642)*t2257+(t1887*t1906-t2880)*t2256-t1906*t1121)+t2298)*t2247+(-(t1120*t3727+t2332+t3061)*t3185-(t3726*t731-t398)*t3186+t63+t3730*((-t953+t3743)*t2257+(-t971+t968)*t2256+t593))*t2246+t17+t3729*((((-t2217*t2235+t2242*t3139)*t2255-t1890*t3147-t2726)*t2257+(-t1887*t3131+t3020)*t2256+t3522)*t2245+((-t949+t955)*t2257+(t1508+t3745)*t2256-t595)*t2244+t2846))*t2249+(((-(t3726*t728+t2437)*t2245-(t939+t2331+t3059)*t2244)*t2235+t3730*(t2256*t651+t2257*t647+t586)-t3801)*t2247+((-t940+t2331+t3057)*t3185+t3730*(t2256*t830+t2257*t829+t3520)-t2283)*t2246+t3729*((t2256*t654+t2257*t649+t590)*t2245+(t2256*t802+t2257*t803+t820)*t2244-t1036)-t18)*t2248+t2286+t2126*(((t1939*t728-t1233)*t2245+(t2256*t652+t2257*t648+t580)*t2244-t1035)*t2247+((t2256*t653+t2257*t650+t3626)*t2245+(t3732*t731-t1234)*t2244+t2852)*t2246+t2900);
    coeffs[56] = ((-t3705*t3119+(-t3467+t3848)*t2246)*t2249-t2248*((-t3466+t3849)*t2247+t1605*t3108))*t2211+(((t1404*t2236*t2244+t1906*t3705)*t2247+(-t2744+t1398*t3166+(-t1951*t2239-t2772)*t2243-t2240*(t1953*t2242+t1989))*t2246-t1602*t3368+t2244*((t1952*t2239+t2012)*t2243+t2240*(t1954*t2242+t1992)))*t2249+((t1211-t1401*t3166+(-t1953*t2239-t2772)*t2243-t2240*(t1951*t2242+t1989))*t2247+(t1404*t3165+t1605*t1908)*t2246+((t1954*t2239+t2012)*t2243+t2240*(t1952*t2242+t1992))*t2245-t3733*t3466)*t2248+(t1598*t3336-t2244*((t1957*t2239+t2014)*t2243-t2240*(t1958*t2242-t2778)))*t2247-(((-t1958*t2239+t2014)*t2243+t2240*(t1957*t2242+t2778))*t2245-t3732*t3467)*t2246)*t2235+(t2846+((-t1194*t2242+t1269*t2239)*t2246+(-t1188*t2239-t1192*t2242)*t2244)*t2237+(-(t2239*t903+t2242*t910)*t2247+(t1137*t2240+t1138*t2243)*t2246+(t2239*t902+t2242*t912)*t2245+(-t1135*t2240-t1136*t2243)*t2244)*t2236)*t2249+(-t1036+((-t1194*t2243+t1269*t2240)*t2247+(-t1188*t2240-t1192*t2243)*t2245)*t2236+((t1137*t2239+t1138*t2242)*t2247-(t2240*t903+t2243*t910)*t2246+(-t1135*t2239-t1136*t2242)*t2245+(t2240*t902+t2243*t912)*t2244)*t2237)*t2248+(-t1035+(t1159*t2239+t1169*t2242)*t3166+(-(t2239*t918+t2242*t919)*t2245+(-t1154*t2240-t1168*t2243)*t2244)*t2236)*t2247+(t2852+(t1159*t2240+t1169*t2243)*t3172+((-t1154*t2239-t1168*t2242)*t2245-(t2240*t918+t2243*t919)*t2244)*t2237)*t2246+t2900;
    coeffs[57] = ((-t1438*t2498+t2246*(t1436*t2738+t2605*t2721))*t2249-t2248*((-t1436*t2723-t2605*t2736)*t2247+t1438*t2492))*t2216+(((-t789*t2741+(-t3166*t812+t3172*t790)*t2246)*t2249-((-t3166*t790+t3172*t812)*t2247+t789*t2718)*t2248)*t2238+t223*t2224+(t479*t2222+(t2220*t2711+t2244*(t2244*t2711+(t1922*t2182+(-t1576*t2254-t2760)*t2257+(t1922*t2193-t3471)*t2256)*t2235))*t2247-(-t479*t2246-t2374*t2220+(t1906*t2189+(t2252*t2563-t1878)*t2257+(t1906*t2195-t3471)*t2256)*t3185-t2244*(t2374*t2244+(t2257*t766-t2572*t2962)*t2235))*t2246)*t2249+(t223*t2248+t491*t2222+(t2377*t2220+(t2257*t763-t2962*t3268)*t3185-t2244*(-t2377*t2244+(t1908*t2189+t1204*t2257+(t2856-t3470)*t2256)*t2235))*t2247+(t491*t2246+(t3733*t2182-t3048*t2257+(t2193*t3733-t3470)*t2256)*t3185+t2958*t2435)*t2246)*t2248)*t2241+t2238*(((-t1447*t2499+t2246*(-t1443*t2722+t1445*t2739))*t2249-((t1443*t2737-t1445*t2724)*t2247+t1447*t2493)*t2248)*t2238+t224*t2224+(-t483*t2222+(-t2220*t2685+t2244*(-t2244*t2685+(-t1442*t3129+t1878*t2256)*t2235+t3969*t3181))*t2247-t2246*(t483*t2246+t746*t2220+((-t1442*t2257+t2193*t2230)*t2242+(t3412+(t1576+t3405)*t2256)*t2254)*t3185+t2244*(t746*t2244+(-t2962*t3193+(-t2962*t3124-t766)*t2256)*t2235)))*t2249+t2248*(t224*t2248+t487*t2222+(-t750*t2220-(-t2232*t1860+(-t2962*t3130-t763)*t2256)*t3185-t2244*(t750*t2244+(t1908*t2186-t2668+(t1908*t2194+t3048)*t2256)*t2235))*t2247+t2246*(t487*t2246+(t1881*t2256+t2252*t3862-t2668)*t3185-t3730*t2667)));
    coeffs[58] = ((t2169*t2498-t2246*(-t2161*t2721+t2167*t2738))*t2249+t2248*((t2161*t2736-t2167*t2723)*t2247+t2169*t2492))*t2216+(((t1425*t2741-t2246*(t1424*t3172-t1687*t3166))*t2249+((-t1424*t3166+t1687*t3172)*t2247+t1425*t2718)*t2248)*t2238+((-(-t1915*t2257-t1922*t2253+t1988)*t3186+t2711)*t2247+(((-t1906*t2255+t1919*t2257+t1988)*t2245-(t1400*t2257+t3321)*t2244)*t2235+t2374)*t2246+t479)*t2249+(((-(t1399*t2257+t3322)*t2245+(t1920*t2257+t1997-t3391)*t2244)*t2235+t2377)*t2247+(-(-t1916*t2257+t1997-t3355)*t3185+t1908*t3315)*t2246+t491)*t2248+t223)*t2241-(((-t2165*t2499+t2246*(-t2159*t2722+t2163*t2739))*t2249-((t2159*t2737-t2163*t2724)*t2247+t2165*t2493)*t2248)*t2238+(((-t1919*t2256-t1922*t2252+t2005)*t3186+t2685)*t2247+((-(t1915*t2256+t2005-t3406)*t2245+(t1400*t2256-t2243*t2962)*t2244)*t2235+t746)*t2246+t483)*t2249+((((t1399*t2256-t1860)*t2245-(t1916*t2256+t2006-t3392)*t2244)*t2235+t750)*t2247+((-t1920*t2256+t2006-t3356)*t3185+t2667)*t2246-t487)*t2248-t224)*t2238;
    coeffs[59] = ((-t2958*t2482-t2246*(t2693*t2962-t2707*t2959))*t2249+t2248*((t2694*t2959-t2706*t2962)*t2247-t2958*t2475))*t2216-((-t2958*t2859-t2246*(-t1923*t3317+t1942*t3320))*t2249+t2248*((t1925*t3318-t1940*t3319)*t2247-t2958*t2855))*t3158-((-t2958*t2459-(t2662*t2962-t2682*t2959)*t2246)*t2249+((t2663*t2959-t2681*t2962)*t2247-t2958*t2453)*t2248)*t2214;

    return coeffs;
}
}  // ValtonenOrnhagArxiv2021
}  // DronePoseLib
