"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.BudgetNotifier = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_budgets_1 = require("@aws-cdk/aws-budgets");
const core_1 = require("@aws-cdk/core");
const NotificationType_1 = require("./NotificationType");
const TimeUnit_1 = require("./TimeUnit");
/**
 * @stability stable
 */
class BudgetNotifier extends core_1.Construct {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        super(scope, id);
        this.validateProperties(props);
        const costFilters = this.createCostFilters(props);
        const subscribers = this.createSubscribers(props);
        new aws_budgets_1.CfnBudget(this, 'MonthlyBudget_' + id, {
            budget: {
                budgetType: 'COST',
                timeUnit: props.timeUnit ? props.timeUnit : TimeUnit_1.TimeUnit.MONTHLY,
                budgetLimit: {
                    amount: props.limit,
                    unit: props.unit,
                },
                costFilters: costFilters,
            },
            notificationsWithSubscribers: [
                {
                    notification: {
                        comparisonOperator: 'GREATER_THAN',
                        threshold: props.threshold,
                        thresholdType: 'PERCENTAGE',
                        notificationType: props.notificationType
                            ? props.notificationType
                            : NotificationType_1.NotificationType.ACTUAL,
                    },
                    subscribers: subscribers,
                },
            ],
        });
    }
    validateProperties(props) {
        if (props.recipients && props.recipients.length > 10) {
            throw new Error('The maximum number of 10 e-mail recipients is exceeded.');
        }
        if (props.threshold <= 0) {
            throw new Error('Thresholds less than or equal to 0 are not allowed.');
        }
    }
    createSubscribers(props) {
        const subscribers = new Array();
        if (props.recipients) {
            for (const recipient of props.recipients) {
                subscribers.push({
                    address: recipient,
                    subscriptionType: 'EMAIL',
                });
            }
        }
        if (props.topicArn) {
            subscribers.push({
                address: props.topicArn,
                subscriptionType: 'SNS',
            });
        }
        return subscribers;
    }
    createCostFilters(props) {
        const tags = [];
        if (props.application) {
            tags.push('user:Application$' + props.application);
        }
        if (props.costCenter) {
            tags.push('user:Cost Center$' + props.costCenter);
        }
        if (props.service) {
            tags.push('user:Service$' + props.service);
        }
        const costFilters = {};
        if (tags && tags.length > 0) {
            costFilters.TagKeyValue = tags;
        }
        const availabilityZones = [];
        if (props.availabilityZones) {
            for (const az of props.availabilityZones) {
                availabilityZones.push(az);
            }
            costFilters.AZ = availabilityZones;
        }
        return costFilters;
    }
}
exports.BudgetNotifier = BudgetNotifier;
_a = JSII_RTTI_SYMBOL_1;
BudgetNotifier[_a] = { fqn: "aws_budget_notifier.BudgetNotifier", version: "0.3.14" };
//# sourceMappingURL=data:application/json;base64,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