import { HttpRouteIntegrationBindOptions, HttpRouteIntegrationConfig } from '@aws-cdk/aws-apigatewayv2-alpha';
import * as servicediscovery from 'aws-cdk-lib/aws-servicediscovery';
import { HttpPrivateIntegrationOptions } from './base-types';
import { HttpPrivateIntegration } from './private/integration';
/**
 * (experimental) Properties to initialize `HttpServiceDiscoveryIntegration`.
 *
 * @experimental
 */
export interface HttpServiceDiscoveryIntegrationProps extends HttpPrivateIntegrationOptions {
}
/**
 * (experimental) The Service Discovery integration resource for HTTP API.
 *
 * @experimental
 */
export declare class HttpServiceDiscoveryIntegration extends HttpPrivateIntegration {
    private readonly service;
    private readonly props;
    /**
     * @param id id of the underlying integration construct.
     * @param service the service discovery resource to integrate with.
     * @param props properties to configure the integration.
     * @experimental
     */
    constructor(id: string, service: servicediscovery.IService, props?: HttpServiceDiscoveryIntegrationProps);
    /**
     * (experimental) (experimental) Bind this integration to the route.
     *
     * @experimental
     */
    bind(_: HttpRouteIntegrationBindOptions): HttpRouteIntegrationConfig;
}
